(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   5088459,      94559]
NotebookOptionsPosition[   5047706,      93862]
NotebookOutlinePosition[   5048147,      93879]
CellTagsIndexPosition[   5048104,      93876]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Main analysis", "Section",
 CellChangeTimes->{{3.9087455468301744`*^9, 
  3.908745551167593*^9}},ExpressionUUID->"422c745c-b70b-4ca7-9578-\
01ccce787e2e"],

Cell[CellGroupData[{

Cell["Importing the data (insert the right folder)", "Subsection",
 CellChangeTimes->{{3.907494246859004*^9, 3.9074942525661936`*^9}, {
  3.9268409681370955`*^9, 
  3.9268409791530933`*^9}},ExpressionUUID->"5a4acb3a-3a3e-486c-bcdd-\
08185465a2e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C://Users//mp2522//My \
Drive//Docs(Work)//Articoli//Completed//Ants//PNAS Nexus Final \
submission//Code for public use\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.907493646356467*^9, 3.907493697253833*^9}, {
   3.9265141154493704`*^9, 3.926514129795834*^9}, {3.9268409909685116`*^9, 
   3.926840991446021*^9}, {3.927619004567769*^9, 3.9276190468128843`*^9}, 
   3.9276191472841587`*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"52b919b1-8655-4dd3-a030-02ad13eb9e0f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DataNBName", "=", 
   RowBox[{"Import", "[", "\"\<N_B.xlsx\>\"", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9074936986187487`*^9, 3.907493729308641*^9}, {
  3.907493760812703*^9, 3.9074938012205553`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"39e1068f-1a1e-4364-a5fd-42b351d825d0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DataTrack05", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//05.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack05s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//05s.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack14", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//14.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack14s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//14s.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack23", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//23.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack23s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//23s.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack43", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//43.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack43s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//43s.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack54", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//54.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack54s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//54s.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack07", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//07.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack07s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//07s.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack21", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//21.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack21s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//21s.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack47", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//47.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataTrack47s", "=", 
   RowBox[{"Import", "[", "\"\<tracksincsv//47s.csv\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074939704581556`*^9, 3.907493980961998*^9}, {
   3.9074940124490194`*^9, 3.9074940572276354`*^9}, {3.9074940951662245`*^9, 
   3.907494232429291*^9}, 3.927619064360524*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"3529cca5-1c96-40d1-898f-e748d10c4bee"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Organizing the data and converting in the right units of mm and s\
\>", "Subsection",
 CellChangeTimes->{{3.907494264138963*^9, 3.9074942716424885`*^9}, {
  3.9074943173086777`*^9, 
  3.907494328901267*^9}},ExpressionUUID->"84258800-03a3-45ff-902a-\
ab46e3659545"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]d", "=", "0.204248"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{"1", "/", "3."}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ts", "=", "91"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncol", "=", "16"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9074943333165755`*^9, 3.907494375750762*^9}, {
   3.9074951037872047`*^9, 3.907495106815092*^9}, 3.9074955090719523`*^9, {
   3.9074959817983027`*^9, 3.907495982153135*^9}, {3.9074961622302303`*^9, 
   3.9074961656275015`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"21f42c88-edcc-4cd8-9a99-bef613eddab4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ntab", "=", 
  RowBox[{"Round", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"DataNBName", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "i", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9074938051303344`*^9, 3.907493886121847*^9}, {
   3.9074940771459646`*^9, 3.907494078753189*^9}, {3.907494452950056*^9, 
   3.907494496003599*^9}, 3.9074961693263817`*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"f49cbbfa-c7f5-45cd-a39b-8dd2ceb642d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "239", ",", "120", ",", "162", ",", "75", ",", "83", ",", "40", ",", "254", 
   ",", "126", ",", "292", ",", "146", ",", "326", ",", "157", ",", "360", 
   ",", "175", ",", "400", ",", "200"}], "}"}]], "Output",
 CellChangeTimes->{{3.9074938651556883`*^9, 3.9074938789975195`*^9}, 
   3.9074940929417686`*^9, {3.9074944716511974`*^9, 3.9074944963411293`*^9}, 
   3.907512025342375*^9, 3.9075777146348057`*^9, 3.907686901445568*^9, 
   3.9078544585068407`*^9, 3.907872861043013*^9, 3.9079128707763767`*^9, 
   3.9082891294204435`*^9, 3.908435752446231*^9, 3.908527354845532*^9, 
   3.9085517424827013`*^9, 3.908711955362376*^9, 3.908712120560454*^9, 
   3.90882006599968*^9, 3.908864891800149*^9, 3.9089149501881*^9, 
   3.908916627464345*^9, 3.909053701169736*^9, 3.9090543433713818`*^9, 
   3.9091381838608913`*^9, 3.909138738808509*^9, 3.9092152983705993`*^9, 
   3.909487398477667*^9, 3.909487635247979*^9, 3.9100878458310213`*^9, 
   3.9100922541787434`*^9, 3.9101052012823477`*^9, 3.9101691533603053`*^9, 
   3.9276191800385427`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"3dd0a3bf-cb57-4462-86a7-2aaa280fd3dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Btab", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DataNBName", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "i", ",", "2"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.907493891062557*^9, 3.9074938938546653`*^9}, {
   3.907494082063024*^9, 3.907494083571789*^9}, 3.9074961709720464`*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"6af6831f-5335-4b75-8655-31335c8a676b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.075`", ",", "2.349`", ",", "3.254`", ",", "2.402`", ",", "1.403`", ",", 
   "0.858`", ",", "3.121`", ",", "2.578`", ",", "3.279`", ",", "2.4`", ",", 
   "3.973`", ",", "1.742`", ",", "4.699`", ",", "2.633`", ",", "5.097`", ",", 
   "2.461`"}], "}"}]], "Output",
 CellChangeTimes->{3.9074938940890493`*^9, 3.9074940915993533`*^9, 
  3.907512025406164*^9, 3.9075777146555185`*^9, 3.9076869014555936`*^9, 
  3.907854458518421*^9, 3.9078728610731163`*^9, 3.907912870804916*^9, 
  3.908289129444439*^9, 3.908435752461967*^9, 3.9085273548632994`*^9, 
  3.908551742498695*^9, 3.908711955383395*^9, 3.9087121205935044`*^9, 
  3.908820066015535*^9, 3.9088648918206625`*^9, 3.9089149502104387`*^9, 
  3.9089166275122533`*^9, 3.9090537012202587`*^9, 3.909054343409604*^9, 
  3.9091381839167123`*^9, 3.9091387388534994`*^9, 3.9092152984027185`*^9, 
  3.909487398493007*^9, 3.9094876352569838`*^9, 3.910087845849015*^9, 
  3.910092254196534*^9, 3.9101052013042884`*^9, 3.910169153380252*^9, 
  3.927619180101944*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"c2d01516-44fb-4483-8711-3e1e1ef3d4f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nametab", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DataNBName", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "i", ",", "3"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.907493897031316*^9, 3.9074938996827583`*^9}, {
   3.9074940856772356`*^9, 3.907494087726144*^9}, 3.9074961732685013`*^9},
 CellLabel->"In[45]:=",ExpressionUUID->"5e3227f5-bfa7-4eb7-a03f-c4550aed27da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"'05'\"\>", ",", "\<\"'05s'\"\>", ",", "\<\"'14'\"\>", 
   ",", "\<\"'14s'\"\>", ",", "\<\"'23'\"\>", ",", "\<\"'23s'\"\>", 
   ",", "\<\"'43'\"\>", ",", "\<\"'43s'\"\>", ",", "\<\"'54'\"\>", 
   ",", "\<\"'54s'\"\>", ",", "\<\"'07'\"\>", ",", "\<\"'07s'\"\>", 
   ",", "\<\"'21'\"\>", ",", "\<\"'21s'\"\>", ",", "\<\"'47'\"\>", 
   ",", "\<\"'47s'\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.9074938999832*^9, 3.9074940899413104`*^9, 
  3.9075120254139023`*^9, 3.907577714674515*^9, 3.907686901461587*^9, 
  3.9078544585266695`*^9, 3.907872861100762*^9, 3.9079128708369737`*^9, 
  3.9082891294764037`*^9, 3.908435752461967*^9, 3.9085273548828397`*^9, 
  3.9085517425165367`*^9, 3.908711955402385*^9, 3.908712120625525*^9, 
  3.908820066025339*^9, 3.9088648918406897`*^9, 3.9089149502332788`*^9, 
  3.908916627563246*^9, 3.909053701258072*^9, 3.909054343453401*^9, 
  3.9091381839700823`*^9, 3.909138738904359*^9, 3.9092152984135485`*^9, 
  3.9094873985570617`*^9, 3.9094876352689753`*^9, 3.9100878458530045`*^9, 
  3.910092254209551*^9, 3.9101052013082776`*^9, 3.9101691533992004`*^9, 
  3.927619180164919*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"7b900faf-4738-4b53-b8d8-fc5fb50c3672"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack05", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack05", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track05", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack05", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack05", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack05"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack05s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack05s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track05s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack05s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack05s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack05s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.907494731416502*^9, 3.907494853835064*^9}, {
   3.9074949162189493`*^9, 3.907494958125019*^9}, {3.9074950108579845`*^9, 
   3.907495025997458*^9}, {3.9074950966441374`*^9, 3.9074952197211585`*^9}, 
   3.9094872818807325`*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"e48efbe2-c390-47de-97a3-7b9c428d6c02"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack14", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack14", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track14", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack14", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack14", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack14s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack14s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track14s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack14s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack14s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack14s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074952295008965`*^9, 3.9074952397267265`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"d3078bd1-ffba-43a9-b4a6-34c9aff5bea4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack23", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack23", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track23", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack23", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack23", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack23"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack23s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack23s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track23s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack23s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack23s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack23s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074952295008965`*^9, 3.907495285378807*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"644311e4-c599-4cc9-8bf2-6e62ef87a374"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack43", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack43", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track43", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack43", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack43", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack43"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack43s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack43s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track43s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack43s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack43s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack43s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074952295008965`*^9, 3.9074952397267265`*^9}, {
  3.9074952934913683`*^9, 3.907495324719016*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"752737cf-8544-4589-929d-d0d3dac48fbd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack54", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack54", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track54", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack54", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack54", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack54"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack54s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack54s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track54s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack54s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack54s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack54s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074952295008965`*^9, 3.9074952397267265`*^9}, {
  3.9074953350775785`*^9, 3.9074953667365694`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"6c3eb320-b285-46fd-9110-80ec55b6d702"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack07", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack07", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track07", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack07", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack07", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack07"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack07s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack07s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track07s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack07s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack07s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack07s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074952295008965`*^9, 3.9074952397267265`*^9}, {
  3.90749537332825*^9, 3.9074954121063237`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"9c0fe7b7-27ee-49e5-9b3c-66440d7e7ecb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack21", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack21", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track21", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack21", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack21", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack21s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack21s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track21s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack21s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack21s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack21s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074952295008965`*^9, 3.9074952397267265`*^9}, {
   3.9074954191349936`*^9, 3.907495447475069*^9}, 3.909487329789578*^9, 
   3.909487616769573*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"2524daf9-68de-4056-8579-9e12612f54a5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NTrack47", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack47", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track47", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack47", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack47", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack47"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NTrack47s", "=", 
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"Length", "[", "DataTrack47s", "]"}], "/", "Ts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Track47s", "=", 
   RowBox[{"\[CapitalDelta]d", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DataTrack47s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "3"}], 
          "]"}], "]"}], ",", 
        RowBox[{"DataTrack47s", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "Ts"}], "+", "t"}], ",", "4"}], 
          "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "NTrack47s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9074952295008965`*^9, 3.9074952397267265`*^9}, {
  3.9074954191349936`*^9, 3.9074954942154503`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"9631b866-3da6-49d5-a9ca-eed1f87217a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tracks", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "Track05", ",", " ", "Track05s", ",", " ", "Track14", ",", " ", 
     "Track14s", ",", " ", "Track23", ",", " ", "Track23s", ",", " ", 
     "Track43", ",", " ", "Track43s", ",", " ", "Track54", ",", " ", 
     "Track54s", ",", " ", "Track07", ",", " ", "Track07s", ",", " ", 
     "Track21", ",", " ", "Track21s", ",", " ", "Track47", ",", " ", 
     "Track47s"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9074959137394404`*^9, 3.9074959488349576`*^9}, {
  3.908863847193845*^9, 3.908863849604042*^9}, {3.90886399206321*^9, 
  3.908863992065203*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"9afa3dc9-d921-4d32-abb9-73095d70b72a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NTrack", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "NTrack05", ",", " ", "NTrack05s", ",", " ", "NTrack14", ",", " ", 
     "NTrack14s", ",", " ", "NTrack23", ",", " ", "NTrack23s", ",", " ", 
     "NTrack43", ",", " ", "NTrack43s", ",", " ", "NTrack54", ",", " ", 
     "NTrack54s", ",", " ", "NTrack07", ",", " ", "NTrack07s", ",", " ", 
     "NTrack21", ",", " ", "NTrack21s", ",", " ", "NTrack47", ",", " ", 
     "NTrack47s"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9074955316781645`*^9, 3.907495549834529*^9}, {
   3.9074956161664886`*^9, 3.9074956715014434`*^9}, 3.9074957268790493`*^9, 
   3.907874490900201*^9, {3.9088638736720486`*^9, 3.908863878423958*^9}, {
   3.9088639920711966`*^9, 3.9088639920722046`*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"a8cf090c-9803-4e04-96d6-360d771546ab"]
}, Closed]],

Cell[CellGroupData[{

Cell["Manually tabulating mass and contacts", "Subsection",
 CellChangeTimes->{{3.908722246566517*^9, 
  3.9087222613534813`*^9}},ExpressionUUID->"fa4a1beb-1d5c-43cd-ab1f-\
3343dfa5d39e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mtab", "=", 
   RowBox[{"{", 
    RowBox[{
    "0.97", ",", "0.50", ",", "0.86", ",", "0.42", ",", "0.32", ",", "0.16", 
     ",", "1.08", ",", "0.55", ",", "1.21", ",", "0.63", ",", "1.12", ",", 
     "0.55", ",", "1.46", ",", "0.73", ",", "1.40", ",", "0.71"}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.908536478504958*^9, 3.9085364807288256`*^9}, {
  3.908536732038933*^9, 3.908536742975884*^9}, {3.9085369296173506`*^9, 
  3.908536989691506*^9}, {3.9085370202517166`*^9, 3.9085370706818233`*^9}, {
  3.9085371014964542`*^9, 3.9085371280898995`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"2afde471-d402-44fa-991a-1ed7f063b7c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mtabwork", "=", 
   RowBox[{"{", 
    RowBox[{
    "0.78", ",", "0.40", ",", "0.56", ",", "0.26", ",", "0.30", ",", "0.14", 
     ",", "0.90", ",", "0.45", ",", "1.02", ",", "0.51", ",", "1.07", ",", 
     "0.52", ",", "1.29", ",", "0.63", ",", "1.33", ",", "0.66"}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.908835342730765*^9, 3.908835347253378*^9}, {
  3.908835407763246*^9, 3.9088356296779394`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"144ac0b0-48bf-4aed-951b-e701e93a0286"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Econ", "=", 
   RowBox[{"{", 
    RowBox[{
    "441", ",", "79", ",", "188", ",", "140", ",", "106", ",", "15", ",", 
     "119", ",", "81", ",", "275", ",", "105", ",", "862", ",", "160", ",", 
     "477", ",", "171", ",", "736", ",", "165"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9087220611838474`*^9, 3.9087220644282646`*^9}, {
  3.9087221275070577`*^9, 3.9087222339122276`*^9}, {3.9087224478056793`*^9, 
  3.9087224482062845`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"bc537b09-556f-445e-80a6-2ed72cf63846"]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualization of smallest and largest colonies: 23s and 47 ", \
"Subsection",
 CellChangeTimes->{{3.908551642813534*^9, 3.908551705012519*^9}, {
   3.908552027407722*^9, 3.9085520462569666`*^9}, 
   3.908863828898471*^9},ExpressionUUID->"f4989586-c491-47c1-b24a-\
c8bb521fe2e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "Tracks", "]"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"3be395f4-fdd1-46a7-a75d-8b11200260e4"],

Cell[BoxData["248.16132000000002`"], "Output",
 CellChangeTimes->{3.908552781158827*^9, 3.90871195652923*^9, 
  3.908712121645754*^9, 3.908820066903295*^9, 3.9088648989919186`*^9, 
  3.9089149511190324`*^9, 3.9089166309433985`*^9, 3.909053704114007*^9, 
  3.9090543460977907`*^9, 3.9091381861067057`*^9, 3.9091387402423944`*^9, 
  3.909215299545806*^9, 3.9094873994310784`*^9, 3.909487636471193*^9, 
  3.9100878471594143`*^9, 3.910092255317193*^9, 3.9101052020252576`*^9, 
  3.910169154192234*^9, 3.927619196322857*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"0da30817-5318-465b-a085-9d5855ec6b91"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Boxsize", "=", "250"}], ";"}]], "Input",
 CellChangeTimes->{{3.908551891250239*^9, 3.9085519329898195`*^9}, {
  3.908552558319603*^9, 3.908552561805988*^9}, {3.9085527836032524`*^9, 
  3.9085527841928225`*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"193c9dd3-0d24-4649-b2de-282daba43578"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Track23s", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "t"}], "]"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "NTrack23s"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Boxsize"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "Boxsize"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"i", "/", "NTrack23s"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NTrack23s"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "->", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x[mm]\>\"", ",", "\"\<y[mm]\>\"", ",", 
        "\"\<Ant 1 colony 05\>\""}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "->", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"tt", ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"AnimationRate", "->", "4"}], ",", 
   RowBox[{"AnimationRunning", "->", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.907514369659686*^9, 3.907514405751746*^9}, {
   3.9079128731798577`*^9, 3.9079129193799963`*^9}, 3.9082912774819217`*^9, {
   3.9082913112274585`*^9, 3.9082913198274364`*^9}, {3.9085517746970124`*^9, 
   3.9085517758676453`*^9}, {3.908551943509674*^9, 3.908552000761551*^9}, {
   3.9085521999222345`*^9, 3.9085522351703434`*^9}, {3.9085523351897383`*^9, 
   3.9085523674499636`*^9}, 3.908552541795682*^9, {3.908552596401513*^9, 
   3.908552605977898*^9}, {3.908552703915693*^9, 3.9085527345164366`*^9}, {
   3.9085527999272223`*^9, 3.9085528028924475`*^9}, {3.9085528990926266`*^9, 
   3.9085529256563497`*^9}, {3.908552960203041*^9, 3.9085529618290443`*^9}, 
   3.9085530166330986`*^9, {3.908553055276882*^9, 3.9085530810746517`*^9}, {
   3.9085531415978374`*^9, 3.908553141924526*^9}, {3.9085531961259756`*^9, 
   3.908553253566959*^9}, 3.9085533515980515`*^9, {3.908553393338045*^9, 
   3.908553395779484*^9}, {3.9085534916128073`*^9, 3.9085535227113132`*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"1daaefce-2fdd-4cf7-afb3-af8fe1422deb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
      33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
      51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
      69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
      87, 88, 89, 90, 91}}}, Typeset`size$$ = {360., {173., 178.73095703125}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        Table[{
          
          Part[$CellContext`Track23s, $CellContext`i, $CellContext`t$$]}, \
{$CellContext`i, 1, $CellContext`NTrack23s}], 
        PlotRange -> {{0, $CellContext`Boxsize}, {0, $CellContext`Boxsize}}, 
        PlotStyle -> Table[
          
          Hue[$CellContext`i/$CellContext`NTrack23s], {$CellContext`i, 
           1, $CellContext`NTrack23s}], Frame -> True, 
        FrameLabel -> {"x[mm]", "y[mm]", "Ant 1 colony 05"}, AspectRatio -> 
        1], "Specifications" :> {{$CellContext`t$$, {1, 2, 3, 4, 5, 6, 7, 8, 
         9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 
         26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
         43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 
         60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 
         77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91}, 
         AnimationRate -> 4, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, DefaultBaseStyle -> 
        "Animate", DefaultLabelStyle -> "AnimateLabel", SynchronousUpdating -> 
        True, ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
     ImageSizeCache->{706., {195.134033203125, 200.865966796875}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Animate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.9075143858749204`*^9, 3.9075144061438127`*^9}, 
   3.907577714869571*^9, 3.9076869016177945`*^9, 3.9078544588365016`*^9, 
   3.9078728612076445`*^9, {3.9079128711389947`*^9, 3.907912919761126*^9}, 
   3.9082891297585664`*^9, 3.9082912792361903`*^9, 3.908291312867646*^9, 
   3.9082914535634565`*^9, 3.9084357528233147`*^9, 3.9085273551584597`*^9, 
   3.908551777325412*^9, {3.9085519783375425`*^9, 3.9085520013615847`*^9}, 
   3.908552204718673*^9, 3.908552235657955*^9, 3.9085523375224104`*^9, 
   3.908552368267995*^9, 3.9085524059010134`*^9, {3.9085525129740953`*^9, 
   3.90855254221856*^9}, {3.908552599849906*^9, 3.9085526064628973`*^9}, {
   3.908552711395269*^9, 3.908552735018399*^9}, {3.9085527861400204`*^9, 
   3.9085528034797187`*^9}, 3.9085529263660116`*^9, 3.9085529623569775`*^9, 
   3.908553017175021*^9, 3.90855309948462*^9, 3.9085531429002223`*^9, {
   3.9085532015160475`*^9, 3.9085532543254805`*^9}, 3.908553396346727*^9, {
   3.908553498745941*^9, 3.9085535232681684`*^9}, 3.9087119566236167`*^9, 
   3.9087121217005568`*^9, 3.9088200669337606`*^9, 3.908864899106453*^9, 
   3.9089149511670294`*^9, 3.9089166310750732`*^9, 3.909053704231941*^9, 
   3.9090543462081842`*^9, 3.9091381861981306`*^9, 3.9091387403361216`*^9, 
   3.9092152996002703`*^9, 3.9094873994709044`*^9, 3.909487636585908*^9, 
   3.910087847202366*^9, 3.9100922553519154`*^9, 3.9101052020631895`*^9, 
   3.9101691542470527`*^9, 3.9276191965600586`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"45a7315e-e781-43b1-95d9-0db27115689d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Track47", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "t"}], "]"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "NTrack47"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Boxsize"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "Boxsize"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"i", "/", "NTrack47"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "NTrack47"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "->", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x[mm]\>\"", ",", "\"\<y[mm]\>\"", ",", 
        "\"\<Ant 1 colony 05\>\""}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "->", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"tt", ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"AnimationRate", "->", "4"}], ",", 
   RowBox[{"AnimationRunning", "->", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.907514369659686*^9, 3.907514405751746*^9}, {
   3.9079128731798577`*^9, 3.9079129193799963`*^9}, 3.9082912774819217`*^9, {
   3.9082913112274585`*^9, 3.9082913198274364`*^9}, {3.9085517746970124`*^9, 
   3.9085517758676453`*^9}, {3.908551943509674*^9, 3.908552000761551*^9}, {
   3.9085521999222345`*^9, 3.9085522351703434`*^9}, {3.9085523351897383`*^9, 
   3.9085523674499636`*^9}, 3.908552541795682*^9, {3.908552596401513*^9, 
   3.908552605977898*^9}, {3.908552703915693*^9, 3.9085527345164366`*^9}, {
   3.9085527999272223`*^9, 3.9085528028924475`*^9}, {3.9085528990926266`*^9, 
   3.9085529256563497`*^9}, {3.908552960203041*^9, 3.9085529618290443`*^9}, 
   3.9085530166330986`*^9, {3.908553055276882*^9, 3.9085530810746517`*^9}, {
   3.9085531415978374`*^9, 3.908553141924526*^9}, {3.9085531961259756`*^9, 
   3.908553253566959*^9}, 3.9085533515980515`*^9, {3.908553393338045*^9, 
   3.908553427158492*^9}, {3.9085535554833527`*^9, 3.908553556298864*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"8a388de5-5f87-43b0-8c1d-8627e542dae2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
      33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
      51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
      69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
      87, 88, 89, 90, 91}}}, Typeset`size$$ = {360., {173., 178.73095703125}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        Table[{
          
          Part[$CellContext`Track47, $CellContext`i, $CellContext`t$$]}, \
{$CellContext`i, 1, $CellContext`NTrack47}], 
        PlotRange -> {{0, $CellContext`Boxsize}, {0, $CellContext`Boxsize}}, 
        PlotStyle -> Table[
          
          Hue[$CellContext`i/$CellContext`NTrack47], {$CellContext`i, 
           1, $CellContext`NTrack47}], Frame -> True, 
        FrameLabel -> {"x[mm]", "y[mm]", "Ant 1 colony 05"}, AspectRatio -> 
        1], "Specifications" :> {{$CellContext`t$$, {1, 2, 3, 4, 5, 6, 7, 8, 
         9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 
         26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
         43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 
         60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 
         77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91}, 
         AnimationRate -> 4, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, DefaultBaseStyle -> 
        "Animate", DefaultLabelStyle -> "AnimateLabel", SynchronousUpdating -> 
        True, ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
     ImageSizeCache->{706., {195.134033203125, 200.865966796875}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Animate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.9075143858749204`*^9, 3.9075144061438127`*^9}, 
   3.907577714869571*^9, 3.9076869016177945`*^9, 3.9078544588365016`*^9, 
   3.9078728612076445`*^9, {3.9079128711389947`*^9, 3.907912919761126*^9}, 
   3.9082891297585664`*^9, 3.9082912792361903`*^9, 3.908291312867646*^9, 
   3.9082914535634565`*^9, 3.9084357528233147`*^9, 3.9085273551584597`*^9, 
   3.908551777325412*^9, {3.9085519783375425`*^9, 3.9085520013615847`*^9}, 
   3.908552204718673*^9, 3.908552235657955*^9, 3.9085523375224104`*^9, 
   3.908552368267995*^9, 3.9085524059010134`*^9, {3.9085525129740953`*^9, 
   3.90855254221856*^9}, {3.908552599849906*^9, 3.9085526064628973`*^9}, {
   3.908552711395269*^9, 3.908552735018399*^9}, {3.9085527861400204`*^9, 
   3.9085528034797187`*^9}, 3.9085529263660116`*^9, 3.9085529623569775`*^9, 
   3.908553017175021*^9, 3.90855309948462*^9, 3.9085531429002223`*^9, {
   3.9085532015160475`*^9, 3.9085532543254805`*^9}, 3.908553396346727*^9, 
   3.9085534298225985`*^9, 3.9085535568365183`*^9, 3.9087119566586304`*^9, 
   3.9087121217334743`*^9, 3.908820066952531*^9, 3.9088648991556845`*^9, 
   3.9089149511934533`*^9, 3.908916631115946*^9, 3.9090537043649683`*^9, 
   3.9090543463203993`*^9, 3.909138186250376*^9, 3.909138740375057*^9, 
   3.909215299627761*^9, 3.9094873994941216`*^9, 3.9094876367142773`*^9, 
   3.910087847223339*^9, 3.9100922553693943`*^9, 3.9101052020836115`*^9, 
   3.9101691542784834`*^9, 3.927619196696122*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"0784aa3a-9210-40e6-b0fb-0f6384d7bc9b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mass data (B~M^3/4 -- sublinear): figure", "Subsection",
 CellChangeTimes->{{3.908536465474157*^9, 3.908536476093549*^9}, {
  3.908712555053602*^9, 3.9087125633557816`*^9}, {3.9089531963407445`*^9, 
  3.9089531976368275`*^9}, {3.9089532787479515`*^9, 
  3.908953282851571*^9}},ExpressionUUID->"8627b0e4-7135-451a-9c57-\
7798fd9f379f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmMB", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Mtab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"Btab", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}], ",", "x",
     ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9074962849395475`*^9, 3.9074963020195236`*^9}, {
   3.907513423267853*^9, 3.9075134236984496`*^9}, 3.907873850339946*^9, 
   3.9079132038905706`*^9, {3.9079137305657845`*^9, 3.907913733535833*^9}, {
   3.9079456230141835`*^9, 3.907945627159021*^9}, {3.9082892413558025`*^9, 
   3.908289247280134*^9}, {3.908537794745761*^9, 3.908537797538553*^9}, 
   3.9088347027610273`*^9, {3.9088347509738617`*^9, 3.908834751376565*^9}, {
   3.908835656808078*^9, 3.9088356657194023`*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"703627ba-fac3-4878-bf4f-24b1623f2af6"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"1.2252352105280035`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.717574607299463`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {1.2252352105280035`, 
     0.717574607299463}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 0}}, {{
    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
    1.}}, {{-0.030459207484708574`, 
    1.1233049012584813`}, {-0.6931471805599453, 
    0.8539897056767758}, {-0.15082288973458366`, 
    1.179885008796846}, {-0.8675005677047231, 
    0.8763017236577919}, {-1.1394342831883648`, 
    0.3386128011203239}, {-1.8325814637483102`, -0.15315117949417478`}, {
    0.0769610411361284, 1.1381534632886423`}, {-0.5978370007556204, 
    0.9470139045169956}, {0.1906203596086497, 
    1.1875384978625112`}, {-0.4620354595965587, 0.8754687373538999}, {
    0.11332868530700327`, 1.379521476832462}, {-0.5978370007556204, 
    0.555033878430311}, {0.37843643572024505`, 
    1.5473497201206787`}, {-0.31471074483970024`, 0.9681238805141723}, {
    0.3364722366212129, 1.6286521313579048`}, {-0.342490308946776, 
    0.9005677714089187}}, {{1., -0.030459207484708574`}, {
    1., -0.6931471805599453}, {1., -0.15082288973458366`}, {
    1., -0.8675005677047231}, {1., -1.1394342831883648`}, {
    1., -1.8325814637483102`}, {1., 0.0769610411361284}, {
    1., -0.5978370007556204}, {1., 0.1906203596086497}, {
    1., -0.4620354595965587}, {1., 0.11332868530700327`}, {
    1., -0.5978370007556204}, {1., 0.37843643572024505`}, {
    1., -0.31471074483970024`}, {1., 0.3364722366212129}, {
    1., -0.342490308946776}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9074962858950477`*^9, 3.9074963299363155`*^9}, 
   3.907512026765726*^9, 3.9075134242091208`*^9, 3.907513743873456*^9, 
   3.9075777155338397`*^9, 3.907686902046938*^9, 3.9078544593399534`*^9, 
   3.90787286189167*^9, 3.9078738510602846`*^9, 3.907913079301836*^9, 
   3.907913206387114*^9, 3.9079132495991855`*^9, 3.907913397020169*^9, 
   3.907913624705275*^9, 3.9079136712390223`*^9, 3.907945627711117*^9, 
   3.90828913038337*^9, 3.908289248966651*^9, 3.908299863412848*^9, 
   3.908435753581107*^9, 3.908527356190065*^9, 3.90853779818343*^9, 
   3.9085378334411554`*^9, 3.9085537012168274`*^9, 3.908712291023102*^9, 
   3.9088200671094837`*^9, 3.9088347035082674`*^9, 3.908834751946185*^9, {
   3.908835657435998*^9, 3.9088356662335987`*^9}, 3.908864302894427*^9, 
   3.9088644089968095`*^9, 3.908864902706007*^9, 3.908914951397752*^9, 
   3.9089166313324375`*^9, 3.9090537046315494`*^9, 3.909054346454521*^9, 
   3.909138740715889*^9, 3.9091433789470887`*^9, 3.9092152998844604`*^9, 
   3.9094873997701797`*^9, 3.9094876374449863`*^9, 3.910087898704881*^9, 
   3.9100922555196257`*^9, 3.9101052022327275`*^9, 3.910169154503886*^9, 
   3.9276192481251793`*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"a3114bf0-5ffb-4645-b539-80eae891b468"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Aux", "=", 
   RowBox[{"Normal", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ScalingexpMB", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"Aux", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SCalingconstMB", "=", 
  RowBox[{"Exp", "[", 
   RowBox[{"(", 
    RowBox[{"Aux", "/.", 
     RowBox[{"x", "->", "0"}]}], ")"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.907913391190467*^9, 3.9079133949551897`*^9}, {
   3.9079134488574133`*^9, 3.907913529592462*^9}, {3.907913617543748*^9, 
   3.9079136474528036`*^9}, {3.9079456301947374`*^9, 
   3.9079456322228065`*^9}, {3.9082892515448112`*^9, 3.908289255003355*^9}, {
   3.908537803395046*^9, 3.9085378058156195`*^9}, 3.9091433839144115`*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"3dc08553-c9ea-4123-b69e-ad2fc3b80700"],

Cell[BoxData["3.4049668726659768`"], "Output",
 CellChangeTimes->{3.9091433843480434`*^9, 3.9092152998976617`*^9, 
  3.9094873997834425`*^9, 3.909487637500002*^9, 3.9100878987093782`*^9, 
  3.9100922555334854`*^9, 3.9101052022357516`*^9, 3.9101691545078745`*^9, 
  3.927619248172451*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"dd37db60-6293-40d0-824c-7255474cb0b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpBM", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Mtab", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Btab", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"M\",FontSlant->\"Italic\"]\) [g]\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"B\",FontSlant->\"Italic\"]\) [mW]\>\""}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", ".05", "]"}], ",", 
          RowBox[{"Hue", "[", 
           RowBox[{".2", ",", ".7", ",", ".5"}], "]"}]}], "}"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmMB", "[", "x", "]"}], ",", 
        RowBox[{"lmMB", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "3"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "140"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.908561725889757*^9, 3.9085618482095566`*^9}, {
   3.908606548814151*^9, 3.908606585547086*^9}, {3.908606621136112*^9, 
   3.9086066438813686`*^9}, {3.908606701596376*^9, 3.9086067047713194`*^9}, {
   3.90860674251923*^9, 3.9086067453039455`*^9}, {3.9086067755918436`*^9, 
   3.908606804312431*^9}, {3.908606848100778*^9, 3.9086068491981263`*^9}, {
   3.908607393535187*^9, 3.9086074262609696`*^9}, {3.908607466460007*^9, 
   3.908607549257204*^9}, {3.9089150062171803`*^9, 3.908915032797019*^9}, {
   3.9089151032823496`*^9, 3.908915106315121*^9}, {3.908915186962385*^9, 
   3.9089152346047754`*^9}, {3.9089152824205623`*^9, 3.908915335724343*^9}, {
   3.9089153890497484`*^9, 3.908915450804746*^9}, 3.908915848173538*^9, {
   3.9089605293414035`*^9, 3.908960546620845*^9}, {3.9089607150287724`*^9, 
   3.908960724024647*^9}, {3.9089608780559206`*^9, 3.9089608828483596`*^9}, {
   3.9089609284510765`*^9, 3.9089609611081553`*^9}, {3.9089610494959574`*^9, 
   3.908961139051277*^9}, {3.908961254509795*^9, 3.9089612754906664`*^9}, {
   3.9089613528957834`*^9, 3.9089613603729377`*^9}, 3.9089837257545567`*^9, {
   3.909090344034836*^9, 3.909090353468278*^9}, {3.9100880251341867`*^9, 
   3.910088041550679*^9}, 3.910183718853162*^9},
 CellLabel->"In[91]:=",ExpressionUUID->"a1b2278b-9081-47c7-9a31-7edee2cd271d"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{-0.030459207484708574`, 
      1.1233049012584813`}, {-0.6931471805599453, 
      0.8539897056767758}, {-0.15082288973458366`, 
      1.179885008796846}, {-0.8675005677047231, 
      0.8763017236577919}, {-1.1394342831883648`, 
      0.3386128011203239}, {-1.8325814637483102`, -0.15315117949417478`}, {
      0.0769610411361284, 1.1381534632886423`}, {-0.5978370007556204, 
      0.9470139045169956}, {0.1906203596086497, 
      1.1875384978625112`}, {-0.4620354595965587, 0.8754687373538999}, {
      0.11332868530700327`, 1.379521476832462}, {-0.5978370007556204, 
      0.555033878430311}, {0.37843643572024505`, 
      1.5473497201206787`}, {-0.31471074483970024`, 0.9681238805141723}, {
      0.3364722366212129, 1.6286521313579048`}, {-0.342490308946776, 
      0.9005677714089187}}]}, {{}, {}}}, {GraphicsComplexBox[CompressedData["
1:eJw91nk81PkfwPFhxnybYQZDxjHltroQaq2l+e4oGTYtSdjdkmORVodFlCNi
pyhlxfJbKlYrx0ZypJhP7qMcuXLkqHGWW9NEsv3+8P7j83j/+Xk/Hu/H4/l4
qbudsvcUJxAI41/e/2cuRenD2pom0gs/mWv/nIm4S6Ekl1BNFLX5QuULWSYK
apGvL5nVQKcc6YeuWiog2i8HXAN9NZC1oboj4m1E1c1HlFsm1dEHp+JzeS3y
iKKeeFn3Z3X0reIzVgdJHpUanW0d7VVDfufd9c9ayaGlXZFNWTZqaHdQaLXN
BQbKlGp4thKuitoqFIMGi2SRnm5r4Znzm5FLtnHKpEgG9WqYik27bkIh2zrM
9PVkkMOfE6s7nFlIPkuQ1jdCR9I5pma3HFVQN09brNGPhiZT5wQb9yijujRf
r+0DkiiRPGVqb6KEEpcf5ER4UNFRu/0rf7AU0TXe2hz3+QbkbWK1KkFmou15
toHR5hjipMblmYsroGzmrZeFDRLIrN+4LmRCHtk/XDI/ZExC5GS1q6Ejcqj3
T5uI0XJxNLfzdGV0DQPF//tP7Tt1MaTk476zMk8WtRRJJT5TW+PLqaTaPflH
BpmlPnO8Y/SJ7+TkUxauJI3E3ySpumIf+dtOa+syKDQU89g9gyAr5IchXRUJ
oiSy5+/KjN6yyJdpXXwt3r4BBWozcpbE5/icjn0ScTVkVLD7ddcVrSl+0c1j
n1TjSEhn/KE7ofYN/+/rKFD+qDhyGNDsDyX383dfzLZJPExA2fZt+cTiFj7N
tWDKnPOJj1bvO566kcWfzd606KMl4g93uRvuMa9it7spiR9RWeKH6Wpr9xV1
st0MuQFFv83y7f2C4koyhtl/B5z/YcxqnP9W90jCk/Axdq17yiqvb4Dfulkj
bqbvHfsKY/wn/FYDP215kafnOc8e8Kkx0uLcZ8eVtx8Qs11iVxXq3HwR3sVW
U8ySmgr4wM5MbBmPfP+aLRoNkJ33WmZ790ztnO97yw6wM5Ohp6yymayAUj+b
BXZ3Q5hV5s8E3HRkTM32qJAtrz6Y29Ihhg9uaRxmNi6ztaxMpKJ9iDjn97S3
TROf2Y5f3Yi3FpDwjkfzQYPBYrjg9HhH2hEyXjf/fdb3uUTc8rLJxgtTGK5o
rH5Ov1QCb3DmBfu4UfBcHY+BtTUMpxTSudJkSXw5rHk1r1IT9douPUw4xURu
+Zyc5H4y7hNtc9zMmIrb7z0b4jikiYheBgVn05moYm7nDXcuGf9z1mfavpmC
k08cqm7+FcO/UdnRpZ1GxT/frTXJndVEiv4t+a+LmehEwr1LXAIZL9AKNhpM
ouAPJZtLCrUw3O4HM5VCbyru1NDfOlqC4Wpjm+JT26m4g9NsctcHTaQRnJaX
+pSJvnP3DHvSL4Gb8SO6My9Q8NiBmAItAoa/mrKoDLSl4vopyY1OCRieF6Ft
6FpKxSM/qHaf7cfwmzYK7zrfUnHCzkv1UyuaaMsnUl5gPRPl2VisBDRK4JFx
pOyYUxRcWOOxY3CajGuW1cc7f0fFUy8GWDIiMHzhwD2iRQ4Vnx5atd/eiOH9
iqkVpYNUXEGa4/xoGsMPhiUoL4iouGOa7bH3q5oor6Is16OJiV6zHzyyRxK4
tn+djMibgm9/1PG2XPDlLumXRU2mVLwtQECaDfyyn7HvyYeZVFyj86QsBWF4
6NqPOlteUvHviYXMJMGX/z0cotwXqPiwckfqgBDDc5PbCiPWqPi6Z1anOdG/
LrPAswKn2KpZFRZ45k/y2vBkqwp4VsnT4ERzlcGz5+l7I8pPKoFnGmHb7UxD
FcEzy1kPndI0Jng29M0B+fBcBfCsKTgup6hiI3gWunbdc3RIHjyrU2UZu8/K
gWdmkhuPDdLlwLODDQYZdYYM8MzxUozrJwtZ8GwuSPhK31MGPCOE8NI9xung
mXVZR/5+Gg080yAFV311SBI8i4nP25DnTwHPLE2pCfoPMfBMQWejx9FWCfDM
cIJfGrBIROueDZvwlm58LY7WPRtx7ZLydSSgdc82GPmHZW5dBc9ET7JbPMs/
gmfz7ykLb9feg2ebp9w7qqMXwLPrMTNDGVHT4JkCR3qHufoYeMaovvJZeHEQ
PMspdNZ/bNEKnhnYeS6Iev7ir3sma5agUONQD549oO93sFTqA89c+pj9W9Lf
gGeqdiPWTI8p8KyO+NmlddMceFZW/v6nitoF8GzFom35StR78Ex9Uf2Eo5gI
PBv3cuf25yyDZ4XZw6WXOKvsdc8EhoZDBTlr7HXPhnuPiY5riIFnnd136+46
iYNnOrc/dLrxiOBZT9XPPtfbSeCZxLaQf4JJZPBsR391Zb8LBp4RVs7w9GJZ
4NmECcu68D4ZPHtOVCO0VLHAMwvpfaZMFzJ4NpP5l7SVBAae/btEfpo2yALP
4rI+Cqz0yeBZj+ZzRmgfGTzrDRqzZBhg4NmZ7PKM6Hcs8GxbyBP3ESUyeGbO
dbZi1pLBszdb4y3ylTHwzCLLXTloHwae5SkL/gheZIFnM7WSV3dIk8Gz60ZP
D3qUk8GzUF7x/WVpDDxL904sqTHFwDPfIt+zW37AwDOd3Li4RSELPGPIq//V
QSGDZ9aEhBZqMRk8s7xsePwOFQPPfn9qGuG7CwPPdrOG9rdZY+CZyE4qNfIw
Bp7JX0tq//o2AzxzFJwsL8YY4JlvdnHaUTdZ8Ky7X/XESr0MeKYup3Mm3UAG
PMv26GnrUZQGz7ZJ15x2GaOBZ8o+P44apEqBZ7lE698ZDpLgmV9GQUq/JhU8
+8lPPlbYuwE8KzC6FSrKwsAz+sXJCtI5Mng2ZNhEczWQAM+4EsEpdz4TwTNW
cqCFfpE4eEa/3bin+lcx8ExvW+3Mt3sI4Nm3D4LHliZX+euevZxRerU7aoW/
7pm032+2wgkRf90zk+SUsnwXIfRZaRWvZrNoEfqMQ4rSnjo+D31G4WXHPZ6Z
Bs+co6JnrXdOgmfCe8Y1y5IC8Gy/4UcK6/wgeHYuXtjyWKoTPFv2ti8Tv1kN
nhGa6zOOxPiAZ00PxC4Rz9ew1z1b3HrlaQW1E/psyVCMbV/xCjyzOdw802gi
AM8uBCVxDx6fBM/C37k9r7WbBc9+m58suZq3AJ65lufv2df9Hjzb9y54M9f7
I3jW+rKxLLblE3gWmXbF97YFAV/3zMGctoukLA59VqKrObH3BRH6zLtERi27
QAI8exl03mnmFAaeZXzX8+KlDgU8Kz4o99SLKAmexfKSbJyRFHg2GuPcwSmk
g2cPMgJHhIcY4NlUe8i5+jIaePZNE+7KDGGAZ9Ot125fM6OBZ5cSKlKJu+jg
WeT8zdSvrjLAs85M0UX/z1LgWfOFXM1RIQ0883I43KPhTwfPOrgRJfeTGODZ
AdI+7i9DUuBZaJyecXcPDTwL6H6sJudAB8/G5xsqDBPo4NndV9o1/v9jgGcK
h1arhlqlwLMSs5ZW2wYaeOYll3Ykdi8dPFNsvFWTE0kHz4y4j6rK79DBM8M2
QVNXGgM8M3nhG81qkALPOOYXNWIRDTwTDGUG1ZvRwTN/89BnYyF08Ozf/MZK
YQodPDv6KrEx7B4d/w8Ytu+h
     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{78, 148, 142, 137, 133, 130, 128, 79, 80, 81, 82, 83, 
          84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
           101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
          114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
          149, 143, 138, 134, 131, 129, 150, 144, 139, 135, 132, 151, 145, 
          140, 136, 152, 146, 141, 153, 147, 154, 127, 50, 77, 70, 76, 64, 69,
           75, 59, 63, 68, 74, 55, 58, 62, 67, 73, 52, 54, 57, 61, 66, 72, 49,
           48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32,
           31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15,
           14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 51, 53, 56, 60, 65, 71,
           1}}]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
          11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
          45, 46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 
          68, 63, 59, 75, 69, 64, 76, 70, 77, 50, 204, 231, 224, 230, 218, 
          223, 229, 213, 217, 222, 228, 209, 212, 216, 221, 227, 206, 208, 
          211, 215, 220, 226, 203, 202, 201, 200, 199, 198, 197, 196, 195, 
          194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 
          181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 
          168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 
          205, 207, 210, 214, 219, 225, 155}}]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$13264#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[{78, 148, 142, 137, 133, 130, 128, 79, 80, 81, 82, 83, 84, 
          85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
          101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
          114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
          149, 143, 138, 134, 131, 129, 150, 144, 139, 135, 132, 151, 145, 
          140, 136, 152, 146, 141, 153, 147, 154, 127}], 
         LineBox[{155, 225, 219, 214, 210, 207, 205, 156, 157, 158, 159, 160, 
          161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 
          174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
          187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 
          200, 201, 202, 203, 226, 220, 215, 211, 208, 206, 227, 221, 216, 
          212, 209, 228, 222, 217, 213, 229, 223, 218, 230, 224, 231, 204}]},
        Annotation[#, "Charting`Private`Tag$13264#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-2.30258509299404, -0.6931471805599437},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"B\\\",FontSlant->\\\"Italic\\\"]\\) [mW]\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"M\\\",FontSlant->\\\"Italic\\\"]\\) [g]\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.5\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.1\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.2\"", ShowStringCharacters -> False], 
           0.2`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.5\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox["2", TraditionalForm], {0.01, 0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.8971199848858813`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.8971199848858813`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.4054651081081644, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->140,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-2.3025850929940455`, 
   0.6931471805599453}, {-0.6931471805599453, 2.302585092994046}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.908561755058904*^9, 3.908561848815012*^9}, 
   3.9085619891965847`*^9, {3.908562523560464*^9, 3.908562550455783*^9}, {
   3.9086065497571774`*^9, 3.908606585937473*^9}, 3.9086067156145*^9, 
   3.9086067458918576`*^9, {3.9086067771477194`*^9, 3.908606796462225*^9}, {
   3.9086068400823402`*^9, 3.9086068502548504`*^9}, {3.908607394155098*^9, 
   3.9086074269255877`*^9}, {3.9086074725734053`*^9, 3.9086075498312087`*^9}, 
   3.908712294117275*^9, 3.9088200671691017`*^9, 3.908864414639254*^9, 
   3.9088649045510674`*^9, {3.9089149514600935`*^9, 3.9089149615558577`*^9}, 
   3.90891503401514*^9, 3.9089151075901923`*^9, {3.908915191292947*^9, 
   3.908915219490179*^9}, {3.908915285903792*^9, 3.9089152905696406`*^9}, {
   3.9089153234121523`*^9, 3.908915336869172*^9}, {3.908915390790118*^9, 
   3.908915452262773*^9}, 3.9089158327149005`*^9, 3.908916632134342*^9, 
   3.9089605517739277`*^9, {3.908960716471727*^9, 3.908960725185746*^9}, {
   3.9089608796409025`*^9, 3.908960883939645*^9}, 3.9089609777091117`*^9, {
   3.908961050704382*^9, 3.908961160874239*^9}, {3.9089612563913355`*^9, 
   3.908961276761758*^9}, {3.9089613572858872`*^9, 3.9089613613296413`*^9}, 
   3.908983727278144*^9, 3.9090537070565543`*^9, 3.909054348776602*^9, 
   3.9090903545185556`*^9, 3.909138741904667*^9, 3.9092153005507903`*^9, 
   3.909487400319078*^9, 3.9094876387180605`*^9, 3.910087899162678*^9, {
   3.910088037365615*^9, 3.9100880423084097`*^9}, 3.9100880783634214`*^9, 
   3.910092255905987*^9, 3.9101052026031084`*^9, 3.910169154919057*^9, 
   3.910183719494615*^9, 3.9276192490094643`*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"72da7bb8-e4e9-4b65-906c-4ff7914a0004"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigExpBM.pdf\>\"", ",", "FigExpBM"}], "]"}]], "Input",
 CellChangeTimes->{{3.908960552898001*^9, 3.908960577429553*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"25530b00-3d0d-4f5d-be0e-ca551d73b840"],

Cell[BoxData["\<\"FigExpBM.pdf\"\>"], "Output",
 CellChangeTimes->{{3.9089605652320566`*^9, 3.9089605783295927`*^9}, 
   3.9089607391751795`*^9, 3.9089608877393866`*^9, 3.9089611628605556`*^9, {
   3.9089612803129444`*^9, 3.9089612902709117`*^9}, {3.9089613642560697`*^9, 
   3.90896137167933*^9}, 3.908983729356387*^9, 3.9090537083779297`*^9, 
   3.9090543495676885`*^9, 3.909138742795565*^9, 3.9092153009206123`*^9, 
   3.9094874006455793`*^9, 3.909487638951784*^9, 3.910087899536171*^9, 
   3.9100880794812574`*^9, 3.910092256196645*^9, 3.9101052028817935`*^9, 
   3.9101691551773596`*^9, 3.9101837211730394`*^9, 3.927619250124951*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"db634cde-d4ab-4052-bc65-e603e9322a7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaling exponent\>\"", ",", "ScalingexpMB"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Intercept\>\"", ",", "SCalingconstMB"}], "}"}], "}"}], 
     ",", 
     RowBox[{"Transpose", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", 
          RowBox[{"lmMB", "[", "#", "]"}]}], "}"}], "&"}], "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<ParameterConfidenceIntervals\>\"", ",", 
         "\"\<AdjustedRSquared\>\"", ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", 
         ",", "\"\<RSquared\>\""}], "}"}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9079130734392757`*^9, 3.907913073440441*^9}, {
  3.907913104058184*^9, 3.907913105007386*^9}, {3.9079135789480753`*^9, 
  3.9079136668919992`*^9}, {3.9082892934334946`*^9, 3.908289298290121*^9}, {
  3.908289512658388*^9, 3.9082895202856007`*^9}, {3.908537627346176*^9, 
  3.9085376365441465`*^9}, {3.908537877171476*^9, 3.9085378868555803`*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"c622d5a4-6493-4e94-bc5c-1dfb85c24fd2"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Scaling exponent\"\>", "0.717574607299463`"},
    {"\<\"Intercept\"\>", "3.4049668726659768`"},
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.1341883462577234`", ",", "1.3162820747982837`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"0.5834200506197718`", ",", "0.8517291639791542`"}], "}"}]}], 
      "}"}]},
    {"\<\"AdjustedRSquared\"\>", "0.8969856522069907`"},
    {"\<\"AIC\"\>", 
     RowBox[{"-", "13.007365326413009`"}]},
    {"\<\"BIC\"\>", 
     RowBox[{"-", "10.689599159693666`"}]},
    {"\<\"RSquared\"\>", "0.9038532753931913`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.907913077586193*^9, 3.9079131059054856`*^9}, {
   3.907913592284546*^9, 3.9079136288937016`*^9}, 3.907913673732597*^9, 
   3.9082891309934835`*^9, 3.908289298795566*^9, 3.90828941983897*^9, 
   3.908289522085408*^9, 3.9082915876558547`*^9, 3.9084357545554104`*^9, 
   3.9085273574746113`*^9, 3.9085376377766533`*^9, {3.908537681195726*^9, 
   3.908537690031172*^9}, 3.908537887346064*^9, 3.908553701292162*^9, 
   3.9087122975940237`*^9, 3.908820067181301*^9, 3.90883471244462*^9, 
   3.9088644199813976`*^9, 3.908864905926237*^9, 3.9089153681348066`*^9, 
   3.908916632298807*^9, 3.909053708601866*^9, 3.909054349638692*^9, 
   3.9091387428762712`*^9, 3.9092153009372916`*^9, 3.9094874006796865`*^9, 
   3.909487638966745*^9, 3.910087899571208*^9, 3.9100922562328606`*^9, 
   3.9101052028982677`*^9, 3.910169155197342*^9, 3.927619250187728*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"e6bc2a15-62b6-4bc8-a9ba-5ab91c405045"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Area occupied by the colony (Area~N^3/4 -- sublinear, with N being the number \
of tracked animals): figure\
\>", "Subsection",
 CellChangeTimes->{{3.9086894767731776`*^9, 3.9086894943408427`*^9}, {
  3.908712629142809*^9, 3.90871264625424*^9}, {3.908953207423169*^9, 
  3.9089532127938995`*^9}, {3.908953301456834*^9, 
  3.9089533033982744`*^9}},ExpressionUUID->"bd48f940-7512-4090-94ee-\
1c312df00b0c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sizecell", "=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"6", "^", "2"}]}], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NGrid", "=", 
   RowBox[{"Ceiling", "[", 
    RowBox[{"Boxsize", "/", "Sizecell"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AreaCol", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9075120486823177`*^9, 3.9075120624104433`*^9}, {
   3.907512166930231*^9, 3.9075122889769306`*^9}, {3.907513136770433*^9, 
   3.9075131369323225`*^9}, {3.907513452580872*^9, 3.9075134787051945`*^9}, {
   3.9075135924896007`*^9, 3.9075136208179927`*^9}, {3.9075138135294905`*^9, 
   3.9075138279444723`*^9}, {3.907513981462042*^9, 3.90751399396795*^9}, {
   3.9075159520100822`*^9, 3.9075159553790464`*^9}, {3.908689665732992*^9, 
   3.908689691751403*^9}, {3.9086903888321667`*^9, 3.9086904420793943`*^9}, {
   3.9086912819506383`*^9, 3.908691282326256*^9}, 3.908691408064099*^9, 
   3.908692232255872*^9, {3.908692484228051*^9, 3.9086924874197903`*^9}, 
   3.9086925299193306`*^9, {3.9086926692864046`*^9, 3.9086926775083623`*^9}, {
   3.908693923299445*^9, 3.908693950652627*^9}, {3.9086939997800703`*^9, 
   3.9086940022110558`*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"3efdeb9c-27d0-4ca2-9cc8-0accc6e972e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GridOcc", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NGrid"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "NGrid"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.910105302406893*^9, 3.910105316199395*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"89c85948-614e-4ed3-ba1b-53a66f2477ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GridAux", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NGrid"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "NGrid"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.9086919408342285`*^9},
 CellLabel->"In[98]:=",ExpressionUUID->"566452d5-3c90-4de6-9102-4f644590ca73"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"Ncol", "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GridAux", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "Ts"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "NGrid"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "NGrid"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"t", "=", "1"}], ",", 
      RowBox[{"t", "<", 
       RowBox[{"Ts", "+", "1"}]}], ",", 
      RowBox[{"t", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"n", "=", "1"}], ",", 
         RowBox[{"n", "<", 
          RowBox[{
           RowBox[{"NTrack", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
         RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"GridAux", "[", 
           RowBox[{"[", 
            RowBox[{"t", ",", 
             RowBox[{"Ceiling", "[", 
              RowBox[{
               RowBox[{"Tracks", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "n", ",", "t", ",", "1"}], "]"}], "]"}], 
               "/", "Sizecell"}], "]"}], ",", 
             RowBox[{"Ceiling", "[", 
              RowBox[{
               RowBox[{"Tracks", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "n", ",", "t", ",", "2"}], "]"}], "]"}], 
               "/", "Sizecell"}], "]"}]}], "]"}], "]"}], "=", "1"}]}], 
        "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"GridAux2", "=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"GridAux", "[", 
        RowBox[{"[", "t", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"GridOcc", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", "GridAux2"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"AreaCol", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"Count", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", "GridAux2", "]"}], ",", 
        RowBox[{"u_", "/;", 
         RowBox[{"u", ">", "0.9"}]}]}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"Sizecell", "^", "2"}], ")"}]}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBmIQfayw6dEfmbeO5Qdbn4NoV7bHIn+B9AGLPFkQXXJz
kRKIluDkVAHRVVsZNUE0g/IjZxAdVc/sD6JPBRWC6b26eqEgOkj7N5j+cLQx
FkTviImLB9FacQv3gugL3zaB6R03ci+D6DllAY/B5j66IvMPSO/LfA2mNTyP
HwPRExr/g+m+BXUiNvJvHTmaesH0zjUPTEC01vPJFiC6iLvJCUSnLPnoDqKF
pqzKANFGnx9kguiz86srQbSA+Y4mEL1hr1sHiD4jOQlMh8lM7gfRUUpfJ4Bo
SZN150F019aTl0C0TBnzAxBt3PT2Idgd2RKfQHRVEetnEB2R7fQLRFvGcP8G
0XovjBlsgbTX0jnMIPqCTpsUiDYMdJAG0XfM+xRAdFwAhxKIlj50LglEn0vt
SAHRUTduyL5XfOs4XUhBAUQDAI51ync=
  "],
 CellLabel->"In[99]:=",ExpressionUUID->"9ec8f630-3d97-40f1-8236-3b9443620c45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigDens1", "=", 
  RowBox[{"ListDensityPlot", "[", 
   RowBox[{
    RowBox[{"GridOcc", "[", 
     RowBox[{"[", "6", "]"}], "]"}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"GrayLevel", "[", 
        RowBox[{"1", "-", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9101053547004805`*^9, 3.9101053558500457`*^9}, {
   3.9101054146087384`*^9, 3.9101054421206446`*^9}, {3.910105572026759*^9, 
   3.910105572364132*^9}, {3.910105720296213*^9, 3.910105811179081*^9}, 
   3.910105847497571*^9, {3.910105890139567*^9, 3.9101059475291405`*^9}, {
   3.9101061533059316`*^9, 3.91010617242524*^9}, {3.9101062137853146`*^9, 
   3.910106216552903*^9}, 3.9101063530492344`*^9, {3.910106401194267*^9, 
   3.910106414534235*^9}, {3.910106446263159*^9, 3.910106450759241*^9}, {
   3.910106525593006*^9, 3.910106554937564*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"b3198f3a-a26d-4579-9f71-89ff51e5d06f"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNnT+O81YeBAdOVuEECiaYQCYEQhAEQeL/zA58Ah9hAce+uo9gGEYHbrvQ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   "], {
    {GrayLevel[0.8], EdgeForm[None], 
     GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl2WPQHUkbBuDYtm3btm072di2tbGTTbJJNrZt27Zt87ve+n5c9dTcdfrU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       "]]]}, {}, {}, {}, {}},
   VertexColors->CompressedData["
1:eJzt2LENgzAQheFLxRxMkoYJGCFSalbOCBmBJl0kXnE6vcP+X/N12OZOtmF9
Hfv7ERHbEr98n4iIiP9+hNm414djm417/oiIiCOq7pfu+d1dFff8sv2R7R8V
9/qx1ur9p/v+ppL9/q8ev3p+d1fF3Z/ZVI/vfr67Pt3r131/VnHXh/+716q4
75/Z83H0/nerUl1f9/rRq8rs/TP7+rG31ec7/T+33f/vuN8Pes2G/Q87S/8h
IiIiIqLfEzmmBmI=
    "]],
  AspectRatio->1,
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
    "M10DefaultDensityGradient", 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotRange->{{1., 24.}, {1., 24.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.910105356057362*^9, {3.910105422397963*^9, 3.910105442752241*^9}, 
   3.9101055727727675`*^9, {3.91010572093149*^9, 3.910105812085674*^9}, 
   3.910105848036165*^9, {3.9101058987577753`*^9, 3.9101059483735914`*^9}, {
   3.91010615745799*^9, 3.910106173064991*^9}, 3.910106214376869*^9, 
   3.910106353494372*^9, 3.910106401781637*^9, 3.910106451422997*^9, {
   3.9101065270720625`*^9, 3.910106555890139*^9}, 3.910169155970688*^9, 
   3.9276192627584696`*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"fdec7cd2-99bc-4611-89a5-f9e148ec7dc4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigDens1.pdf\>\"", ",", "FigDens1"}], "]"}]], "Input",
 CellChangeTimes->{{3.908962472058983*^9, 3.9089624996330323`*^9}, {
  3.910106574887952*^9, 3.910106587575824*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"9874dde3-3891-4210-a253-f0cf2b741e82"],

Cell[BoxData["\<\"FigDens1.pdf\"\>"], "Output",
 CellChangeTimes->{3.9089625006390142`*^9, 3.90898394137567*^9, 
  3.909053716304887*^9, 3.909054355453058*^9, 3.909138746655139*^9, 
  3.909215303884267*^9, 3.9094876406736145`*^9, 3.910087901243952*^9, 
  3.9100922576911*^9, 3.910105204535754*^9, 3.9101065884871244`*^9, 
  3.910169156067423*^9, 3.927619263014513*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"3672469d-f93e-419c-8086-c9b6f62b3ff0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigDens2", "=", 
  RowBox[{"ListDensityPlot", "[", 
   RowBox[{
    RowBox[{"GridOcc", "[", 
     RowBox[{"[", "15", "]"}], "]"}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"GrayLevel", "[", 
        RowBox[{"1", "-", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.910105984246045*^9, 3.910106035036376*^9, 3.9101064857526045`*^9, {
   3.910106538616233*^9, 3.910106564679922*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"7a4c8dab-57d7-4217-969e-3b145e397615"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNnT1qBEcYBYWjDRUoUKBAHpZlWZZl/mcyO/AJfASDY1/dRzDGvMDPLt5T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   "], {
    {GrayLevel[0.8], EdgeForm[None], 
     GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl2WPU5UjbBtBp27Zt27Zt27ZtTFvTtm1b07ZtTrv728/3/tgnK9eqpM5J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       "]]]}, {}, {}, {}, {}},
   VertexColors->CompressedData["
1:eJzlm11k1lEcx/9FRGQ008gyIiIREbMWJdJNJUbWizF2kyKylBIpu1rSLGmJ
7KpuImOJpShiWdNm2ay9t9dWiSWis/Ncf30ez7dTqePwvXnO+Z/z+33P7+2c
p7z25MG6ZVmW7V6ZZTuGxiqHxuarFBatHgm9W+KZ2o2hT0o8fHdF6DMSzzYt
NjQtTkm8db8j9BmJX8oWPpctjBSMp7dVhz4msXv55tCHJa5tPlDafOCdxEc7
V4U+LpHks+5ZeehzEgfaT4Q+K/HJy3OhzxWMj6OgpyV+a1hS1AeJfTVdvTVd
ExKvb9gb+ihgj8QcD59KJP1UR0V/kEjy6fy6L/QFifEYVX6UeHG65cJ0S+FI
8x9ZEnPvnMTSKIdpicS/81EQsxJJPllsnyTS/sh+rV865p8/Fow/eraEPi+R
5Ev8IlwX1/FaYhRj57jE49/bjn1vW5BI+yf9EBJ/iR+EJH/SH81P44n/JF/X
ftD8pH9C+r5r38j/VTxcE/qsxAwafT/1+af57/Q3tvY3zkuk/R+MhnpEIsVn
8TOtUxJpfxS/kf8k/0Lyo/NH9on2R/qh+Yk/MUwbmJRI8qP5af3kP137TPaB
4o+iyIMHEl3+Eb/iMkonJO6PC30jkeRP8nP5TfNT/E75Ba2P9EPzk/127b87
nvidyzM6JNL+t1/eFfqURDe+I/3fjHn2K4lkv9z4m/hN8if+kf88tKcu9LcS
KX918yPCPx2/5/LsYYlUvyH76q6f4kviP8UHrv8k/bn5LcVXVN/Zuule6KMS
U+cnJD8aT/yg8aR/4r9bX3LzR8ofKH5Mnb+7+amtP4gv4zTHZiS655vOT378
1o3WR/ql+jX5f0Lyj8Rfsm9u/cI9fy5/yX7R+orqL5XUX2qX6O6f5J9f/Yb8
uG6u/ml9FH/T+aH8z60Pufxz4/PU9hv5Dfc/WeT5FYn0ffIP5P9dfpP/IX4Q
/11+0f5c/5g6fqT53fqxW1+/EfOgXonu+t34wm20PqqPuPGNGx+4/tM9P+T/
3PwxtX+h/Ny1P7R/ep9QHP3EC4nxZ72DEt34380P3PsLlx/58V8393zR+NT5
69GI7yW6+Tftj+KTa7FO+UwivS9I/f6D5OveH5L88rs/KLw+Sesjfrj+340P
6fymvh+m+IDWR/ePf1o/hCS/1PpNHV+nft+Vn33Sjernbn0/df5G7z/o/BH/
i2MhZUwi1RfLopyGJLrrI/26+SXp183PaH7CLMYBdyVS/YHiC3f/JF/iP/GH
4jPiR+qW4/FglUIaT/7RfT9E9ytoX4F/rn2m+zfiN+2P7kfd+z3yL387f6nR
+34aT/Ipin7muUT3/RHZNze+ovsHqp/Q/x/o/oPyO/f/Janff+Va4fV3t51a
eTX04SqFlH/Q+xniP60vv/eFhTf6fxXFh1Sfo/3T9+n8pL6fJv9D+TPFN67+
6H0rvd+i/ZF8yb6S/6Pv0/t4uv9z5Uvyo/dpxD/iN8U3lH/SeOI/2TfiB+mX
5if5RjFWjEgk/dL8JfEeoU/i7RgndEl0+Ze60fsfel9L9p34Sec7J2eNxD9C
im+In3R+SP60v9/BgX+5UXyS4+GQRPf/4RQfkH+g8bR/8r+5OmK/RJqf3udT
fP1rtPz/tp9ZED9T
    "]],
  AspectRatio->1,
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
    "M10DefaultDensityGradient", 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotRange->{{1., 24.}, {1., 24.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.910105985401229*^9, 3.9101060356194377`*^9, 3.910106493840126*^9, {
   3.910106539073104*^9, 3.910106564976072*^9}, 3.910169156096838*^9, 
   3.927619263054817*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"4be68ad1-f9fc-49e2-b0ac-ebf0fb91cfe3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigDens2.pdf\>\"", ",", "FigDens2"}], "]"}]], "Input",
 CellChangeTimes->{{3.908962472058983*^9, 3.9089624996330323`*^9}, {
  3.910106574887952*^9, 3.9101065757527*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"83874e9b-fcec-4a91-b775-ceea64455491"],

Cell[BoxData["\<\"FigDens2.pdf\"\>"], "Output",
 CellChangeTimes->{3.9089625006390142`*^9, 3.90898394137567*^9, 
  3.909053716304887*^9, 3.909054355453058*^9, 3.909138746655139*^9, 
  3.909215303884267*^9, 3.9094876406736145`*^9, 3.910087901243952*^9, 
  3.9100922576911*^9, 3.910105204535754*^9, 3.9101065839708414`*^9, 
  3.9101691561923723`*^9, 3.9276192632595344`*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"8b6f444d-8127-4d44-badd-1d14a7389f60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmNtAr", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"AreaCol", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}], ",", "x",
     ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9074962849395475`*^9, 3.9074963020195236`*^9}, {
   3.907513423267853*^9, 3.9075134236984496`*^9}, 3.907873850339946*^9, 
   3.9079132038905706`*^9, {3.9079137305657845`*^9, 3.907913754588001*^9}, {
   3.907914084956211*^9, 3.9079140891266136`*^9}, {3.9079143543535028`*^9, 
   3.9079143546025906`*^9}, 3.907914456061963*^9, {3.9079146961454973`*^9, 
   3.907914704084815*^9}, {3.9079429745569954`*^9, 3.907942975092173*^9}, 
   3.907943009187583*^9, {3.9082983247745867`*^9, 3.908298343807744*^9}, {
   3.9086911250363035`*^9, 3.908691136295161*^9}, {3.908692270223775*^9, 
   3.9086922706203036`*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"a58e583a-497b-4d00-9409-b5cf8458b023"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"8.02408034882028`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.5100503943021554`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {8.02408034882028, 
     0.5100503943021554}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 0}}, {{
    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}}, {{
      Log[232], 10.982077635880984`}, {
      Log[119], 10.649827243949325`}, {
      Log[115], 10.777982279537468`}, {
      Log[90], 10.63361067236008}, {
      Log[114], 10.448560600912922`}, {
      Log[37], 9.548530389910548}, {
      Log[159], 10.455096571892707`}, {
      Log[74], 10.474452014845664`}, {
      Log[196], 10.833042056720496`}, {
      Log[125], 10.112743887094599`}, {
      Log[308], 10.810467734681957`}, {
      Log[104], 10.225417049598711`}, {
      Log[280], 10.73213589141205}, {
      Log[113], 10.39812974728603}, {
      Log[351], 11.006770248471355`}, {
      Log[159], 10.57179324133687}}, {{1., 5.44673737166631}, {1., 
    4.77912349311153}, {1., 4.74493212836325}, {1., 4.499809670330265}, {1., 
    4.736198448394496}, {1., 3.6109179126442243`}, {1., 
    5.0689042022202315`}, {1., 4.30406509320417}, {1., 5.278114659230517}, {
    1., 4.8283137373023015`}, {1., 5.730099782973574}, {1., 
    4.6443908991413725`}, {1., 5.634789603169249}, {1., 4.727387818712341}, {
    1., 5.860786223465865}, {1., 5.0689042022202315`}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9074962858950477`*^9, 3.9074963299363155`*^9}, 
   3.907512026765726*^9, 3.9075134242091208`*^9, 3.907513743873456*^9, 
   3.9075777155338397`*^9, 3.907686902046938*^9, 3.9078544593399534`*^9, 
   3.90787286189167*^9, 3.9078738510602846`*^9, 3.907913079301836*^9, 
   3.907913206387114*^9, 3.9079132495991855`*^9, 3.907913397020169*^9, 
   3.907913624705275*^9, 3.9079136712390223`*^9, 3.9079137551756735`*^9, 
   3.907914089994602*^9, 3.907914457755934*^9, 3.9079147048431187`*^9, 
   3.907943011412777*^9, {3.908298335055463*^9, 3.9082983448400106`*^9}, 
   3.9082997854661803`*^9, 3.9085577541952887`*^9, 3.908691137380322*^9, 
   3.9086912873321495`*^9, {3.908692267714122*^9, 3.9086922711924763`*^9}, 
   3.9086923238966184`*^9, 3.908692494836878*^9, 3.9086926840327406`*^9, 
   3.9086927890729856`*^9, {3.908693939993464*^9, 3.908693956230587*^9}, 
   3.908712122648897*^9, 3.908820068109236*^9, 3.9088644573615685`*^9, 
   3.908864942784648*^9, 3.908915496246915*^9, 3.90891553162506*^9, 
   3.908916633293059*^9, 3.909053711859661*^9, 3.909054352050707*^9, 
   3.9091387446498966`*^9, 3.9092153019188557`*^9, 3.90948763970778*^9, 
   3.9094963913383946`*^9, 3.910087900453635*^9, 3.9100922569377985`*^9, 
   3.9101052036699276`*^9, 3.9101691562252827`*^9, 3.927619263307103*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"9fd8c1a7-216e-4b72-bb44-de1fc2d1d29d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Aux", "=", 
   RowBox[{"Normal", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ScalingexpNtAr", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"Aux", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SCalingconstNtAr", "=", 
  RowBox[{"Exp", "[", 
   RowBox[{"(", 
    RowBox[{"Aux", "/.", 
     RowBox[{"x", "->", "0"}]}], ")"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.907913391190467*^9, 3.9079133949551897`*^9}, {
   3.9079134488574133`*^9, 3.907913529592462*^9}, {3.907913617543748*^9, 
   3.9079136474528036`*^9}, {3.907913758946082*^9, 3.9079137612022448`*^9}, {
   3.9079140927792892`*^9, 3.9079140957022033`*^9}, {3.90791446134632*^9, 
   3.907914462900561*^9}, {3.9079147076068316`*^9, 3.9079147098945436`*^9}, {
   3.907943013439031*^9, 3.907943016763689*^9}, {3.9082983396644115`*^9, 
   3.9082983488595004`*^9}, {3.9086911587289653`*^9, 3.9086911645854316`*^9}, 
   3.9086941286349735`*^9, 3.90949638597937*^9},
 CellLabel->
  "In[105]:=",ExpressionUUID->"ac82e895-722a-4aac-81e5-aaa4581d9a82"],

Cell[BoxData["3053.611748410447`"], "Output",
 CellChangeTimes->{{3.9094963881418147`*^9, 3.909496392005494*^9}, 
   3.910087900472613*^9, 3.9100922569453573`*^9, 3.910105203692507*^9, 
   3.9101691562445765`*^9, 3.927619263307103*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"27d4a1da-eb63-4c8b-adf0-321e2e336836"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpAreaN", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"AreaCol", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"Area\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(mm\), \(2\)]\)]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", ".05", "]"}], ",", 
          RowBox[{"Hue", "[", 
           RowBox[{".2", ",", "0.7", ",", ".5"}], "]"}]}], "}"}], "}"}]}], 
      ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"20", ",", "500"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9990", ",", "100000"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmNtAr", "[", "x", "]"}], ",", 
        RowBox[{"lmNtAr", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "500"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "160"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.908561725889757*^9, 3.9085618482095566`*^9}, {
   3.908606548814151*^9, 3.908606585547086*^9}, {3.908606621136112*^9, 
   3.9086066438813686`*^9}, {3.908606701596376*^9, 3.9086067047713194`*^9}, {
   3.90860674251923*^9, 3.9086067453039455`*^9}, {3.9086067755918436`*^9, 
   3.908606804312431*^9}, {3.908606848100778*^9, 3.9086068491981263`*^9}, {
   3.908607393535187*^9, 3.9086074262609696`*^9}, {3.908607466460007*^9, 
   3.908607549257204*^9}, {3.9086076391927834`*^9, 3.9086077332040863`*^9}, {
   3.9086077655012703`*^9, 3.9086077931736217`*^9}, {3.9086928357619953`*^9, 
   3.9086929544278107`*^9}, {3.908915502790738*^9, 3.9089155148373775`*^9}, {
   3.908915551913513*^9, 3.90891555591401*^9}, {3.908953227562517*^9, 
   3.908953253966603*^9}, {3.9089622967553625`*^9, 3.908962308638553*^9}, {
   3.908962457543355*^9, 3.9089624885280285`*^9}, {3.9089838854496126`*^9, 
   3.908983922318652*^9}, {3.910169593770731*^9, 3.910169634843214*^9}, {
   3.9101696855792127`*^9, 3.910169698589013*^9}, 3.9101723820092573`*^9, 
   3.9101824621006746`*^9},
 CellLabel->
  "In[108]:=",ExpressionUUID->"0c3a3443-f274-457d-9695-0d533450ac31"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{5.44673737166631, 10.982077635880984`}, {4.77912349311153, 
      10.649827243949325`}, {4.74493212836325, 10.777982279537468`}, {
      4.499809670330265, 10.63361067236008}, {4.736198448394496, 
      10.448560600912922`}, {3.6109179126442243`, 9.548530389910548}, {
      5.0689042022202315`, 10.455096571892707`}, {4.30406509320417, 
      10.474452014845664`}, {5.278114659230517, 10.833042056720496`}, {
      4.8283137373023015`, 10.112743887094599`}, {5.730099782973574, 
      10.810467734681957`}, {4.6443908991413725`, 10.225417049598711`}, {
      5.634789603169249, 10.73213589141205}, {4.727387818712341, 
      10.39812974728603}, {5.860786223465865, 11.006770248471355`}, {
      5.0689042022202315`, 10.57179324133687}}]}, {{}, {}}}, {
    GraphicsComplexBox[CompressedData["
1:eJxF1nk8FPgbwHHJKpVjyH2bGRG5olUMT44pDDpQ7mMwiJlxjSNGSTrkvko5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     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{78, 166, 153, 143, 136, 131, 171, 158, 148, 141, 174, 
          161, 151, 177, 164, 180, 128, 169, 156, 179, 146, 176, 163, 139, 
          173, 160, 150, 134, 79, 167, 154, 144, 137, 132, 129, 80, 81, 82, 
          83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
          100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
          113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
          126, 168, 155, 145, 138, 133, 130, 170, 157, 147, 140, 135, 172, 
          159, 149, 142, 175, 162, 152, 178, 165, 181, 127, 50, 77, 70, 76, 
          64, 69, 75, 59, 63, 68, 74, 55, 58, 62, 67, 73, 52, 54, 57, 61, 66, 
          72, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 
          33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 
          16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 51, 53, 56, 60, 
          65, 71, 1}}]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwt0llXTmEYBuCdr0HzXFJRRKUkRJOkDEWc+Al+QP6bg0JkzJQpQ0I0oCQ0
KKWIa7ccXOu+33ftg/0+6yk+d/5s54YgCKK48D/baOEQdRxgP+F3EaKJIZY4
NhJPAokkkUwKqaSRTgaZZJFNDrlsIo/N5FNAIVvYShHFbGM7JexgJ6WUUc4u
KqhkN1XsoZq9tNNKE/UcpIaTHOUwDdRyimM000gHxznCaU5whn1Mhv9ucInk
8jeciczip/4nnJWewYy+wGo4R+c0vujfmOdXOGd3KUzon/jIB8YZY5QR3vOO
Yd7yhtcM8YpBXvKC5zxjgKc84TGPeEg/D7jPPe5yhz5uc4ub3OA61+jlKlfo
4TKXuMgUX5ljmSjvSaZb/84PVoi4S+VzuAMygRzWwr2QcWSy6Bwvs/mtx8h0
pvVZloJgfXmT6FL/AZrmTsY=
          "]]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$15988#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[{78, 166, 153, 143, 136, 131, 171, 158, 148, 141, 174, 161, 
          151, 177, 164, 180, 128, 169, 156, 179, 146, 176, 163, 139, 173, 
          160, 150, 134, 79, 167, 154, 144, 137, 132, 129, 80, 81, 82, 83, 84,
           85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
          101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
          114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
          168, 155, 145, 138, 133, 130, 170, 157, 147, 140, 135, 172, 159, 
          149, 142, 175, 162, 152, 178, 165, 181, 127}], 
         LineBox[CompressedData["
1:eJwVz8VWQgEUBdCHhS3YOvOX/ATXYop/Z6AIdgcWimJ3d6KyHex1zrmz29XT
2x0PBUEQo4/a/8G7eOCaqF1OQW+RVbzqTTJMO792q6ymgwu7QZbypT9zRz91
biE+9EduuGSAQRIMMUySEVKkGWWMcSaYZIppZphljnkWWGSJZVbIsMoa62yw
SZYttsmxwy559tjngEOOOOaEU86o908Jn/oTt1wRcSvjW3/hnka7gh/9jWa9
kj+9TdbQybldBKQSQrw=
          "]]},
        Annotation[#, "Charting`Private`Tag$15988#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.9957322735539975`, 9.209339871642621},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"Area\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(mm\\), \\(2\\)]\\)]\"", HoldForm], TraditionalForm], 
     None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"N\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{9.210340371976184, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "2", 
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "5", 
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}}, {11.512925464970229`, 
        FormBox[
         TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
        0.}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.615805480084347, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.918390573078392`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.615805480084347, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.918390573078392`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       12.206072645530174`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->160,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.995732273553991, 6.214608098422191}, {9.2093398716426, 
   11.512925464970229`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.908561755058904*^9, 3.908561848815012*^9}, 
   3.9085619891965847`*^9, {3.908562523560464*^9, 3.908562550455783*^9}, {
   3.9086065497571774`*^9, 3.908606585937473*^9}, 3.9086067156145*^9, 
   3.9086067458918576`*^9, {3.9086067771477194`*^9, 3.908606796462225*^9}, {
   3.9086068400823402`*^9, 3.9086068502548504`*^9}, {3.908607394155098*^9, 
   3.9086074269255877`*^9}, {3.9086074725734053`*^9, 
   3.9086075498312087`*^9}, {3.9086076515298853`*^9, 
   3.9086076914761157`*^9}, {3.9086077220618286`*^9, 
   3.9086077338027563`*^9}, {3.9086077816304255`*^9, 3.908607793877743*^9}, 
   3.908692843355835*^9, {3.9086929391297283`*^9, 3.908692955133919*^9}, 
   3.908693960064172*^9, 3.908712128190258*^9, 3.9088200681734476`*^9, 
   3.9088644575689974`*^9, {3.9088649428979845`*^9, 3.9088649550364466`*^9}, {
   3.9089154963432245`*^9, 3.908915557180031*^9}, 3.908916633967966*^9, {
   3.908953230766573*^9, 3.908953255546805*^9}, 3.9089622910432405`*^9, 
   3.9089623257008247`*^9, {3.908962467212022*^9, 3.9089624898656206`*^9}, 
   3.908983923734277*^9, 3.9090537152709274`*^9, 3.909054354352036*^9, 
   3.909138746209034*^9, 3.909215303342805*^9, 3.909487640358568*^9, 
   3.9100879010231276`*^9, 3.9100922574848604`*^9, 3.910105204192865*^9, 
   3.910169156762558*^9, {3.910169594656065*^9, 3.910169635487527*^9}, {
   3.9101696863462453`*^9, 3.9101696993965125`*^9}, 3.9101710841047*^9, 
   3.910172382881606*^9, 3.9101824627721186`*^9, 3.9276192644463825`*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"8d189a67-8a42-4e3b-9bae-3581d69dd0b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigExpAreaN.pdf\>\"", ",", "FigExpAreaN"}], "]"}]], "Input",
 CellChangeTimes->{{3.908962472058983*^9, 3.9089624996330323`*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"7daebd53-ed6c-4e14-96b4-babedc75002f"],

Cell[BoxData["\<\"FigExpAreaN.pdf\"\>"], "Output",
 CellChangeTimes->{3.9089625006390142`*^9, 3.90898394137567*^9, 
  3.909053716304887*^9, 3.909054355453058*^9, 3.909138746655139*^9, 
  3.909215303884267*^9, 3.9094876406736145`*^9, 3.910087901243952*^9, 
  3.9100922576911*^9, 3.910105204535754*^9, 3.9101691569142604`*^9, 
  3.91017108664229*^9, 3.9101723840324607`*^9, 3.9101824655563946`*^9, 
  3.9276192652507334`*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"524d6705-c8fe-4e95-91b1-328d36f375b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaling exponent\>\"", ",", "ScalingexpNtAr"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Intercept\>\"", ",", "SCalingconstNtAr"}], "}"}], "}"}], 
     ",", 
     RowBox[{"Transpose", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", 
          RowBox[{"lmNtAr", "[", "#", "]"}]}], "}"}], "&"}], "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<ParameterConfidenceIntervals\>\"", ",", 
         "\"\<AdjustedRSquared\>\"", ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", 
         ",", "\"\<RSquared\>\""}], "}"}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9079130734392757`*^9, 3.907913073440441*^9}, {
  3.907913104058184*^9, 3.907913105007386*^9}, {3.9079135789480753`*^9, 
  3.9079136668919992`*^9}, {3.9079137829676533`*^9, 3.9079137873094325`*^9}, {
  3.907914119614028*^9, 3.9079141239962473`*^9}, {3.9079144859044704`*^9, 
  3.90791449130338*^9}, {3.9079147222392983`*^9, 3.9079147275228705`*^9}, {
  3.907943025411437*^9, 3.907943030580187*^9}, {3.908298362411597*^9, 
  3.908298370513174*^9}, {3.9086941150919294`*^9, 3.908694120852604*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"b9f9b5de-c151-47aa-ae55-dfd6f47e4d82"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Scaling exponent\"\>", "0.5100503943021554`"},
    {"\<\"Intercept\"\>", "3053.611748410447`"},
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6.957421867767083`", ",", "9.090738829873478`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.295284611592684`", ",", "0.7248161770116268`"}], "}"}]}], 
      "}"}]},
    {"\<\"AdjustedRSquared\"\>", "0.6244895804152822`"},
    {"\<\"AIC\"\>", "1.4336393167310693`"},
    {"\<\"BIC\"\>", "3.7514054834504122`"},
    {"\<\"RSquared\"\>", "0.6495236083875968`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.907913077586193*^9, 3.9079131059054856`*^9}, {
   3.907913592284546*^9, 3.9079136288937016`*^9}, 3.907913673732597*^9, 
   3.907913787764436*^9, 3.9079141251931033`*^9, 3.907914491760281*^9, 
   3.9079147280219812`*^9, 3.907943030979746*^9, 3.908298372079321*^9, {
   3.9082997805391912`*^9, 3.908299787642547*^9}, 3.908557754762559*^9, 
   3.9086941214413047`*^9, 3.908712134326315*^9, 3.9088200681845465`*^9, 
   3.9088644578068905`*^9, 3.908864943095402*^9, 3.9089154965803256`*^9, 
   3.9089166339769316`*^9, 3.909053716420889*^9, 3.909054355525762*^9, 
   3.909138746700266*^9, 3.9092153039470673`*^9, 3.909487640700661*^9, 
   3.9100879012679167`*^9, 3.910092257709692*^9, 3.910105204542782*^9, 
   3.9101691569332094`*^9, 3.9276192653140645`*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"f51526f0-2b0c-45cc-87f8-b2f5c2ff26f7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lengths of trajectories", "Subsection",
 CellChangeTimes->{{3.9079141687007504`*^9, 3.9079141792529125`*^9}, {
  3.90828953949186*^9, 3.9082895442270217`*^9}, {3.9082901165983095`*^9, 
  3.9082901181834393`*^9}, {3.9087124357269278`*^9, 
  3.9087124371045694`*^9}},ExpressionUUID->"09c36286-91ef-4049-8e87-\
a39e163e76f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lengths", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"NTrack", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.907914183611455*^9, 3.9079142595693197`*^9}, {
  3.9079577473489823`*^9, 3.9079577508407383`*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"0ff53a55-b023-459d-815d-a42835b5e934"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"Ncol", "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", 
     RowBox[{"n", "<", 
      RowBox[{
       RowBox[{"NTrack", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
     RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Aux", "=", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{"Tracks", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n", ",", 
              RowBox[{"t", "+", "1"}]}], "]"}], "]"}], "-", 
           RowBox[{"Tracks", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n", ",", "t"}], "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "1", ",", 
           RowBox[{"Ts", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Lengths", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "n"}], "]"}], "]"}], "=", "Aux"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.9075120840763884`*^9, 3.9075121241798663`*^9}, {
  3.9075124870945153`*^9, 3.9075125554444275`*^9}, {3.9075125970890446`*^9, 
  3.90751260828236*^9}, {3.907512648053403*^9, 3.9075128630667725`*^9}, {
  3.907512952109296*^9, 3.907512955541356*^9}, {3.9075130014430833`*^9, 
  3.907513007849038*^9}, {3.9075130680554123`*^9, 3.907513082948818*^9}, {
  3.907515933624954*^9, 3.907515935173632*^9}, {3.907873090290934*^9, 
  3.9078732353905864`*^9}, {3.907914278004547*^9, 3.907914296815666*^9}, {
  3.908289302646455*^9, 3.9082893034109364`*^9}, {3.908291569336897*^9, 
  3.9082915748774877`*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"ad12b395-fe22-4286-93e6-a15bf97d14f7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Lengthsave", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{"Lengths", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lengthsmed", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Median", "[", 
      RowBox[{"Lengths", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.908866933614929*^9, 3.9088669661863832`*^9}, {
  3.9089822929092894`*^9, 3.9089822984873877`*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"ff99d9f1-b935-48dd-96b9-220746ac6adf"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Activity,  moving at an average speed larger than  0.1 mm/s (A ~ N^3/4, with \
N  tracked animals -- weakly sublinear): figure \
\>", "Subsection",
 CellChangeTimes->{{3.9075120331426153`*^9, 3.9075120394840794`*^9}, {
   3.907872912795745*^9, 3.9078729244063196`*^9}, {3.9079362078526516`*^9, 
   3.9079362263394237`*^9}, {3.9082903070760927`*^9, 
   3.9082903373847327`*^9}, {3.908290392989585*^9, 3.9082903994339066`*^9}, {
   3.9082904772446957`*^9, 3.9082904859437313`*^9}, {3.9082918325526567`*^9, 
   3.9082918589936676`*^9}, 3.9082920684388466`*^9, {3.9082924752253456`*^9, 
   3.9082924857158365`*^9}, {3.908297937807638*^9, 3.9082979517716055`*^9}, 
   3.9082996121387277`*^9, {3.908300752906783*^9, 3.9083007703753867`*^9}, {
   3.9083787049955935`*^9, 3.9083787122828817`*^9}, {3.9087122484158697`*^9, 
   3.9087122503664937`*^9}, {3.9089533471464553`*^9, 3.908953354352809*^9}, 
   3.9276193119876604`*^9, {3.927619381003036*^9, 
   3.9276194241466513`*^9}},ExpressionUUID->"1565cc5f-22cb-4823-8524-\
41187a95ac01"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vthr", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Acttot", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1", ",", 
       RowBox[{"Ts", "-", "1"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9075120486823177`*^9, 3.9075120624104433`*^9}, {
   3.907512166930231*^9, 3.9075122889769306`*^9}, {3.907513136770433*^9, 
   3.9075131369323225`*^9}, {3.907513452580872*^9, 3.9075134787051945`*^9}, {
   3.9075135924896007`*^9, 3.9075136208179927`*^9}, {3.907515927034217*^9, 
   3.9075159298767824`*^9}, {3.907517851696878*^9, 3.90751791062803*^9}, 
   3.907518062407025*^9, 3.907518150899493*^9, 3.9075181968645086`*^9, {
   3.9075777484488945`*^9, 3.9075777503486476`*^9}, {3.9075777823804812`*^9, 
   3.907577804112814*^9}, {3.907859919606638*^9, 3.9078599600543485`*^9}, {
   3.9078599968058057`*^9, 3.907860025317639*^9}, {3.907860059270069*^9, 
   3.9078600787460704`*^9}, 3.9078601132571807`*^9, {3.9078601538636427`*^9, 
   3.907860179669344*^9}, {3.907872934406624*^9, 3.907872934811909*^9}, 
   3.907873269063148*^9, 3.908556037163107*^9, 3.9085560947717266`*^9, {
   3.9085563646924047`*^9, 3.9085563714687667`*^9}, {3.9276193289966364`*^9, 
   3.9276193295277357`*^9}, {3.927619426456358*^9, 3.927619426755535*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"13995f8b-d6f6-4afc-99da-f55be4527fae"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"Ncol", "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aux", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"n", "=", "1"}], ",", 
      RowBox[{"n", "<", 
       RowBox[{
        RowBox[{"NTrack", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
      RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Lengths", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n"}], "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalDelta]t", " ", "Ts"}], ")"}]}], ">", "vthr"}], 
         ",", 
         RowBox[{"Aux", "++"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Acttot", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", "Aux"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.9075120840763884`*^9, 3.9075121241798663`*^9}, {
  3.9075124870945153`*^9, 3.9075125554444275`*^9}, {3.9075125970890446`*^9, 
  3.90751260828236*^9}, {3.907512648053403*^9, 3.9075128630667725`*^9}, {
  3.907512952109296*^9, 3.907512955541356*^9}, {3.9075130014430833`*^9, 
  3.907513007849038*^9}, {3.9075130680554123`*^9, 3.907513082948818*^9}, {
  3.907515933624954*^9, 3.907515935173632*^9}, {3.907873090290934*^9, 
  3.9078732353905864`*^9}, {3.907914584510539*^9, 3.907914591977229*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"d7bfb7cb-d4ba-4114-ade2-73559c133168"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StillAnts", "=", 
  RowBox[{"NTrack", "-", "Acttot"}]}]], "Input",
 CellChangeTimes->{{3.908349266110876*^9, 3.9083492818308764`*^9}, {
  3.908712466610387*^9, 3.908712467207856*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"df0b91ad-270d-4829-95a0-350648142ef1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "76", ",", "52", ",", "6", ",", "18", ",", "48", ",", "14", ",", "88", ",", 
   "28", ",", "43", ",", "43", ",", "176", ",", "53", ",", "193", ",", "69", 
   ",", "197", ",", "99"}], "}"}]], "Output",
 CellChangeTimes->{{3.908349272012763*^9, 3.9083492827728634`*^9}, 
   3.9084357868654675`*^9, 3.9085358136825085`*^9, 3.908553733896708*^9, 
   3.9085560432204323`*^9, 3.908556098319536*^9, 3.9085563747067957`*^9, 
   3.908712467745175*^9, 3.908820068970595*^9, 3.9088644759423556`*^9, 
   3.9088649665659986`*^9, 3.9089155891118474`*^9, 3.908916634763183*^9, 
   3.909053719821581*^9, 3.9090544147044353`*^9, 3.9091387476831393`*^9, 
   3.9092153065069*^9, 3.9094876414130955`*^9, 3.9100879020940356`*^9, 
   3.91009225842464*^9, 3.9101691576732283`*^9, 3.9276193327912407`*^9, 
   3.9276194287378235`*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"547f15ba-1122-4361-bd97-4ca76a3387c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmNtA", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"Acttot", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}], ",", "x",
     ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9074962849395475`*^9, 3.9074963020195236`*^9}, {
   3.907513423267853*^9, 3.9075134236984496`*^9}, 3.907873850339946*^9, 
   3.9079132038905706`*^9, {3.9079137305657845`*^9, 3.907913754588001*^9}, {
   3.907914540673298*^9, 3.9079145461427407`*^9}, {3.9082901584361334`*^9, 
   3.9082901594922276`*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"553b1e46-18c3-4bf4-8c27-a1a55e293a50"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"0.4817110696058284`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.7796621817231398`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {0.4817110696058284, 
     0.7796621817231398}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 0}}, {{
    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}}, {{
      Log[232], 
      Log[156]}, {
      Log[119], 
      Log[67]}, {
      Log[115], 
      Log[109]}, {
      Log[90], 
      Log[72]}, {
      Log[114], 
      Log[66]}, {
      Log[37], 
      Log[23]}, {
      Log[159], 
      Log[71]}, {
      Log[74], 
      Log[46]}, {
      Log[196], 
      Log[153]}, {
      Log[125], 
      Log[82]}, {
      Log[308], 
      Log[132]}, {
      Log[104], 
      Log[51]}, {
      Log[280], 
      Log[87]}, {
      Log[113], 
      Log[44]}, {
      Log[351], 
      Log[154]}, {
      Log[159], 
      Log[60]}}, {{1., 5.44673737166631}, {1., 4.77912349311153}, {1., 
    4.74493212836325}, {1., 4.499809670330265}, {1., 4.736198448394496}, {1., 
    3.6109179126442243`}, {1., 5.0689042022202315`}, {1., 4.30406509320417}, {
    1., 5.278114659230517}, {1., 4.8283137373023015`}, {1., 
    5.730099782973574}, {1., 4.6443908991413725`}, {1., 5.634789603169249}, {
    1., 4.727387818712341}, {1., 5.860786223465865}, {1., 
    5.0689042022202315`}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9074962858950477`*^9, 3.9074963299363155`*^9}, 
   3.907512026765726*^9, 3.9075134242091208`*^9, 3.907513743873456*^9, 
   3.9075777155338397`*^9, 3.907686902046938*^9, 3.9078544593399534`*^9, 
   3.90787286189167*^9, 3.9078738510602846`*^9, 3.907913079301836*^9, 
   3.907913206387114*^9, 3.9079132495991855`*^9, 3.907913397020169*^9, 
   3.907913624705275*^9, 3.9079136712390223`*^9, 3.9079137551756735`*^9, 
   3.9079146127701883`*^9, 3.908290160319899*^9, 3.908291608358599*^9, 
   3.9084357870399303`*^9, 3.9085358138228164`*^9, 3.9085537340952997`*^9, 
   3.908556050831664*^9, 3.908556103611472*^9, 3.9085564017268796`*^9, 
   3.908712480824507*^9, 3.908820068994723*^9, 3.9088644759741063`*^9, 
   3.908864966597311*^9, 3.908915589150334*^9, 3.9089166347842455`*^9, 
   3.909053719890145*^9, 3.909054414739131*^9, 3.909138747693844*^9, 
   3.909215306587608*^9, 3.909487641433717*^9, 3.9100879021025257`*^9, 
   3.9100922584466743`*^9, 3.910169157693175*^9, {3.9276194305239005`*^9, 
   3.9276194369871283`*^9}},
 CellLabel->
  "Out[126]=",ExpressionUUID->"bfb60f55-eafa-4b26-bf5f-41055a7c9898"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Aux", "=", 
   RowBox[{"Normal", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ScalingexpNtA", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"Aux", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SCalingconstNtA", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"(", 
     RowBox[{"Aux", "/.", 
      RowBox[{"x", "->", "0"}]}], ")"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907913391190467*^9, 3.9079133949551897`*^9}, {
  3.9079134488574133`*^9, 3.907913529592462*^9}, {3.907913617543748*^9, 
  3.9079136474528036`*^9}, {3.907913758946082*^9, 3.9079137612022448`*^9}, {
  3.907914619462051*^9, 3.907914621296563*^9}, {3.908290163513764*^9, 
  3.9082901681919*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"d45ee6b6-3e74-46c6-a80c-d119f4091011"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpAN", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Acttot", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"A\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", ".05", "]"}], ",", 
         RowBox[{"Hue", "[", 
          RowBox[{".2", ",", ".7", ",", ".5"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", "500"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "500"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmNtA", "[", "x", "]"}], ",", 
        RowBox[{"lmNtA", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "30"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "150"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9085605542447863`*^9, 3.908560564199716*^9}, 
   3.908712496878395*^9, {3.9089156034853053`*^9, 3.9089156333611174`*^9}, {
   3.9089621339313927`*^9, 3.9089621829813967`*^9}, 3.908983767704612*^9},
 CellLabel->
  "In[130]:=",ExpressionUUID->"57e683b7-8a0a-4d00-ad76-03b0f6cfd3f2"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{5.44673737166631, 5.049856007249537}, {4.77912349311153, 
      4.204692619390966}, {4.74493212836325, 4.6913478822291435`}, {
      4.499809670330265, 4.276666119016055}, {4.736198448394496, 
      4.189654742026425}, {3.6109179126442243`, 3.1354942159291497`}, {
      5.0689042022202315`, 4.2626798770413155`}, {4.30406509320417, 
      3.828641396489095}, {5.278114659230517, 5.030437921392435}, {
      4.8283137373023015`, 4.406719247264253}, {5.730099782973574, 
      4.882801922586371}, {4.6443908991413725`, 3.9318256327243257`}, {
      5.634789603169249, 4.465908118654584}, {4.727387818712341, 
      3.784189633918261}, {5.860786223465865, 5.0369526024136295`}, {
      5.0689042022202315`, 4.0943445622221}}]}, {{}, {}}}, {
    GraphicsComplexBox[CompressedData["
1:eJxF1nk41GsbwHHiZDkmM2ObJIWxD362GdvM3JayVidZji1KUScpylKSo7Sh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     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{78, 167, 157, 148, 140, 133, 128, 79, 80, 81, 82, 83, 
          84, 85, 168, 158, 149, 141, 134, 129, 172, 162, 153, 145, 138, 86, 
          169, 159, 150, 142, 135, 130, 87, 170, 160, 151, 143, 136, 131, 88, 
          89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104,
           105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
          118, 119, 120, 121, 122, 123, 124, 125, 126, 171, 161, 152, 144, 
          137, 132, 173, 163, 154, 146, 139, 174, 164, 155, 147, 175, 165, 
          156, 176, 166, 177, 127, 50, 77, 70, 76, 64, 69, 75, 59, 63, 68, 74,
           55, 58, 62, 67, 73, 52, 54, 57, 61, 66, 72, 49, 48, 47, 46, 45, 44,
           43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27,
           26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10,
           9, 8, 7, 6, 5, 4, 3, 2, 51, 53, 56, 60, 65, 71, 1}}]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwt0llXzVEcBuBzKqVzTp2GIxlKiYgUKilUFGW66SP4AHw2pGRoIBQyZZ4i
lJIhQ5Gp57+4eNZ+92/ti73ftYuPHGs/mhQKhcIc/7+2spudbKeGKoJzyaSw
iFTSWEw6EaLEyCCTOFlkk0MuCZaQx1LyWcZyVrCSAgpZRRHFrKaENayllHWs
p4wNbKScTVRQyWa20MYedlHHNqrZTzMN1FPLAVpoZAcH2UsTh9jHYbbyKniP
4iIkwv9KTCeXOdu/QUdyDh/lWf4E3dln81Z+z1d+Bd2axRmTX/KCUZ7zjKc8
4TGPeMgD7nOPu4xwh9vc4iY3GOY617jKEINc4TKXGOAiF+inj156OM85zjLB
NF/4GfwLd87kjPyBb/wm1SyLcfkdn5kn2SyDbvkNU8zwgyTzGKflLjo5RQcn
ec0kn/geVO5slBPyAga9URY=
          "]]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$23378#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[{78, 167, 157, 148, 140, 133, 128, 79, 80, 81, 82, 83, 84, 
          85, 168, 158, 149, 141, 134, 129, 172, 162, 153, 145, 138, 86, 169, 
          159, 150, 142, 135, 130, 87, 170, 160, 151, 143, 136, 131, 88, 89, 
          90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
          105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
          118, 119, 120, 121, 122, 123, 124, 125, 126, 171, 161, 152, 144, 
          137, 132, 173, 163, 154, 146, 139, 174, 164, 155, 147, 175, 165, 
          156, 176, 166, 177, 127}], LineBox[CompressedData["
1:eJwV0VdOQkEAhtF7LdgR2wLckkswPuveEBA79o69Ye+9i4qV48NJvvkzD5NM
a3tXW2cYBEEHcWocQj70I1ec0k2CJCl6SFPrbgkF/cQ1Z/RSZy/lUz9zwzkx
W4QfneeePqK2Mr70C7dc0M8AgwwxTIYRRhljnAkmmWKaGWaZY54FsiyyxDIr
rLLGOhtsssU2OXbYZY99DjjkiGPqvbmcb/3KHZc02Cr41W880OhcyZ9+p0lX
/X8AzVTTwompCJhuRQw=
          "]]},
        Annotation[#, "Charting`Private`Tag$23378#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.3025850929940512`, 2.3025850929940512`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"A\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"N\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->150,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.302585092994046, 6.214608098422191}, {2.302585092994046, 
   6.214608098422191}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.9085605649125605`*^9, 3.908712497469805*^9, 3.9088200690620165`*^9, 
   3.9088644760571513`*^9, {3.9088649666793003`*^9, 3.9088649773392487`*^9}, 
   3.908915589237913*^9, 3.9089156346551423`*^9, 3.908916635486515*^9, {
   3.908962163174947*^9, 3.908962187483227*^9}, 3.9089837696553593`*^9, 
   3.909053723356597*^9, 3.9090544175140715`*^9, 3.909138749246282*^9, 
   3.9092153096615458`*^9, 3.909487642090759*^9, 3.910087902661992*^9, 
   3.9100922589296646`*^9, 3.9101691582040634`*^9, 3.9276194403241405`*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"8a9ca766-0c89-4ced-9334-f8ce43e51335"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigExpAN.pdf\>\"", ",", "FigExpAN"}], "]"}]], "Input",
 CellChangeTimes->{{3.9089621900089045`*^9, 3.908962208421736*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"66d9c88b-c60b-49a3-9c4d-b8d71e512979"],

Cell[BoxData["\<\"FigExpAN.pdf\"\>"], "Output",
 CellChangeTimes->{3.908962210664756*^9, 3.908983772562687*^9, 
  3.9090537244592333`*^9, 3.909054418233509*^9, 3.9091387497238073`*^9, 
  3.909215310623515*^9, 3.9094876423377085`*^9, 3.9100879028627787`*^9, 
  3.910092259119656*^9, 3.910169158398378*^9, 3.9276194422317696`*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"4a0eabb2-98bf-469a-ab75-9b21d2a87547"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaling exponent\>\"", ",", "ScalingexpNtA"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Intercept\>\"", ",", "SCalingconstNtA"}], "}"}], "}"}], 
     ",", 
     RowBox[{"Transpose", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", 
          RowBox[{"lmNtA", "[", "#", "]"}]}], "}"}], "&"}], "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<ParameterConfidenceIntervals\>\"", ",", 
         "\"\<AdjustedRSquared\>\"", ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", 
         ",", "\"\<RSquared\>\""}], "}"}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9079130734392757`*^9, 3.907913073440441*^9}, {
  3.907913104058184*^9, 3.907913105007386*^9}, {3.9079135789480753`*^9, 
  3.9079136668919992`*^9}, {3.9079137829676533`*^9, 3.9079137873094325`*^9}, {
  3.9079146348155255`*^9, 3.9079146392869873`*^9}, {3.908290187695612*^9, 
  3.9082901944857836`*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"ab21e6f2-551a-498e-9d8a-188110f24057"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Scaling exponent\"\>", "0.7796621817231398`"},
    {"\<\"Intercept\"\>", "1.6188419850714808`"},
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.9040775216080188`"}], ",", "1.8674996608196757`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5006413172679738`", ",", "1.0586830461783059`"}], "}"}]}], 
      "}"}]},
    {"\<\"AdjustedRSquared\"\>", "0.6995050224623219`"},
    {"\<\"AIC\"\>", "9.809271651014141`"},
    {"\<\"BIC\"\>", "12.127037817733484`"},
    {"\<\"RSquared\"\>", "0.7195380209648338`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.907913077586193*^9, 3.9079131059054856`*^9}, {
   3.907913592284546*^9, 3.9079136288937016`*^9}, 3.907913673732597*^9, 
   3.907913787764436*^9, 3.9079146395504293`*^9, 3.9082901958639517`*^9, 
   3.9082916157671146`*^9, 3.9084357872449403`*^9, 3.9085358139100947`*^9, 
   3.9085537343025165`*^9, 3.908556061223416*^9, 3.9085561113171525`*^9, 
   3.908556407560111*^9, 3.9087125025378327`*^9, 3.9088200690723944`*^9, 
   3.908864476226474*^9, 3.9088649668174205`*^9, 3.908915589385332*^9, 
   3.9089156560295243`*^9, 3.9089166355002007`*^9, 3.908983791929191*^9, 
   3.9090537245485415`*^9, 3.9090544182838526`*^9, 3.909138749778099*^9, 
   3.909215310682399*^9, 3.909487642361993*^9, 3.910087902883292*^9, 
   3.9100922591380577`*^9, 3.91016915841932*^9, 3.9276194431923285`*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"d49fecaf-5edd-4fd2-9fe1-5b477e5a0cc3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmNAstar", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ntab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"Acttot", "[", 
           RowBox[{"[", "i", "]"}], "]"}], 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "/", 
           RowBox[{"NTrack", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}], ",", "x",
     ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9090872917786765`*^9, 3.9090873082728443`*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"5a8fbe96-5bbe-4d70-94bd-ac8d4d662562"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"0.5291023275732957`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.7785596768004344`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {0.5291023275732957, 
     0.7785596768004344}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 0}}, {{
    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}}, {{
      Log[239], 
      Log[
       Rational[9321, 58]]}, {
      Log[120], 
      Log[
       Rational[8040, 119]]}, {
      Log[162], 
      Log[
       Rational[17658, 115]]}, {
      Log[75], 
      Log[60]}, {
      Log[83], 
      Log[
       Rational[913, 19]]}, {
      Log[40], 
      Log[
       Rational[920, 37]]}, {
      Log[254], 
      Log[
       Rational[18034, 159]]}, {
      Log[126], 
      Log[
       Rational[2898, 37]]}, {
      Log[292], 
      Log[
       Rational[11169, 49]]}, {
      Log[146], 
      Log[
       Rational[11972, 125]]}, {
      Log[326], 
      Log[
       Rational[978, 7]]}, {
      Log[157], 
      Log[
       Rational[8007, 104]]}, {
      Log[360], 
      Log[
       Rational[783, 7]]}, {
      Log[175], 
      Log[
       Rational[7700, 113]]}, {
      Log[400], 
      Log[
       Rational[61600, 351]]}, {
      Log[200], 
      Log[
       Rational[4000, 53]]}}, {{1., 5.476463551931511}, {1., 
    4.787491742782046}, {1., 5.087596335232384}, {1., 4.31748811353631}, {1., 
    4.418840607796598}, {1., 3.6888794541139363`}, {1., 5.537334267018537}, {
    1., 4.836281906951478}, {1., 5.676753802268282}, {1., 
    4.983606621708336}, {1., 5.786897381366708}, {1., 5.056245805348308}, {1.,
     5.886104031450156}, {1., 5.1647859739235145`}, {1., 5.991464547107982}, {
    1., 5.298317366548036}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{3.9090873086791725`*^9, 3.909138749844351*^9, 
  3.909215310755371*^9, 3.909487642383938*^9, 3.9100879029032893`*^9, 
  3.910092259158046*^9, 3.910169158438269*^9, 3.927619449754815*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"ca0c1c0d-9b66-42ac-8ab6-06513a25de15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"lmNAstar", "[", "#", "]"}]}], "}"}], "&"}], "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ParameterConfidenceIntervals\>\"", ",", "\"\<AdjustedRSquared\>\"",
        ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", ",", "\"\<RSquared\>\""}], 
      "}"}], "]"}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9079130734392757`*^9, 3.907913073440441*^9}, {
  3.907913104058184*^9, 3.907913105007386*^9}, {3.9079135789480753`*^9, 
  3.9079136668919992`*^9}, {3.9079137829676533`*^9, 3.9079137873094325`*^9}, {
  3.9079146348155255`*^9, 3.9079146392869873`*^9}, {3.908290187695612*^9, 
  3.9082901944857836`*^9}, {3.909087509702113*^9, 3.909087513494594*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"2bafcb10-c9f6-4081-860c-3ee54f501626"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.7748866186395299`"}], ",", "1.8330912737861214`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5258542369758742`", ",", "1.0312651166249944`"}], "}"}]}], 
      "}"}]},
    {"\<\"AdjustedRSquared\"\>", "0.7398720578497976`"},
    {"\<\"AIC\"\>", "9.191872440256127`"},
    {"\<\"BIC\"\>", "11.50963860697547`"},
    {"\<\"RSquared\"\>", "0.7572139206598112`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.907913077586193*^9, 3.9079131059054856`*^9}, {
   3.907913592284546*^9, 3.9079136288937016`*^9}, 3.907913673732597*^9, 
   3.907913787764436*^9, 3.9079146395504293`*^9, 3.9082901958639517`*^9, 
   3.9082916157671146`*^9, 3.9084357872449403`*^9, 3.9085358139100947`*^9, 
   3.9085537343025165`*^9, 3.908556061223416*^9, 3.9085561113171525`*^9, 
   3.908556407560111*^9, 3.9087125025378327`*^9, 3.9088200690723944`*^9, 
   3.908864476226474*^9, 3.9088649668174205`*^9, 3.908915589385332*^9, 
   3.9089156560295243`*^9, 3.9089166355002007`*^9, 3.908983791929191*^9, 
   3.9090537245485415`*^9, 3.9090544182838526`*^9, 3.909087513992185*^9, 
   3.9091387498834515`*^9, 3.9092153108048086`*^9, 3.9094876424085703`*^9, 
   3.910087902921277*^9, 3.91009225916354*^9, 3.9101691584553103`*^9, 
   3.927619450689729*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"6c7852dd-4dfb-4623-bfd9-95337260532d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Results on lengths, showing that average length is constant with the colony \
size but not the average length of the active individuals that instead \
increases (weak trend): figures\
\>", "Subsection",
 CellChangeTimes->{{3.9088954037354774`*^9, 3.908895449157759*^9}, {
  3.9088955669828625`*^9, 3.908895568727022*^9}, {3.908953514292632*^9, 
  3.9089535331693487`*^9}},ExpressionUUID->"24d22dd7-cea3-4823-8773-\
0611ff0a4c5e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LengthsAct", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9085543651298094`*^9, 3.9085543942715535`*^9}, {
  3.9085546240609202`*^9, 3.9085546588974953`*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"eab55784-325d-4fa7-a8d9-277a3eb7083a"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"Ncol", "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aux", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"n", "=", "1"}], ",", 
      RowBox[{"n", "<", 
       RowBox[{
        RowBox[{"NTrack", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
      RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Lengths", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n"}], "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalDelta]t", " ", "Ts"}], ")"}]}], ">", "vthr"}], 
         ",", 
         RowBox[{"AppendTo", "[", 
          RowBox[{
           RowBox[{"LengthsAct", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"Lengths", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n"}], "]"}], "]"}]}], "]"}]}], "]"}], ";"}]}],
      "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.9075120840763884`*^9, 3.9075121241798663`*^9}, {
  3.9075124870945153`*^9, 3.9075125554444275`*^9}, {3.9075125970890446`*^9, 
  3.90751260828236*^9}, {3.907512648053403*^9, 3.9075128630667725`*^9}, {
  3.907512952109296*^9, 3.907512955541356*^9}, {3.9075130014430833`*^9, 
  3.907513007849038*^9}, {3.9075130680554123`*^9, 3.907513082948818*^9}, {
  3.907515933624954*^9, 3.907515935173632*^9}, {3.907873090290934*^9, 
  3.9078732353905864`*^9}, {3.907914584510539*^9, 3.907914591977229*^9}, {
  3.9085544323942986`*^9, 3.90855444681291*^9}, {3.908554489858141*^9, 
  3.9085545109297185`*^9}, {3.908554557335735*^9, 3.908554568181985*^9}, {
  3.908554627518385*^9, 3.908554665431376*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"b35c9e0f-7020-46e5-8cfa-0b689d2fba74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmLN", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NTrack", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"Lengthsave", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", "x", ",", 
    "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9085595492504883`*^9, 3.9085596043401732`*^9}, {
   3.9085596379742637`*^9, 3.9085596387676134`*^9}, 3.908559838277443*^9, {
   3.908562518319264*^9, 3.908562545251343*^9}, 3.9086275027539573`*^9, 
   3.9088236152073703`*^9, {3.908829616817325*^9, 3.908829617303693*^9}, {
   3.9088299683880596`*^9, 3.908829975239538*^9}, {3.908830027538865*^9, 
   3.908830097803218*^9}, {3.9088303317079062`*^9, 3.908830413273302*^9}, {
   3.908831393089299*^9, 3.9088314062832513`*^9}, {3.9088315620023746`*^9, 
   3.9088315644456472`*^9}, {3.9088316339439335`*^9, 3.908831637014491*^9}, {
   3.9088319749477043`*^9, 3.9088320758844843`*^9}, 3.908832189330433*^9, {
   3.908834093632682*^9, 3.90883412499903*^9}, {3.9088341909543176`*^9, 
   3.9088341916591215`*^9}, {3.9088342453896933`*^9, 3.908834255289911*^9}, {
   3.9088342854959755`*^9, 3.9088343127366*^9}, {3.908834377098907*^9, 
   3.9088343797018228`*^9}, {3.90883441226996*^9, 3.9088344176656513`*^9}, {
   3.9088346088540955`*^9, 3.908834622485842*^9}, {3.9088356948336563`*^9, 
   3.90883582958729*^9}, {3.9088374778349257`*^9, 3.9088375410861626`*^9}, {
   3.9088378002062845`*^9, 3.9088378394245176`*^9}, 3.90886450473307*^9, {
   3.9088659670290637`*^9, 3.908865978422961*^9}, {3.9088954999089074`*^9, 
   3.9088955073268175`*^9}, {3.908978423087884*^9, 3.90897843600513*^9}, {
   3.9089784737101784`*^9, 3.908978477067237*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"62c91410-d89d-451e-b1ce-3f4c29c7183c"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"75.57959153240195`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.009086739055461583`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {75.57959153240195, 
     0.009086739055461583}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 
     0}}, {{1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
    1.}}, {{232, 125.95769141099377`}, {119, 93.05149159526202}, {
     115, 132.03088268808793`}, {90, 106.71697068367395`}, {
     114, 64.09094411112362}, {37, 54.98486536904468}, {
     159, 46.216718208642156`}, {74, 96.77835266346496}, {
     196, 77.51577234749082}, {125, 45.97884026707429}, {
     308, 73.20541541124435}, {104, 49.62338044163978}, {
     280, 47.25217785599165}, {113, 64.74484403873713}, {
     351, 87.72557824284978}, {159, 66.80697898997961}}, {{1., 232.}, {1., 
    119.}, {1., 115.}, {1., 90.}, {1., 114.}, {1., 37.}, {1., 159.}, {1., 
    74.}, {1., 196.}, {1., 125.}, {1., 308.}, {1., 104.}, {1., 280.}, {1., 
    113.}, {1., 351.}, {1., 159.}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9085595824127555`*^9, 3.9085596051835546`*^9}, 
   3.908559639215979*^9, {3.9085598349725666`*^9, 3.908559838854435*^9}, 
   3.908561987601351*^9, {3.9085625191831017`*^9, 3.9085625463987517`*^9}, 
   3.908627544364862*^9, 3.9087209838160887`*^9, 3.9088200691022243`*^9, 
   3.9088236159223504`*^9, 3.908829617946108*^9, {3.9088296603684535`*^9, 
   3.908829668745688*^9}, {3.9088299692600503`*^9, 3.908829975802884*^9}, {
   3.9088300579663253`*^9, 3.9088300983132877`*^9}, {3.9088303587281427`*^9, 
   3.9088303846741056`*^9}, 3.908830415573431*^9, 3.908831406932914*^9, 
   3.9088315650396185`*^9, 3.908831637543359*^9, 3.908831696099083*^9, {
   3.9088319760800858`*^9, 3.908832076926712*^9}, 3.9088321899241858`*^9, {
   3.908834094218106*^9, 3.9088341252908354`*^9}, {3.9088342817404957`*^9, 
   3.908834302736191*^9}, 3.9088343384011197`*^9, 3.908834380468869*^9, {
   3.9088344148784094`*^9, 3.908834418063855*^9}, {3.9088346123083863`*^9, 
   3.9088346245444136`*^9}, {3.908835697314076*^9, 3.9088358305594015`*^9}, {
   3.908837478513893*^9, 3.908837541633789*^9}, {3.908837800749715*^9, 
   3.9088378397747407`*^9}, {3.908864501039669*^9, 3.9088645050914125`*^9}, 
   3.9088649893115444`*^9, {3.908865968544375*^9, 3.9088659788344097`*^9}, 
   3.908873923841136*^9, 3.908895508231505*^9, 3.908915663157444*^9, 
   3.9089166355695157`*^9, {3.9089784244428387`*^9, 3.9089784363525763`*^9}, 
   3.908978477636387*^9, 3.908983065181839*^9, 3.9090537248839417`*^9, 
   3.90905441842793*^9, 3.9091387499950128`*^9, 3.9092153109260273`*^9, 
   3.9094876424662085`*^9, 3.910087902968946*^9, 3.9100922592016296`*^9, 
   3.9101691584927883`*^9, 3.927619494712764*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"f8fbe532-da79-40e6-9218-4b459576fc3f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpLN", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Lengthsave", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) [mm]\>\""}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", ".05", "]"}], ",", 
         RowBox[{"Hue", "[", 
          RowBox[{".2", ",", "0.7", ",", ".5"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "400"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "200"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmLN", "[", "x", "]"}], ",", 
        RowBox[{"lmLN", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "500"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "140"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9085605542447863`*^9, 3.908560564199716*^9}, 
   3.908712496878395*^9, {3.908878403022806*^9, 3.9088784063059454`*^9}, {
   3.908878451207192*^9, 3.9088785182461395`*^9}, {3.9089626155697665`*^9, 
   3.908962623150719*^9}, {3.9089828928746085`*^9, 3.9089829121646175`*^9}, {
   3.908983040616728*^9, 3.9089830507579384`*^9}, {3.9089830893806005`*^9, 
   3.908983134690113*^9}, {3.9089832857111654`*^9, 3.908983286079693*^9}, {
   3.908983336534155*^9, 3.9089833425001125`*^9}, {3.9101692110891743`*^9, 
   3.9101692165468135`*^9}, 3.9101697434384913`*^9},
 CellLabel->
  "In[138]:=",ExpressionUUID->"6750d9b3-1f3c-4ab2-9e1c-3a55c44f6e14"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{232., 125.95769141099377`}, {119., 93.05149159526202}, {115., 
      132.03088268808793`}, {90., 106.71697068367395`}, {114., 
      64.09094411112362}, {37., 54.98486536904468}, {159., 
      46.216718208642156`}, {74., 96.77835266346496}, {196., 
      77.51577234749082}, {125., 45.97884026707429}, {308., 
      73.20541541124435}, {104., 49.62338044163978}, {280., 
      47.25217785599165}, {113., 64.74484403873713}, {351., 
      87.72557824284978}, {159., 66.80697898997961}}]}, {{}, {}}}, {
    GraphicsComplexBox[CompressedData["
1:eJw913k4Vc8fB3DZl1IpJVGiRaislQofIes95Kpj57r3WsoaIsuVNX2ThKwR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     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1Hl8z3UcwPHfb3bZaWzJLs1mRCua1cqaHZJKycgRUkNFtRW6dbiiVEI3
HSqKcnQoRaUIHbrpPqgUHZRuSs/PY3889/p83t/Hb4/ffp/PfgX1jXUNMZFI
JEqtH6dqmm7TNTzATVxHX06jH3X0ZwCnM5BBDGYI6X7Hdn2BBdzMJM6ghWdf
64s8yC1MJtv8J93E49zFUDLMv9GXeIhZTCHH/Gd9jaXczTBamn+ra3mYW2ln
9ru+w9NMJddst77OMu6h2Oxv/YBVDKeV2Q59mYV0sv9XP2I2hfZ/6LusZBp5
Znv0DZZTEm36kD+VeXSw/ke3cJR1c56z7qLN6MEX9sdoCmdaZ+p32l1f0VKN
p4pF9p31Pz1OP9ajNYka5tgX6Z9aoe9pmSZSzTP2R2gMlXxuX67JXG+dr7/o
m3SzTmCF9eEa5TPr+XS03qdbeZ6u9rF8aT2CLOvvdR2PcJj9Af2EubS3/0vf
51mm09bsV93ME9zLWRxkvlPX8yi3MYNDzPfqWzzJfZxNa/Nd+iqLuZ0bqOdg
z37QDSzhDm5kJKMYzTmcy3mMYSzncwEX0kAjF3Ex4xjPBC7hUi7jcq7gSq5i
IldzDW28jx91I49xJzMpMP9N3+Yp7udQs/36Ias50j6Or6yP1dRo0//0teEZ
p9CLPlRxPCeH+0QPenJSuDfh9VRSy4nhzMM9Dfcx3C9q6B3ON9zZcHfCXaAk
nGm4i3QK7zHcCTpQHM6XIgppF/6ucF7hjMknj1xyyA6fRzibcHbhvMkik1a0
JIMWpJNGKikkk0RzEkkgnjhiaUb43iuljHIqqOaESNP34f+F9oqk
          "]]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1HeczgUcwPF7zh1uH7e3O/P2qohQcufOCFcpKuXSkLorFZXMhpZRlFnZ
bTRoo4EQLYV2qWhYaSmj973uj/fr8/1+f88fz/P748mura+pCw4KCgrQNdDY
XpzFGXTiVMpp+FwTQgilKc1oThjhRBBJFNHEEEsLWhJHPAkkkkQyKaSSRjoZ
ZJJFK7LJoTVtaEs72tOBXPLIp4BCiiimhFKq6NHwOzmd0ziFas6mG53pSG96
0p0u9KGCM+lLJf0o42YvrdzLOan5+on+RY55lW7lAKn2h/Up3mUvcW6TdCqL
eINviHC/SW9kFDdwPfXUcR3XMpJrGMHVXMWVXMFwLqeWYVzGpQzlEi7mIoYw
mIk8wEJe52vCfY8LdQL38ziv8RVhnl2g47mPx3iVL2nu2SCdxZO8w0+0dB+n
9/Ior/AFzdzP15k8wdv8SAv32/U53uNXktzu0W0cIt2+QF/mc5raz9OP+ZNs
+0r9j/bmLbqfFPNDepxc8wf6O5nm5foPbcxvaYH+oLE6Vsv0hObph1qsRzRL
n9USPaptdZMW6i+aqFO0VI9pB31fi/Sgpul8/ZvW5jW6m1DzufoRf9DKvkL/
pZ15s/5GsvlB3c5hMuzLdD17iLHfps+wkZ9JcLtb57GaXYS41egMlrKO74l2
v1WfZgP7iHe7S+fyEjtp4jZQp7OEtXxHlPsteidzeJHPCHYfoNNYzJt8S6T7
GL2D2bzApwTc++s59KMvfehNNVX0opIKRjOZR3ieHYHGP7Se+j+P/Iqb
          "]]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$28865#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[CompressedData["
1:eJwl0FNwGAEUQNGktu3Uto3/IrXb1Epq27Zt27Zt27Z9Ov04c997O7Ozs0Eh
YcGhgQEBAZ8pTyzLPd3JXEbSlwpUpBLBVKYKValGdWpQk9jecV93MY9R9KMW
cTx7oLuZz2j6k8z9lR5lJVOpTVz3h7qHBYxhAMndX+sxVjGNOsRzf6R7WchY
0rp90rNsZCAp3N7ocVYznYxu3/QiW6lLfLfHuo9FZLX/0quMI13g/393jk0M
IqXbWz3BGnL8+8HckBlkMn/XSxQ0R2WbObeGpxS37UU0BvXMCfSJFtP9mk8j
UZrF9mz6W0voNS2k0SjLeHt6/aLF9bwW0CiUYbM9l4ajJLfshTU6g82p9J2e
JL85MmvNOTWQm+aZZDb/0MtsJ489AnfM9UlofqoHWEJ2+x+9zgQy2L/qBbYw
hNRu7/UU65hFAxK5P9ODLGUiQ0nj/kFPs57ZNCSx+3M9xDImMYwQknj2Qg+z
nMkMpxGNaUJTmtGcFrSkFa1pQyhhtKUd7elARzrRmS50pRvd6UFPetGbpL7j
pR5hBVMYQZD7Rz3DBuaQxe2nXmEHee0RuWsuqjEpRx/7X6DKf5k=
          "]], LineBox[CompressedData["
1:eJwV01NzHGAYhuFNattMbf6F2k3tNjVT23bqNqlt27Zt26mNKwfX3O/37MzO
nmxIWHhop6BAIBBNqZgjOBC4ohuZwVB6UpoylKUc5alARSpRmSpUJch3XNVN
zGQYvUhsf6B7WcREqhFsv6abmcVwepPE/lD3sZgIqhPLfl23EMkIUtte6FFW
0Yektke6nyVMIpTY9hu6lShGksb2Uo+xmr4ksz3WAywli/cHPcdk0nu/0ZPk
cf/UdWR3f9aL1CCO903dRk73N51NJvd7LaJnNJ/+1uI6StPqKy2sxzW3/tBi
ukaz6Sctqhe0gP7VEtpPk+sTLaQHNZd+12VkdX/U8+R3/9EpZHC/1VPkdf/S
9YS4v+glahLX+5ZuZw6ZvaP1LKNJ5/1aT7CW/qSwPdVDLGcqtYhnv607mMsY
BpDS/kwPs4Jp1Ca+/Y7uZB5jGUgdEvjsru5iPuMYRF0S+uye7mYB4xlMPerT
gIY0ojFNaEozwmhOC1rSita0oS3taE8HOhLzpwqnM13oSje6k8jvuK97WMgE
hpDK/lyPsJLpZLS909NsIIf3V71MQfc/Lak99D82yn+Q
          "]]},
        Annotation[#, "Charting`Private`Tag$28865#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) [mm]\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"N\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->140,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 400.}, {0., 200.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9085605649125605`*^9, 3.908712497469805*^9, 3.9088200690620165`*^9, 
   3.9088644760571513`*^9, {3.9088649666793003`*^9, 3.9088649773392487`*^9}, 
   3.908878406902623*^9, {3.90887846178808*^9, 3.908878474386528*^9}, {
   3.908878509351529*^9, 3.908878518572544*^9}, 3.90891566301532*^9, 
   3.9089166355515137`*^9, {3.90896261661874*^9, 3.9089626236717577`*^9}, {
   3.908982893457608*^9, 3.908982912676402*^9}, {3.9089830535710697`*^9, 
   3.908983138006772*^9}, 3.908983288670335*^9, 3.9089833470841465`*^9, 
   3.909053732928755*^9, 3.9090544245960264`*^9, 3.909138753338215*^9, 
   3.909215317736376*^9, 3.909487643960058*^9, 3.910087904293395*^9, 
   3.9100922602737355`*^9, 3.9101691595983887`*^9, {3.910169212360993*^9, 
   3.9101692178794003`*^9}, 3.910169744711871*^9, 3.9276194974036913`*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"1f56d0bf-0f3e-4064-b7ec-b7709f375643"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigExpLN.pdf\>\"", ",", "FigExpLN"}], "]"}]], "Input",
 CellChangeTimes->{{3.9089833480759954`*^9, 3.908983372242585*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"3911afc9-b5b5-4c3f-b711-587043e75fba"],

Cell[BoxData["\<\"FigExpLN.pdf\"\>"], "Output",
 CellChangeTimes->{3.9089833731228857`*^9, 3.9090537334769487`*^9, 
  3.909054425147182*^9, 3.909138753530449*^9, 3.9092153181952477`*^9, 
  3.9094876441165495`*^9, 3.9100879044565587`*^9, 3.9100922603745966`*^9, 
  3.9101691597252235`*^9, 3.9101692194576473`*^9, 3.910169747952441*^9, 
  3.92761949771742*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"bc1d3c0c-2106-4e33-ac01-5dff7d76572a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmLN", "[", "\"\<ParameterTable\>\"", "]"}]], "Input",
 CellChangeTimes->{
  3.9088236957266445`*^9, {3.9088955135680113`*^9, 3.9088955146819043`*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"b0286065-d980-4e3c-b398-2ef9df8952a4"],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"Standard Error\"\>", "\<\"t\
\[Hyphen]Statistic\"\>", "\<\"P\[Hyphen]Value\"\>"},
     {"1", "75.57959153240195`", "15.188783488488406`", "4.976013489802115`", 
      "0.00020337041193675521`"},
     {"x", "0.009086739055461583`", "0.08315570901217262`", 
      "0.10927378484779002`", "0.9145361737601888`"}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
    GridBoxDividers->{
     "ColumnsIndexed" -> {2 -> GrayLevel[0.7]}, 
      "RowsIndexed" -> {2 -> GrayLevel[0.7]}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    GridBoxSpacings->{
     "ColumnsIndexed" -> {2 -> 1}, "RowsIndexed" -> {2 -> 0.75}}],
   "Grid"], "DialogStyle",
  StripOnInput->False]], "Output",
 CellChangeTimes->{
  3.9088236963086643`*^9, 3.9088296195706663`*^9, {3.9088296623383617`*^9, 
   3.9088296698966002`*^9}, {3.908829970955557*^9, 3.9088299787448416`*^9}, {
   3.908830059582793*^9, 3.908830099590012*^9}, {3.908830359903206*^9, 
   3.9088304165421867`*^9}, 3.908831408119751*^9, 3.9088315673077497`*^9, 
   3.908831697085588*^9, {3.90883197763575*^9, 3.90883207824533*^9}, 
   3.908832191869707*^9, {3.908834095800818*^9, 3.9088341263321867`*^9}, {
   3.908834282656129*^9, 3.908834303599911*^9}, 3.9088343392077117`*^9, 
   3.9088343817571135`*^9, 3.908834418852583*^9, 3.908834613334302*^9, {
   3.9088356982016335`*^9, 3.908835831263266*^9}, {3.90883747978965*^9, 
   3.9088375424916487`*^9}, {3.9088378016895876`*^9, 3.9088378364495096`*^9}, 
   3.908864507770815*^9, 3.9088649902070713`*^9, 3.9088659697508073`*^9, 
   3.9088739245542564`*^9, 3.908895515131625*^9, 3.9089156631824846`*^9, 
   3.9089166355926237`*^9, 3.909053733653777*^9, 3.909054425276812*^9, 
   3.909138753567665*^9, 3.9092153183363037`*^9, 3.9094876441341715`*^9, 
   3.9100879044766583`*^9, 3.9100922603916235`*^9, 3.9101691597431746`*^9, 
   3.9276194977647147`*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"b44624e2-5353-4bfa-9c59-8373de2e1b20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"lmLN", "[", "#", "]"}]}], "}"}], "&"}], "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ParameterConfidenceIntervals\>\"", ",", "\"\<AdjustedRSquared\>\"",
        ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", ",", "\"\<RSquared\>\""}], 
      "}"}], "]"}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9079130734392757`*^9, 3.907913073440441*^9}, {
   3.907913104058184*^9, 3.907913105007386*^9}, {3.9079135789480753`*^9, 
   3.9079136668919992`*^9}, {3.9079137829676533`*^9, 
   3.9079137873094325`*^9}, {3.907914119614028*^9, 3.9079141239962473`*^9}, {
   3.9079144859044704`*^9, 3.90791449130338*^9}, {3.9079147222392983`*^9, 
   3.9079147275228705`*^9}, {3.907943025411437*^9, 3.907943030580187*^9}, {
   3.908298362411597*^9, 3.908298370513174*^9}, {3.9086941150919294`*^9, 
   3.908694120852604*^9}, {3.9089534078141613`*^9, 3.9089534171677904`*^9}, 
   3.9090544753683863`*^9},
 CellLabel->
  "In[141]:=",ExpressionUUID->"e2e33516-b571-421f-b763-77fcc0b80d17"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"43.00289090062629`", ",", "108.15629216417761`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.16926451865821268`"}], ",", "0.18743799676913586`"}],
         "}"}]}], "}"}]},
    {"\<\"AdjustedRSquared\"\>", 
     RowBox[{"-", "0.07051551650587763`"}]},
    {"\<\"AIC\"\>", "156.81994033381824`"},
    {"\<\"BIC\"\>", "159.13770650053758`"},
    {"\<\"RSquared\"\>", "0.0008521845945141808`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.907913077586193*^9, 3.9079131059054856`*^9}, {
   3.907913592284546*^9, 3.9079136288937016`*^9}, 3.907913673732597*^9, 
   3.907913787764436*^9, 3.9079141251931033`*^9, 3.907914491760281*^9, 
   3.9079147280219812`*^9, 3.907943030979746*^9, 3.908298372079321*^9, {
   3.9082997805391912`*^9, 3.908299787642547*^9}, 3.908557754762559*^9, 
   3.9086941214413047`*^9, 3.908712134326315*^9, 3.9088200681845465`*^9, 
   3.9088644578068905`*^9, 3.908864943095402*^9, 3.9089154965803256`*^9, 
   3.9089166339769316`*^9, 3.9089534177256823`*^9, {3.9089786306926517`*^9, 
   3.9089786569915085`*^9}, 3.9090537470460844`*^9, 3.9090544340482006`*^9, 
   3.9090547064021816`*^9, 3.909138753597763*^9, 3.9092153184333143`*^9, 
   3.9094876441512303`*^9, 3.9100879044941206`*^9, 3.91009226041336*^9, 
   3.910169159765628*^9, 3.92761949784058*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"e9d25aa5-796f-493e-a579-02e7266ce9b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmLmN", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NTrack", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"Lengthsmed", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", "x", ",", 
    "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9085595492504883`*^9, 3.9085596043401732`*^9}, {
   3.9085596379742637`*^9, 3.9085596387676134`*^9}, 3.908559838277443*^9, {
   3.908562518319264*^9, 3.908562545251343*^9}, 3.9086275027539573`*^9, 
   3.9088236152073703`*^9, {3.908829616817325*^9, 3.908829617303693*^9}, {
   3.9088299683880596`*^9, 3.908829975239538*^9}, {3.908830027538865*^9, 
   3.908830097803218*^9}, {3.9088303317079062`*^9, 3.908830413273302*^9}, {
   3.908831393089299*^9, 3.9088314062832513`*^9}, {3.9088315620023746`*^9, 
   3.9088315644456472`*^9}, {3.9088316339439335`*^9, 3.908831637014491*^9}, {
   3.9088319749477043`*^9, 3.9088320758844843`*^9}, 3.908832189330433*^9, {
   3.908834093632682*^9, 3.90883412499903*^9}, {3.9088341909543176`*^9, 
   3.9088341916591215`*^9}, {3.9088342453896933`*^9, 3.908834255289911*^9}, {
   3.9088342854959755`*^9, 3.9088343127366*^9}, {3.908834377098907*^9, 
   3.9088343797018228`*^9}, {3.90883441226996*^9, 3.9088344176656513`*^9}, {
   3.9088346088540955`*^9, 3.908834622485842*^9}, {3.9088356948336563`*^9, 
   3.90883582958729*^9}, {3.9088374778349257`*^9, 3.9088375410861626`*^9}, {
   3.9088378002062845`*^9, 3.9088378394245176`*^9}, 3.90886450473307*^9, {
   3.9088659670290637`*^9, 3.908865978422961*^9}, {3.9088954999089074`*^9, 
   3.9088955073268175`*^9}, {3.908978423087884*^9, 3.90897843600513*^9}, {
   3.9089784737101784`*^9, 3.908978477067237*^9}, {3.908982339023218*^9, 
   3.9089823458621407`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"962a767f-9551-43cc-ae98-8b7e0e818075"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{"27.133082385401757`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.06303597541905176`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {
     27.133082385401757`, -0.06303597541905176}, {{$CellContext`x}, {
      1, $CellContext`x}}, {0, 0}}, {{1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
    1., 1., 1., 1., 1., 
    1.}}, {{232, 58.587752867544054`}, {119, 12.37311243160068}, {
     115, 73.6598305181616}, {90, 33.12500764541859}, {
     114, 17.986660051573786`}, {37, 18.121305524629214`}, {
     159, 1.8633760778211625`}, {74, 27.065134844204202`}, {
     196, 16.152288215672122`}, {125, 10.023185915024769`}, {308, 0.}, {
     104, 2.790991395300538}, {280, 0.}, {113, 0.}, {351, 0.}, {159, 0.}}, {{
    1., 232.}, {1., 119.}, {1., 115.}, {1., 90.}, {1., 114.}, {1., 37.}, {1., 
    159.}, {1., 74.}, {1., 196.}, {1., 125.}, {1., 308.}, {1., 104.}, {1., 
    280.}, {1., 113.}, {1., 351.}, {1., 159.}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9085595824127555`*^9, 3.9085596051835546`*^9}, 
   3.908559639215979*^9, {3.9085598349725666`*^9, 3.908559838854435*^9}, 
   3.908561987601351*^9, {3.9085625191831017`*^9, 3.9085625463987517`*^9}, 
   3.908627544364862*^9, 3.9087209838160887`*^9, 3.9088200691022243`*^9, 
   3.9088236159223504`*^9, 3.908829617946108*^9, {3.9088296603684535`*^9, 
   3.908829668745688*^9}, {3.9088299692600503`*^9, 3.908829975802884*^9}, {
   3.9088300579663253`*^9, 3.9088300983132877`*^9}, {3.9088303587281427`*^9, 
   3.9088303846741056`*^9}, 3.908830415573431*^9, 3.908831406932914*^9, 
   3.9088315650396185`*^9, 3.908831637543359*^9, 3.908831696099083*^9, {
   3.9088319760800858`*^9, 3.908832076926712*^9}, 3.9088321899241858`*^9, {
   3.908834094218106*^9, 3.9088341252908354`*^9}, {3.9088342817404957`*^9, 
   3.908834302736191*^9}, 3.9088343384011197`*^9, 3.908834380468869*^9, {
   3.9088344148784094`*^9, 3.908834418063855*^9}, {3.9088346123083863`*^9, 
   3.9088346245444136`*^9}, {3.908835697314076*^9, 3.9088358305594015`*^9}, {
   3.908837478513893*^9, 3.908837541633789*^9}, {3.908837800749715*^9, 
   3.9088378397747407`*^9}, {3.908864501039669*^9, 3.9088645050914125`*^9}, 
   3.9088649893115444`*^9, {3.908865968544375*^9, 3.9088659788344097`*^9}, 
   3.908873923841136*^9, 3.908895508231505*^9, 3.908915663157444*^9, 
   3.9089166355695157`*^9, {3.9089784244428387`*^9, 3.9089784363525763`*^9}, 
   3.908978477636387*^9, {3.9089823415564804`*^9, 3.9089823514587154`*^9}, 
   3.908983524272456*^9, 3.9090537337625904`*^9, 3.909054425346563*^9, 
   3.909138753628852*^9, 3.9092153185144997`*^9, 3.9094876441851835`*^9, 
   3.910087904520254*^9, 3.910092260432965*^9, 3.910169159784581*^9, 
   3.9276194978845596`*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"a015172d-028f-40cc-93a6-5482f5d6a41e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpLmN", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Lengthsmed", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) [mm]\>\""}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", ".05", "]"}], ",", 
         RowBox[{"Hue", "[", 
          RowBox[{".2", ",", "0.7", ",", ".5"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "400"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "100"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmLmN", "[", "x", "]"}], ",", 
        RowBox[{"lmLmN", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "500"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "140"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9085605542447863`*^9, 3.908560564199716*^9}, 
   3.908712496878395*^9, {3.908878403022806*^9, 3.9088784063059454`*^9}, {
   3.908878451207192*^9, 3.9088785182461395`*^9}, {3.9089626155697665`*^9, 
   3.908962623150719*^9}, {3.908982327484461*^9, 3.9089823289691525`*^9}, 
   3.908982363356954*^9, {3.908982935452779*^9, 3.908983003237942*^9}, {
   3.908983404552809*^9, 3.908983473789949*^9}, {3.90898354186619*^9, 
   3.9089835658994064`*^9}, {3.909507159196969*^9, 3.9095071905713754`*^9}, 
   3.91016949641298*^9, 3.910169751069992*^9},
 CellLabel->
  "In[143]:=",ExpressionUUID->"8dea357f-98e4-48ed-8721-c359014f870c"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{232., 58.587752867544054`}, {119., 12.37311243160068}, {115., 
      73.6598305181616}, {90., 33.12500764541859}, {114., 
      17.986660051573786`}, {37., 18.121305524629214`}, {159., 
      1.8633760778211625`}, {74., 27.065134844204202`}, {196., 
      16.152288215672122`}, {125., 10.023185915024769`}, {308., 0.}, {104., 
      2.790991395300538}, {280., 0.}, {113., 0.}, {351., 0.}, {159., 
      0.}}]}, {{}, {}}}, {GraphicsComplexBox[CompressedData["
1:eJw9mHc81e/7x5Fk73GOJNk7IescXGbZstexxznHMTLKyswsKlLKHqk0xCeF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     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1Hl813McwPGdbe2qdrUD2YFa2mSnNaFtbSuFUI4c5Yq0JUdyk7McRREd
dMhROpSzKCpXOuQMFSFnkQ738fw89sdzr/fn/Xvssd/2/eyXN7RlQHNURERE
JH186a/pukNXMot7uIkTOJGTGMDJnMKpZPieb/U1ZnMvNzOQTK99p68zh/u4
hTz7PbqOhTzCIDraf6+reJwJdLH7Sz/kBcaSb7dX17OIqZxGlv0Pupq5TKTI
7m/9iBe5lQK7fbqBxZQ5t+EL8zSKI1v/MJ/KcirNbfnKfDrZ5h91DdXmJJ4w
H6kx1LHVuae2535zV/1Ha/VjrdEUGnnJuULj6c1252M1lSZucy7U/dpLN2oP
TaaBZ53LNY56vnQ+Rjsw3VyikXxmPlrb8Yq5ShP42nwGOeaf9A2epNQ5lm3m
Bzjc/K9+wsvcziF2v+l7LGEGR9hF8bn5Vc4k13mnvslTTKKb3X+6mWXcwaF2
v+smlvIogznAfpe+xdNM5k4Os/9D3+c5HuMsDrT/Wd9mHg9yF2dzkNd+0XeY
z0OM4xw6eW23ruUZpjCecxnCUM7jfC7gQi5iGBdzCcO5lBE008JILmMUl3MF
V3IVo7maMVzDtVzH9dzAwd7Tr/ouC3iYu+ls/6d+wPPMpLtdNFvMKzjKnMg3
5uM0LbL1//3GcF/pR2+OD3eOevqG+xXuEHX0oZJqelJLE2VUhJ8R7hW9aAzv
IdwBSigOzzncHbpSRJfw3sOzC8873CEKKSCfvPA7h2cRnlV4luH5k0sO2WTR
kUwySCeNVDrQnnakkEwSiSTQlnjiaEMsMUQTPhNLKaeKmvB3oyGi9bPyf5iS
jKM=
          "]]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1Hl8D3Qcx/EdNmNjNsdOdtjl3n2YGZuxNVOtQ0WlVaJj0+EqQjk66L5Q
6I4i3UoXugkpXXShO4oShfLcY388H6/397M9tsfj99hjKQ1N9Y1BAQEBgQwP
bOkwBjOAYgrIo/n7gmlFCKG0Jow2tCWcCNrRnkg6EEU0HelEZ7oQQyxxxJNA
Il3pRhLJpJBKd9JIJ4NMsuhBT3rRmz70pR/Z5FBNBWWUUEg+NVQykP4UcQJD
KKeUWqoY1Pw5MZQ6cpnmQ6vx4UQzmN3ebbSY1+wdzZ+rnc1S+wU+5h+y3G7U
e3iKD/iDJPdr9GqmMoXJTGIiV3ElV3A5E2iikcu4lEu4mPGM4yLGciEXcAN3
8yTv8zvd/N7zdR53sYL32EdXX2vQJTzPNg6T6T5X72Q577KXRPfz9AGe4yMO
keE+R1/mM47R2+0OfYJ3+I0EtzH6Kl8GtvwB9uN++xtC7HyetSO0lK3236Tb
s7WDlvOd3VoLWWO30wF8alfqUe2lt+swjWQgX3kP0WByedx7qLalhLe9K/RX
jddztVqjGMQu7yoNo4i13u21jC/s/+lrL9avaWXn8Ywdrv3ZYh8kzb5evyXU
LuAleztH6Ol9m+4kyM7hMfstfiHO+xx9hc/5jz5ui3Q1m/mL7m7X6Yt8wr/0
cLtVH2UDPxPrdrYu5Gk+5E9S3WfpLTzCen4ixn203scqNnGAFPeZuoCHWceP
dHEfpfeyko3sJ9l9hs7nId7kBzq7n6XXcjMP8gbf08nXztQzGMnpnMapnEI9
J3MSJzKCusCW/4nTuYllvM4eOvp5tXocs6WOPQ==
          "]]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$31708#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[CompressedData["
1:eJwl0FOwnmcUgNFzwsZJY7uxbfMiTWPjxDqxbdto0sa2bdu2bWtlcrHm2Xu/
88/88yUNal0hODAgIOAb5Yhhua87mc1I+vA35fmHClSkEpWJ6TcPdBdzGEVf
qhDL20PdzVxG04+k7m/0GCuYRlViuz/SPcxjDGncvug5NtCfZG5v9TgrmU41
4rg/1r3MZyxp3b7qeTYygORu7/QEq8huD8NN8wwy/vooXJat5DKH4465OnHN
T3Qfec0RWWDOqqEoznV7QY3KOHO6wN/fuZhe0PwamdJssufUPyjJbXth/ZMy
DLSn0PdaVE9qPo1EKVbbc2hYSnDLXkij8a85kwZyxVxAo7DNnFvDc9dcg3jm
p7qfhWSzh+aGeTzpzd/1IpsZREq3D3qKNcwks1sIrpq3U5P49md6gEVMIIPb
D73EFgbzl9tHPc1aZlGLBO7P9SCLmcgQUrl/0jOs4z9qk9D9hR5iCZMYSh0S
eXuph1nKZIZRl8TeXukRljGF4dSjPkE0oCGNaEwTmtKM5rSgJa0IpjVtaEs7
2tOBjnSiM13oSje604Oe9CKJ//Raj7KcqYwgtftnPct6/ieLW0iumXeQxxyB
e+YiGp2y9Lb/BF+8gZg=
          "]], LineBox[CompressedData["
1:eJwV02PYFXYcx+HzZNt+4sJq2S3jqtV6lt2zbFvLxpaXlm23vGXbtm3dvbiv
z/f/O9d1zqsTHNo2pE1QIBD4SnkjbphA4JZuYxbD6U0FfqEilfiVyoTwG1Wo
SjWqU4OaxPN9t3U7/zCCPtQivs/u6A5mM5K+pHJ/rgdZxiRqk8D9ru5kDqPo
R7D7Cz3EciZTh4Tu93QXcxnNH6R2f6mHWcEU6pLI/b7uZh5jyOj2QU+xnv6k
cXulR1jJVH50+6Ln2Ew9Ers90P+YT3bvMFyyx5LJ/qin2UBu7whcsweQ1n6t
RylgR2WVnVPDccX+m6z2Vz1PYTsGW+y8GolS3PAuqrEpS33vJPpQi+v/ml+j
UJoF3jk0LCW57F1EY1KGcd6Z9ZOW0DNaSKOz0c6jEblu/6yxGGin0zd6jIJ2
NFbbuTQ8V+1pZLMDXLD/pQFJvR/pHhbyJ1ncPutZNjGI9G5v9ThrmE5Dkrk/
1r0s4i8Gk8H9nZ5gLTMIJbn7E93HYsYzhN9J4bOnup8lTGAojWhME5rSjOa0
oCWtaM33P11b2tGeDnSkE53pQle60Z0e9CSl332mB1jKRIbxg/t7Pck6ZvKT
WxAX7a3ksyNz0y6mcShHL+9vBneDMg==
          "]]},
        Annotation[#, "Charting`Private`Tag$31708#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) [mm]\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"N\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->140,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 400.}, {-3., 100.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9085605649125605`*^9, 3.908712497469805*^9, 3.9088200690620165`*^9, 
   3.9088644760571513`*^9, {3.9088649666793003`*^9, 3.9088649773392487`*^9}, 
   3.908878406902623*^9, {3.90887846178808*^9, 3.908878474386528*^9}, {
   3.908878509351529*^9, 3.908878518572544*^9}, 3.90891566301532*^9, 
   3.9089166355515137`*^9, {3.90896261661874*^9, 3.9089626236717577`*^9}, 
   3.9089823307629347`*^9, 3.9089823639498014`*^9, 3.908983003702507*^9, 
   3.9089833811634855`*^9, {3.908983416681341*^9, 3.90898347660704*^9}, {
   3.908983527122631*^9, 3.9089835689331064`*^9}, 3.9090537420922265`*^9, 
   3.909054430544814*^9, 3.9091387570517373`*^9, 3.9092153253126154`*^9, 
   3.9094876457168016`*^9, {3.909507161897605*^9, 3.9095071926590333`*^9}, 
   3.910087905972204*^9, 3.9100922615710835`*^9, 3.910169160965607*^9, 
   3.910169498612211*^9, 3.910169752765911*^9, 3.92761950144939*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"83562ba0-0758-4505-955e-ab8f565d848e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigExpLmN.pdf\>\"", ",", "FigExpLmN"}], "]"}]], "Input",
 CellChangeTimes->{{3.9089833480759954`*^9, 3.908983372242585*^9}, {
  3.9089835794017763`*^9, 3.908983581828162*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"a3b5835c-7d6a-4f6d-a872-a8e52a51ed5f"],

Cell[BoxData["\<\"FigExpLmN.pdf\"\>"], "Output",
 CellChangeTimes->{3.9089833731228857`*^9, 3.908983582507761*^9, 
  3.9090537425510745`*^9, 3.909054430849863*^9, 3.9091387573038793`*^9, 
  3.9092153257529826`*^9, 3.909487645815528*^9, 3.909507195015684*^9, 
  3.910087906117529*^9, 3.9100922616710987`*^9, 3.91016916109338*^9, 
  3.9101695007346444`*^9, 3.9101697537521772`*^9, 3.92761950196128*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"671edf4c-67fd-4258-bc80-67115b050bfb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Identification of allometry for metabolic rate versus activity: figure\
\>", "Subsection",
 CellChangeTimes->{{3.9079141687007504`*^9, 3.9079141792529125`*^9}, {
  3.90828953949186*^9, 3.9082895442270217`*^9}, {3.9082901165983095`*^9, 
  3.9082901181834393`*^9}, {3.9085273704952393`*^9, 3.9085273875914993`*^9}, {
  3.908527537244947*^9, 3.908527559052256*^9}, {3.90852793547686*^9, 
  3.9085279396489096`*^9}, {3.9085352133819804`*^9, 3.90853522773883*^9}, {
  3.908555526335861*^9, 3.90855552848499*^9}, {3.9085555730625057`*^9, 
  3.908555577984845*^9}, {3.90872092128771*^9, 3.908720937555536*^9}, {
  3.9088828865481615`*^9, 3.9088829190363455`*^9}, {3.9088833323290606`*^9, 
  3.908883353531047*^9}, {3.9089535747593455`*^9, 3.9089536002775064`*^9}, {
  3.9089536322791615`*^9, 3.908953641256903*^9}, {3.9091508972037244`*^9, 
  3.909150897829909*^9}},ExpressionUUID->"abe7244a-82ae-4418-8896-\
acc088ed5888"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Labeled", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"Btab", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"Nametab", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<A\>\"", ",", "\"\<B [mW]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", ".03", "]"}], ",", 
        RowBox[{"Hue", "[", 
         RowBox[{".2", ",", ".7", ",", ".5"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908561725889757*^9, 3.9085618482095566`*^9}, {
   3.90883463286452*^9, 3.908834653306285*^9}, 3.9088646673554325`*^9, {
   3.908865256140812*^9, 3.908865268027079*^9}, {3.908865318134771*^9, 
   3.908865399847093*^9}, {3.908865436305708*^9, 3.908865444403612*^9}, {
   3.9088657256513605`*^9, 3.9088657798014946`*^9}, {3.9088659819463253`*^9, 
   3.908865999280429*^9}, {3.908866110203593*^9, 3.908866147885292*^9}, {
   3.9088662035792265`*^9, 3.9088662110963287`*^9}, {3.908868642828004*^9, 
   3.9088687303698463`*^9}, {3.9088754222103753`*^9, 3.908875428112427*^9}, {
   3.908878253723591*^9, 3.9088782546556964`*^9}, {3.9090896999188185`*^9, 
   3.9090897002683887`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"efa6c026-0095-4023-8d19-c736d8aee5c0"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {Hue[0.2, 0.7, 0.5], PointSize[0.03], AbsoluteThickness[1.6], 
     PointBox[{{5.049856007249537, 1.1233049012584813`}, {4.204692619390966, 
      0.8539897056767758}, {4.6913478822291435`, 1.179885008796846}, {
      4.276666119016055, 0.8763017236577919}, {4.189654742026425, 
      0.3386128011203239}, {3.1354942159291497`, -0.15315117949417478`}, {
      4.2626798770413155`, 1.1381534632886423`}, {3.828641396489095, 
      0.9470139045169956}, {5.030437921392435, 1.1875384978625112`}, {
      4.406719247264253, 0.8754687373538999}, {4.882801922586371, 
      1.379521476832462}, {3.9318256327243257`, 0.555033878430311}, {
      4.465908118654584, 1.5473497201206787`}, {3.784189633918261, 
      0.9681238805141723}, {5.0369526024136295`, 1.6286521313579048`}, {
      4.0943445622221, 0.9005677714089187}}]}, {
     TagBox[
      {Opacity[0.], PointBox[{{5.049856007249537, 1.1233049012584813`}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {1}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.204692619390966, 0.8539897056767758}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {2}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.6913478822291435`, 1.179885008796846}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {3}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.276666119016055, 0.8763017236577919}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {4}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.189654742026425, 0.3386128011203239}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {5}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{3.1354942159291497`, -0.15315117949417478`}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {6}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.2626798770413155`, 1.1381534632886423`}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {7}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{3.828641396489095, 0.9470139045169956}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {8}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{5.030437921392435, 1.1875384978625112`}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {9}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.406719247264253, 0.8754687373538999}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {10}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.882801922586371, 1.379521476832462}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {11}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{3.9318256327243257`, 0.555033878430311}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {12}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.465908118654584, 1.5473497201206787`}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {13}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{3.784189633918261, 0.9681238805141723}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {14}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{5.0369526024136295`, 1.6286521313579048`}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {15}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4.0943445622221, 0.9005677714089187}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$34952, {
        16}}]& ]}}, {{{{}, {GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{12.499999999999998`, 13.000000000000004`}, {
             4.0943445622221, 0.9882625719141862}], 
            Offset[{12.500000000000002`, 2.6645352591003757`*^-15}, {
             4.0943445622221, 0.9882625719141862}], 
            Offset[{-12.499999999999998`, -2.6645352591003757`*^-15}, {
             4.0943445622221, 0.9882625719141862}], 
            Offset[{-12.500000000000002`, 12.999999999999996`}, {
             4.0943445622221, 0.9882625719141862}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'47s'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{0., 6.5}, {4.0943445622221, 0.9882625719141862}], NCache[
          ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{20., 13.000000000000002`}, {5.073217022014367, 
             1.690661719469981}], 
            Offset[{20., 1.7763568394002505`*^-15}, {5.073217022014367, 
             1.690661719469981}], 
            Offset[{1.7763568394002505`*^-15, -1.7763568394002505`*^-15}, {
             5.073217022014367, 1.690661719469981}], 
            Offset[{-1.7763568394002505`*^-15, 12.999999999999998`}, {
             5.073217022014367, 1.690661719469981}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'47'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{10., 6.5}, {5.073217022014367, 1.690661719469981}], NCache[
          ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{-1.7763568394002505`*^-15, 13.000000000000004`}, {
             3.7479252143175237`, 1.0301334686262484`}], 
            Offset[{1.7763568394002505`*^-15, 2.6645352591003757`*^-15}, {
             3.7479252143175237`, 1.0301334686262484`}], 
            Offset[{-25., -2.6645352591003757`*^-15}, {3.7479252143175237`, 
             1.0301334686262484`}], 
            Offset[{-25., 12.999999999999996`}, {3.7479252143175237`, 
             1.0301334686262484`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'21s'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{-12.5, 6.5}, {3.7479252143175237, 1.0301334686262484}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{-1.7763568394002505`*^-15, 13.000000000000002`}, {
             4.429643699053846, 1.6093593082327549`}], 
            Offset[{1.7763568394002505`*^-15, 1.7763568394002505`*^-15}, {
             4.429643699053846, 1.6093593082327549`}], 
            Offset[{-20., -1.7763568394002505`*^-15}, {4.429643699053846, 
             1.6093593082327549`}], 
            Offset[{-20., 12.999999999999998`}, {4.429643699053846, 
             1.6093593082327549`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'21'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{-10., 6.5}, {4.429643699053846, 1.6093593082327549}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{-1.7763568394002505`*^-15, 2.6645352591003757`*^-15}, {
             3.8955612131235884`, 0.4930242903182349}], 
            Offset[{1.7763568394002505`*^-15, -12.999999999999996`}, {
             3.8955612131235884`, 0.4930242903182349}], 
            Offset[{-25., -13.000000000000004`}, {3.8955612131235884`, 
             0.4930242903182349}], 
            Offset[{-25., -2.6645352591003757`*^-15}, {3.8955612131235884`, 
             0.4930242903182349}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'07s'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{-12.5, -6.5}, {3.8955612131235884, 0.4930242903182349}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{-1.7763568394002505`*^-15, 13.000000000000002`}, {
             4.846537502985633, 1.441531064944538}], 
            Offset[{1.7763568394002505`*^-15, 1.7763568394002505`*^-15}, {
             4.846537502985633, 1.441531064944538}], 
            Offset[{-20., -1.7763568394002505`*^-15}, {4.846537502985633, 
             1.441531064944538}], 
            Offset[{-20., 12.999999999999998`}, {4.846537502985633, 
             1.441531064944538}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'07'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{-10., 6.5}, {4.846537502985633, 1.441531064944538}], NCache[
          ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], 
       {Opacity[0], 
        {Hue[0.2, 0.7, 0.5], PointSize[0.03], AbsoluteThickness[1.6]}, 
        {Hue[0.2, 0.7, 0.5], PointSize[0.03], AbsoluteThickness[1.6], 
         TagBox[
          TooltipBox[PointBox[{4.406719247264253, 0.8754687373538999}],
           StyleBox[
            PaneBox[
             FrameBox[
             "\"'54s'\"", LabelStyle -> {}, Background -> None, 
              ContentPadding -> False, LabelStyle -> {}, Frame -> True, 
              RoundingRadius -> 4, Background -> GrayLevel[1, 0.65], 
              FrameStyle -> None, FrameMargins -> 2, BaselinePosition -> 
              Automatic, LabelingSize -> DirectedInfinity[1], StripOnInput -> 
              False], FrameMargins -> 0], {}, StripOnInput -> False]],
          Annotation[#, 
           Style[
            Pane[
             Framed[
             "'54s'", LabelStyle -> {}, Background -> None, ContentPadding -> 
              False, {LabelStyle -> {}, Frame -> True, RoundingRadius -> 4, 
               Background -> GrayLevel[1, 0.65], FrameStyle -> None, 
               FrameMargins -> 2, BaselinePosition -> Automatic, LabelingSize -> 
               DirectedInfinity[1]}], FrameMargins -> 0], {}], 
           "Tooltip"]& ]}}, GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{20., 13.000000000000002`}, {5.066702340993173, 
             1.2495480859745873`}], 
            Offset[{20., 1.7763568394002505`*^-15}, {5.066702340993173, 
             1.2495480859745873`}], 
            Offset[{1.7763568394002505`*^-15, -1.7763568394002505`*^-15}, {
             5.066702340993173, 1.2495480859745873`}], 
            Offset[{-1.7763568394002505`*^-15, 12.999999999999998`}, {
             5.066702340993173, 1.2495480859745873`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'54'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{10., 6.5}, {5.066702340993173, 1.2495480859745873}], NCache[
          ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{-1.7763568394002505`*^-15, 2.6645352591003757`*^-15}, {
             3.7923769768883577`, 0.8850043164049195}], 
            Offset[{1.7763568394002505`*^-15, -12.999999999999996`}, {
             3.7923769768883577`, 0.8850043164049195}], 
            Offset[{-25., -13.000000000000004`}, {3.7923769768883577`, 
             0.8850043164049195}], 
            Offset[{-25., -2.6645352591003757`*^-15}, {3.7923769768883577`, 
             0.8850043164049195}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'43s'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{-12.5, -6.5}, {3.7923769768883577, 0.8850043164049195}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{20., 13.000000000000002`}, {4.298944296642053, 
             1.2001630514007184`}], 
            Offset[{20., 1.7763568394002505`*^-15}, {4.298944296642053, 
             1.2001630514007184`}], 
            Offset[{1.7763568394002505`*^-15, -1.7763568394002505`*^-15}, {
             4.298944296642053, 1.2001630514007184`}], 
            Offset[{-1.7763568394002505`*^-15, 12.999999999999998`}, {
             4.298944296642053, 1.2001630514007184`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'43'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{10., 6.5}, {4.298944296642053, 1.2001630514007184}], NCache[
          ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{25., 13.000000000000004`}, {
             3.171758635529887, -0.09114159138209867}], 
            Offset[{25., 2.6645352591003757`*^-15}, {
             3.171758635529887, -0.09114159138209867}], 
            Offset[{1.7763568394002505`*^-15, -2.6645352591003757`*^-15}, {
             3.171758635529887, -0.09114159138209867}], 
            Offset[{-1.7763568394002505`*^-15, 12.999999999999996`}, {
             3.171758635529887, -0.09114159138209867}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'23s'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{12.5, 6.5}, {3.171758635529887, -0.09114159138209867}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{-1.7763568394002505`*^-15, 1.7763568394002505`*^-15}, {
             4.153390322425688, 0.27660321300824775`}], 
            Offset[{1.7763568394002505`*^-15, -12.999999999999998`}, {
             4.153390322425688, 0.27660321300824775`}], 
            Offset[{-20., -13.000000000000002`}, {4.153390322425688, 
             0.27660321300824775`}], 
            Offset[{-20., -1.7763568394002505`*^-15}, {4.153390322425688, 
             0.27660321300824775`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'23'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{-10., -6.5}, {4.153390322425688, 0.27660321300824775}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], 
       {Opacity[0], 
        {Hue[0.2, 0.7, 0.5], PointSize[0.03], AbsoluteThickness[1.6]}, 
        {Hue[0.2, 0.7, 0.5], PointSize[0.03], AbsoluteThickness[1.6], 
         TagBox[
          TooltipBox[PointBox[{4.276666119016055, 0.8763017236577919}],
           StyleBox[
            PaneBox[
             FrameBox[
             "\"'14s'\"", LabelStyle -> {}, Background -> None, 
              ContentPadding -> False, LabelStyle -> {}, Frame -> True, 
              RoundingRadius -> 4, Background -> GrayLevel[1, 0.65], 
              FrameStyle -> None, FrameMargins -> 2, BaselinePosition -> 
              Automatic, LabelingSize -> DirectedInfinity[1], StripOnInput -> 
              False], FrameMargins -> 0], {}, StripOnInput -> False]],
          Annotation[#, 
           Style[
            Pane[
             Framed[
             "'14s'", LabelStyle -> {}, Background -> None, ContentPadding -> 
              False, {LabelStyle -> {}, Frame -> True, RoundingRadius -> 4, 
               Background -> GrayLevel[1, 0.65], FrameStyle -> None, 
               FrameMargins -> 2, BaselinePosition -> Automatic, LabelingSize -> 
               DirectedInfinity[1]}], FrameMargins -> 0], {}], 
           "Tooltip"]& ]}}, GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{9.999999999999998, 1.7763568394002505`*^-15}, {
             4.6913478822291435`, 1.0921902082915784`}], 
            Offset[{10.000000000000002`, -12.999999999999998`}, {
             4.6913478822291435`, 1.0921902082915784`}], 
            Offset[{-9.999999999999998, -13.000000000000002`}, {
             4.6913478822291435`, 1.0921902082915784`}], 
            Offset[{-10.000000000000002`, -1.7763568394002505`*^-15}, {
             4.6913478822291435`, 1.0921902082915784`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'14'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{0., -6.5}, {4.6913478822291435, 1.0921902082915784}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{25., 2.6645352591003757`*^-15}, {4.240957038991703, 
             0.7919801175646997}], 
            Offset[{25., -12.999999999999996`}, {4.240957038991703, 
             0.7919801175646997}], 
            Offset[{1.7763568394002505`*^-15, -13.000000000000004`}, {
             4.240957038991703, 0.7919801175646997}], 
            Offset[{-1.7763568394002505`*^-15, -2.6645352591003757`*^-15}, {
             4.240957038991703, 0.7919801175646997}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'05s'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{12.5, -6.5}, {4.240957038991703, 0.7919801175646997}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{20., 1.7763568394002505`*^-15}, {5.086120426850274, 
             1.0612953131464051`}], 
            Offset[{20., -12.999999999999998`}, {5.086120426850274, 
             1.0612953131464051`}], 
            Offset[{1.7763568394002505`*^-15, -13.000000000000002`}, {
             5.086120426850274, 1.0612953131464051`}], 
            Offset[{-1.7763568394002505`*^-15, -1.7763568394002505`*^-15}, {
             5.086120426850274, 1.0612953131464051`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"'05'\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{10., -6.5}, {5.086120426850274, 1.0612953131464051}], 
          NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}]}}, {}}, {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.3025850929940512`, -0.6931471805599437},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"B [mW]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"A\"", HoldForm], TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.5\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{All, All}, {All, All}},
  ImageSize->200,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.302585092994046, 5.298317366548036}, {-0.6931471805599453, 
   2.302585092994046}},
  PlotRangePadding->{{0, 
     Scaled[0.08]}, {0, 
     Scaled[0.12944271909999158`]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.908561755058904*^9, 3.908561848815012*^9}, 
   3.9085619891965847`*^9, {3.908562523560464*^9, 3.908562550455783*^9}, 
   3.9087209875225296`*^9, 3.9088200691782317`*^9, 3.9088236423442216`*^9, 
   3.908831529553953*^9, 3.9088315924743075`*^9, 3.908832280731295*^9, {
   3.908834634277589*^9, 3.908834653733446*^9}, 3.9088645147421193`*^9, 
   3.908864667848838*^9, 3.9088649946553106`*^9, {3.9088653248126717`*^9, 
   3.908865348427142*^9}, {3.9088653816715713`*^9, 3.9088654004330807`*^9}, 
   3.908865438954705*^9, {3.9088657373698826`*^9, 3.908865741270326*^9}, 
   3.9088657805035334`*^9, {3.9088659825932984`*^9, 3.908866000096054*^9}, {
   3.9088661212755623`*^9, 3.908866148762475*^9}, 3.908866211820233*^9, {
   3.9088686439385366`*^9, 3.9088687311150703`*^9}, 3.908873940001277*^9, {
   3.9088754230644193`*^9, 3.9088754284865594`*^9}, 3.90887825504664*^9, 
   3.908916074111973*^9, 3.908916636609256*^9, 3.9090537479856777`*^9, 
   3.909054434573618*^9, 3.9091387596238313`*^9, 3.909216899243416*^9, 
   3.909487646977856*^9, 3.9100879071214256`*^9, 3.910092262510086*^9, 
   3.910170302630369*^9, 3.927619539192566*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"7ed82a47-5ce0-4497-adae-4aad024a8caf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Allometric model in terms of activity only", "Subsubsection",
 CellChangeTimes->{{3.908876011983849*^9, 3.9088760300420794`*^9}, {
  3.9088788145093207`*^9, 
  3.9088788153977585`*^9}},ExpressionUUID->"b37fd94f-f4c5-4a15-b506-\
66b6af492dde"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmAadjB", " ", "=", " ", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Acttot", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "/", 
           RowBox[{"NTrack", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], ",", " ", 
         RowBox[{"Btab", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "1", ",", " ", "Ncol"}], "}"}]}], "]"}], "]"}],
     ",", " ", "x", ",", " ", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9085595492504883`*^9, 3.9085596043401732`*^9}, {
   3.9085596379742637`*^9, 3.9085596387676134`*^9}, 3.908559838277443*^9, {
   3.908562518319264*^9, 3.908562545251343*^9}, 3.9086275027539573`*^9, {
   3.908721148612427*^9, 3.908721166323537*^9}, {3.9088317297284718`*^9, 
   3.9088318136696815`*^9}, {3.9088338609400897`*^9, 3.9088340230322933`*^9}, 
   3.908834089244989*^9, {3.908834196991519*^9, 3.908834197380014*^9}, {
   3.9088342403578224`*^9, 3.9088342408998675`*^9}, {3.908834519779313*^9, 
   3.908834520178314*^9}, {3.9088358369690723`*^9, 3.908835881839166*^9}, {
   3.9088359197355247`*^9, 3.908836048235505*^9}, {3.908836113819805*^9, 
   3.9088363245110893`*^9}, {3.908836359897929*^9, 3.908836459249542*^9}, {
   3.9088365209006367`*^9, 3.90883659325765*^9}, {3.9088366308185673`*^9, 
   3.9088367280084543`*^9}, {3.9088367900026336`*^9, 
   3.9088368131993294`*^9}, {3.90883685185063*^9, 3.908836997653996*^9}, {
   3.9088370355655622`*^9, 3.908837172644148*^9}, {3.908837265435804*^9, 
   3.9088374058565493`*^9}, {3.9088376009122486`*^9, 3.908837674555941*^9}, {
   3.908837722709772*^9, 3.90883778557409*^9}, {3.9088378567416754`*^9, 
   3.908837870296544*^9}, {3.9088379426317472`*^9, 3.9088380286534615`*^9}, {
   3.9088380878676596`*^9, 3.908838198524985*^9}, {3.908864546633247*^9, 
   3.9088646147721663`*^9}, 3.908864832071746*^9, {3.908866005715948*^9, 
   3.9088660361905107`*^9}, {3.9088820831960673`*^9, 3.908882112180256*^9}, {
   3.9088821426943502`*^9, 3.9088821923460517`*^9}, {3.90888233885658*^9, 
   3.908882373484311*^9}, {3.9088835717225633`*^9, 3.9088835723571815`*^9}, {
   3.9088838167370944`*^9, 3.9088838320653706`*^9}, {3.9088838953379655`*^9, 
   3.9088838953379655`*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"56c200bb-906d-4328-b463-0883910b453e"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{
       RowBox[{"-", "2.115736090756717`"}], "+", 
       RowBox[{"0.6804413010277685`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {-2.115736090756717, 
     0.6804413010277685}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 0}}, {{
    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}}, {{
      Log[
       Rational[9321, 58]], 1.1233049012584813`}, {
      Log[
       Rational[8040, 119]], 0.8539897056767758}, {
      Log[
       Rational[17658, 115]], 1.179885008796846}, {
      Log[60], 0.8763017236577919}, {
      Log[
       Rational[913, 19]], 0.3386128011203239}, {
      Log[
       Rational[920, 37]], -0.15315117949417478`}, {
      Log[
       Rational[18034, 159]], 1.1381534632886423`}, {
      Log[
       Rational[2898, 37]], 0.9470139045169956}, {
      Log[
       Rational[11169, 49]], 1.1875384978625112`}, {
      Log[
       Rational[11972, 125]], 0.8754687373538999}, {
      Log[
       Rational[978, 7]], 1.379521476832462}, {
      Log[
       Rational[8007, 104]], 0.555033878430311}, {
      Log[
       Rational[783, 7]], 1.5473497201206787`}, {
      Log[
       Rational[7700, 113]], 0.9681238805141723}, {
      Log[
       Rational[61600, 351]], 1.6286521313579048`}, {
      Log[
       Rational[4000, 53]], 0.9005677714089187}}, {{1., 5.079582187514737}, {
    1., 4.213060869061483}, {1., 5.034012089098278}, {1., 4.0943445622221}, {
    1., 3.8722969014285282`}, {1., 3.2134557573988616`}, {1., 
    4.7311099418396205`}, {1., 4.360858210236403}, {1., 5.4290770644302}, {1.,
     4.562012131670288}, {1., 4.939599520979504}, {1., 4.343680538931261}, {
    1., 4.71722254693549}, {1., 4.221587789129435}, {1., 5.167630926055745}, {
    1., 4.323757726549906}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{3.908883916911308*^9, 3.90891607432092*^9, 
  3.90891663669166*^9, 3.908917253081581*^9, 3.9090537482179956`*^9, 
  3.9090544346555724`*^9, 3.909138759916148*^9, 3.90921689944617*^9, 
  3.909487647028248*^9, 3.9100879072857113`*^9, 3.910092262652834*^9, 
  3.9101703027634044`*^9, 3.9276195392712083`*^9},
 CellLabel->
  "Out[146]=",ExpressionUUID->"293532a0-73dc-40f8-9bcf-a4585c7beeb1"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Aux", "=", 
   RowBox[{"Normal", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ScalingexpAadjB", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"Aux", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SCalingconstAadjB", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"(", 
     RowBox[{"Aux", "/.", 
      RowBox[{"x", "->", "0"}]}], ")"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907913391190467*^9, 3.9079133949551897`*^9}, {
  3.9079134488574133`*^9, 3.907913529592462*^9}, {3.907913617543748*^9, 
  3.9079136474528036`*^9}, {3.907913758946082*^9, 3.9079137612022448`*^9}, {
  3.9079140927792892`*^9, 3.9079140957022033`*^9}, {3.90791446134632*^9, 
  3.907914462900561*^9}, {3.9079147076068316`*^9, 3.9079147098945436`*^9}, {
  3.907943013439031*^9, 3.907943016763689*^9}, {3.9082983396644115`*^9, 
  3.9082983488595004`*^9}, {3.908883536658125*^9, 3.908883544005973*^9}, {
  3.9088835751856174`*^9, 3.9088835795965676`*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"5b53c628-f810-4917-88c4-461026e9af3c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"B0", "=", "SCalingconstAadjB"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]B", "=", "ScalingexpAadjB"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9088836211540146`*^9, 3.90888362179373*^9}, {
   3.9088836581164246`*^9, 3.9088836720179167`*^9}, 3.9090710860467777`*^9},
 CellLabel->
  "In[150]:=",ExpressionUUID->"d7b393b5-f9a1-4a4c-a807-758e0f92d345"],

Cell[BoxData["0.12054452517709216`"], "Output",
 CellChangeTimes->{3.9090710865956106`*^9, 3.909138759965209*^9, 
  3.9092168994738617`*^9, 3.9094876470381966`*^9, 3.910087907306054*^9, 
  3.9100922626713943`*^9, 3.910170302770918*^9, 3.927619539318087*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"e825a7bc-564e-4ddc-8223-410ac32fb091"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"lmAadjB", "[", "#", "]"}]}], "}"}], "&"}], "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ParameterConfidenceIntervals\>\"", ",", "\"\<AdjustedRSquared\>\"",
        ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", ",", "\"\<RSquared\>\""}], 
      "}"}], "]"}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908565455811391*^9, 3.9085654594714317`*^9}, {
  3.9087212477429514`*^9, 3.908721249078607*^9}, {3.9088835823075304`*^9, 
  3.908883582953776*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"6e1c59f6-81c5-4831-a195-c7559f1445fb"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.183621768510028`"}], ",", 
         RowBox[{"-", "1.0478504130034056`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.44579985389679583`", ",", "0.9150827481587411`"}], "}"}]}],
       "}"}]},
    {"\<\"AdjustedRSquared\"\>", "0.7152877712211445`"},
    {"\<\"AIC\"\>", "3.2584053788946026`"},
    {"\<\"BIC\"\>", "5.576171545613946`"},
    {"\<\"RSquared\"\>", "0.7342685864730683`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.908565460104661*^9, 3.9087209951126814`*^9, 3.9087212496493053`*^9, 
   3.908820069356599*^9, 3.908832330971092*^9, {3.908833982943505*^9, 
   3.9088340261913023`*^9}, 3.9088342007281275`*^9, 3.908834523191272*^9, 
   3.908835872126923*^9, 3.9088359318902693`*^9, {3.9088359671607904`*^9, 
   3.908836053764309*^9}, {3.9088361199029274`*^9, 3.908836137355007*^9}, {
   3.90883618439703*^9, 3.908836247619912*^9}, {3.9088362856026707`*^9, 
   3.9088363064435472`*^9}, {3.908836367507636*^9, 3.90883646189174*^9}, 
   3.9088364972258863`*^9, 3.908836529232568*^9, {3.908836566579833*^9, 
   3.9088365954086814`*^9}, {3.9088366335813694`*^9, 3.908836730090963*^9}, {
   3.9088367923016567`*^9, 3.908836816548937*^9}, {3.90883688140945*^9, 
   3.908836919476843*^9}, {3.908836959852868*^9, 3.9088369993856325`*^9}, {
   3.908837062192215*^9, 3.9088370908190145`*^9}, {3.908837126164199*^9, 
   3.908837174037033*^9}, 3.9088373038203573`*^9, 3.9088373502246513`*^9, {
   3.908837398251463*^9, 3.908837407068878*^9}, {3.9088376224043875`*^9, 
   3.908837676310507*^9}, {3.908837725027149*^9, 3.9088377878381643`*^9}, {
   3.9088378590253725`*^9, 3.90883787218047*^9}, {3.908837947084676*^9, 
   3.908837991956331*^9}, {3.9088380832473326`*^9, 3.9088380966754055`*^9}, {
   3.908838149957981*^9, 3.9088382017746267`*^9}, {3.9088645393291836`*^9, 
   3.9088646090700006`*^9}, 3.9088648338491783`*^9, {3.908866009091884*^9, 
   3.9088660304258394`*^9}, 3.908868067634577*^9, {3.908882103920802*^9, 
   3.9088821134860325`*^9}, {3.9088821567821574`*^9, 3.9088821603933244`*^9}, 
   3.908882194049056*^9, 3.9088823441799445`*^9, 3.9088823761482277`*^9, 
   3.9088835834078116`*^9, 3.9088838358289385`*^9, 3.9088839187491236`*^9, 
   3.90891607435349*^9, 3.908916636737255*^9, 3.9089172531312323`*^9, 
   3.9090537483310328`*^9, 3.9090544347237687`*^9, 3.909138760010903*^9, 
   3.9092168994999814`*^9, 3.909487647063323*^9, 3.910087907325035*^9, 
   3.910092262686371*^9, 3.9101703027880487`*^9, 3.927619539333711*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"c9e43c55-31b0-47a5-93db-c4222983bb95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpBAstar", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "/", 
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
          RowBox[{"Btab", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[SuperscriptBox[StyleBox[\"A\",FontSlant->\"Italic\
\"], \"*\"],FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"B\",FontSlant->\"Italic\"]\) [mW]\>\""}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", ".05", "]"}], ",", 
         RowBox[{"Hue", "[", 
          RowBox[{".2", ",", ".7", ",", ".5"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", "200"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmAadjB", "[", "x", "]"}], ",", 
        RowBox[{"lmAadjB", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "200"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "150"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.908561725889757*^9, 3.9085618482095566`*^9}, {
   3.9087211838301864`*^9, 3.9087212282246017`*^9}, {3.908864813907333*^9, 
   3.908864816847732*^9}, 3.908882507361575*^9, {3.9088835935751*^9, 
   3.908883596951809*^9}, {3.9088838466314907`*^9, 3.9088838716151657`*^9}, {
   3.90888390552658*^9, 3.908883909954342*^9}, {3.9089161106232915`*^9, 
   3.9089161324879065`*^9}, {3.9089628201087976`*^9, 3.908962833352515*^9}, {
   3.9089630099752617`*^9, 3.908963074558509*^9}, {3.908984887574338*^9, 
   3.9089848893402233`*^9}, {3.9090896926015587`*^9, 3.909089693005169*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"19707622-8a25-48b7-bb4a-7f0412263b00"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{5.079582187514737, 1.1233049012584813`}, {4.213060869061483, 
      0.8539897056767758}, {5.034012089098278, 1.179885008796846}, {
      4.0943445622221, 0.8763017236577919}, {3.8722969014285282`, 
      0.3386128011203239}, {3.2134557573988616`, -0.15315117949417478`}, {
      4.7311099418396205`, 1.1381534632886423`}, {4.360858210236403, 
      0.9470139045169956}, {5.4290770644302, 1.1875384978625112`}, {
      4.562012131670288, 0.8754687373538999}, {4.939599520979504, 
      1.379521476832462}, {4.343680538931261, 0.555033878430311}, {
      4.71722254693549, 1.5473497201206787`}, {4.221587789129435, 
      0.9681238805141723}, {5.167630926055745, 1.6286521313579048`}, {
      4.323757726549906, 0.9005677714089187}}]}, {{}, {}}}, {
    GraphicsComplexBox[CompressedData["
1:eJxF1Xk41HvYx/EZSwhlKdtRWcpSskQqp87vNowty5iMffkZZvwyUdaQSiqn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     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{78, 170, 157, 146, 137, 131, 128, 173, 160, 149, 140, 
          134, 177, 164, 153, 144, 79, 171, 158, 147, 181, 168, 138, 179, 166,
           155, 132, 176, 163, 152, 143, 129, 174, 161, 150, 141, 135, 80, 81,
           82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
           99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
          112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 
          125, 126, 172, 159, 148, 139, 133, 130, 175, 162, 151, 142, 136, 
          178, 165, 154, 145, 180, 167, 156, 182, 169, 183, 127, 50, 77, 70, 
          76, 64, 69, 75, 59, 63, 68, 74, 55, 58, 62, 67, 73, 52, 54, 57, 61, 
          66, 72, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 
          34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 
          17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 51, 53, 56, 
          60, 65, 71, 1}}]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwt0llXiFEUBuBPI83zSEnmojkZQoRMN36CH8B/c1WINI80yhApFaXBTISe
z+riWfvdZ52Lc/baRTdv37gVEQTBNu5s1Us0cIo6aqgivBdJFNHEEMt2dhBH
PAkkkkQyKaSSRjoZZJJFNjnkkkc+O9lFAYXspog9FLOXfeznAAc5xGFKKOUI
RymjnAqaOEc9x6mlmsuc5zQnOMYVGjnDSa5ygbNc4yLXqWQxfLPBJZNPJInk
sh7OVI0nm0/67/wN56bPYFle4ysb4VydpfFefscC88zxlllmeMM0r3nFFC95
wXOeMclTJhhnjFFGGOYJjxlikAH66aOXHrrpopMO2nlEGw95QCv3ucddPvCD
f+Fu+Esmq3KEmkAOX8IdUfP4LUerqbTIP4Pg/zLGkcVH7Tf+EKtPZ0le4TO/
iHKWQrO8CedfTZI=
          "]]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$36249#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[{78, 170, 157, 146, 137, 131, 128, 173, 160, 149, 140, 134, 
          177, 164, 153, 144, 79, 171, 158, 147, 181, 168, 138, 179, 166, 155,
           132, 176, 163, 152, 143, 129, 174, 161, 150, 141, 135, 80, 81, 82, 
          83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
          100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
          113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
          126, 172, 159, 148, 139, 133, 130, 175, 162, 151, 142, 136, 178, 
          165, 154, 145, 180, 167, 156, 182, 169, 183, 127}], 
         LineBox[CompressedData["
1:eJwVz0dSQkEABNCPCbNgThuvxBGocqvXUxTBnAMmFMWcc46oPBevunumZjE9
8f5YXygIgl4GiBhlfOlP3HJFk7MwP/orD7Ta1f+P+RCDRPVyvvVOWc+z3i5r
KeHObpFV/OnvXJNgiGGSjJAizShjjDPBJFNMM8Msc8yzwCJLLLNChlXWWGeD
TbJssU2OHXbJs8c+BxxyxDEnnHLGORc0+ksFBf2Fe25odlbJr/7GI212DSE+
7Q5ZRyldNNDNpbsibJdBiA==
          "]]},
        Annotation[#, "Charting`Private`Tag$36249#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.3025850929940512`, -0.6931471805599437},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"B\\\",FontSlant->\\\"Italic\\\"]\\) [mW]\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[SuperscriptBox[StyleBox[\\\"A\\\",FontSlant->\\\"\
Italic\\\"], \\\"*\\\"],FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.5\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->150,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.302585092994046, 5.298317366548036}, {-0.6931471805599453, 
   2.302585092994046}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.908561755058904*^9, 3.908561848815012*^9}, 
   3.9085619891965847`*^9, {3.908562523560464*^9, 3.908562550455783*^9}, 
   3.9087209875225296`*^9, {3.90872119117194*^9, 3.9087212294397335`*^9}, 
   3.9088200693454833`*^9, 3.9088323294478893`*^9, 3.908833929422016*^9, 
   3.9088341993430166`*^9, 3.908834522076676*^9, 3.9088358389001274`*^9, 
   3.908836230063722*^9, {3.908864824900614*^9, 3.9088648346284647`*^9}, 
   3.9088680783390565`*^9, {3.9088824783647194`*^9, 3.90888250831894*^9}, 
   3.9088835973881454`*^9, {3.908883840692136*^9, 3.9088838721730776`*^9}, 
   3.9088839243183537`*^9, 3.908916074413335*^9, {3.908916126571002*^9, 
   3.9089161337667713`*^9}, 3.908916637673383*^9, 3.908917253893717*^9, 
   3.9089628344789963`*^9, 3.9089630303942814`*^9, 3.908963076064682*^9, 
   3.9089848905971723`*^9, 3.9090537520537624`*^9, 3.909054436968068*^9, 
   3.9090896943645434`*^9, 3.909138761546446*^9, 3.909216900419711*^9, 
   3.909487647758317*^9, 3.910087907917813*^9, 3.910092263203164*^9, 
   3.9101703032948875`*^9, 3.9276195404505796`*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"de4ce331-fca7-4055-86cb-c28081357e9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigExpBAstar.pdf\>\"", ",", "FigExpBAstar"}], "]"}]], "Input",
 CellChangeTimes->{{3.9089630779656663`*^9, 3.9089630983493056`*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"d8092157-be1e-4fd0-9b0c-f33dd36ef9b3"],

Cell[BoxData["\<\"FigExpBAstar.pdf\"\>"], "Output",
 CellChangeTimes->{3.9089630991714144`*^9, 3.908984893599962*^9, 
  3.90905375338204*^9, 3.909054437529643*^9, 3.909089695812767*^9, 
  3.909138762263055*^9, 3.9092169007003193`*^9, 3.9094876479750247`*^9, 
  3.9100879081188216`*^9, 3.9100922633632607`*^9, 3.9101703034749312`*^9, 
  3.927619540997814*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"6261f019-8580-460b-9855-10143c39ab0d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Cobb Douglas with active and inactive (scaled by the total) constrained B=B0C \
A^\[Alpha]BC I^(1-\[Alpha]BC): figures\
\>", "Subsubsection",
 CellChangeTimes->{{3.908876037336999*^9, 3.9088760520334415`*^9}, {
   3.908878998992384*^9, 3.9088790000147867`*^9}, {3.9090812042981153`*^9, 
   3.9090812111995387`*^9}, {3.909081446647081*^9, 3.90908147315475*^9}, {
   3.909082681366568*^9, 3.9090826869202127`*^9}, {3.909138321705329*^9, 
   3.9091383497167435`*^9}, {3.909138696942359*^9, 3.9091387189979963`*^9}, {
   3.9091393767012854`*^9, 3.9091393843194427`*^9}, {3.909139495033657*^9, 
   3.9091395133385773`*^9}, 3.9091396152229815`*^9, {3.90914067688618*^9, 
   3.9091406893471622`*^9}, {3.909142279308469*^9, 3.9091422851780777`*^9}, {
   3.9091509082256355`*^9, 
   3.909150910457407*^9}},ExpressionUUID->"ea628322-feb7-45ae-9468-\
c3ff5145f997"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmEXACTCD", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "-", 
            RowBox[{
             RowBox[{"Acttot", "[", 
              RowBox[{"[", "i", "]"}], "]"}], 
             RowBox[{
              RowBox[{"Ntab", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "/", 
              RowBox[{"NTrack", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"Btab", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "-", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", "x", ",", 
    "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9085595492504883`*^9, 3.9085596043401732`*^9}, {
   3.9085596379742637`*^9, 3.9085596387676134`*^9}, 3.908559838277443*^9, {
   3.908562518319264*^9, 3.908562545251343*^9}, 3.9086275027539573`*^9, 
   3.9088236152073703`*^9, {3.908829616817325*^9, 3.908829617303693*^9}, {
   3.9088299683880596`*^9, 3.908829975239538*^9}, {3.908830027538865*^9, 
   3.908830097803218*^9}, {3.9088303317079062`*^9, 3.908830413273302*^9}, {
   3.908831393089299*^9, 3.9088314062832513`*^9}, {3.9088315620023746`*^9, 
   3.9088315644456472`*^9}, {3.9088316339439335`*^9, 3.908831637014491*^9}, {
   3.9088319749477043`*^9, 3.9088320758844843`*^9}, 3.908832189330433*^9, {
   3.908834093632682*^9, 3.90883412499903*^9}, {3.9088341909543176`*^9, 
   3.9088341916591215`*^9}, {3.9088342453896933`*^9, 3.908834255289911*^9}, {
   3.9088342854959755`*^9, 3.9088343127366*^9}, {3.908834377098907*^9, 
   3.9088343797018228`*^9}, {3.90883441226996*^9, 3.9088344176656513`*^9}, {
   3.9088346088540955`*^9, 3.908834622485842*^9}, {3.9088356948336563`*^9, 
   3.90883582958729*^9}, {3.9088374778349257`*^9, 3.9088375410861626`*^9}, {
   3.9088378002062845`*^9, 3.9088378394245176`*^9}, 3.90886450473307*^9, {
   3.9088659670290637`*^9, 3.908865978422961*^9}, {3.9090818653186226`*^9, 
   3.9090819224197755`*^9}, {3.9090820318221684`*^9, 3.909082036674223*^9}, {
   3.9090820736521797`*^9, 3.9090820743229246`*^9}, {3.9090821708307886`*^9, 
   3.909082196135812*^9}, 3.9090825859666634`*^9, {3.9091398598318253`*^9, 
   3.9091399090210695`*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"a7e6cac9-cce9-4056-bd20-7ba550ee0957"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{
       RowBox[{"-", "3.504013047441851`"}], "+", 
       RowBox[{"0.8499643090982822`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {-3.504013047441851, 
     0.8499643090982822}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 0}}, {{
    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}}, {{
      Log[
       Rational[39, 19]], -3.23715461929305}, {
      Log[
       Rational[67, 52]], -3.105622262575168}, {
      Log[
       Rational[109, 6]], -0.9545386673003429}, {
      Log[4], -1.8317484774444182`}, {
      Log[
       Rational[11, 8]], -3.2152303691896695`}, {
      Log[
       Rational[23, 14]], -2.870170050579145}, {-Log[
        Rational[88, 71]], -3.80761341598787}, {
      Log[
       Rational[23, 14]], -2.9174074194055164`}, {
      Log[
       Rational[153, 43]], -2.9723007608688157`}, {
      Log[
       Rational[82, 43]], -3.041024262745698}, {-Log[
        Rational[4, 3]], -3.847760116598823}, {-Log[
        Rational[53, 51]], -3.8271129413287466`}, {-Log[
        Rational[193, 87]], -3.9666548970651125`}, {-Log[
        Rational[69, 44]], -3.7033807792942603`}, {-Log[
        Rational[197, 154]], -3.7852299210222}, {-Log[
        Rational[33, 20]], -3.923965243053477}}, {{1., 0.719122666963206}, {
    1., 0.25344890080953875`}, {1., 2.899588413001089}, {1., 
    1.3862943611198906`}, {1., 0.3184537311185346}, {1., 
    0.49643688631389105`}, {1., -0.21465693743689096`}, {1., 
    0.49643688631389105`}, {1., 1.2692378056988731`}, {1., 
    0.6455191315706907}, {1., -0.28768207245178085`}, {
    1., -0.03846628082779614}, {1., -0.7967820702503019}, {
    1., -0.44991687067899816`}, {1., -0.2462511263243594}, {
    1., -0.5007752879124892}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9085595824127555`*^9, 3.9085596051835546`*^9}, 
   3.908559639215979*^9, {3.9085598349725666`*^9, 3.908559838854435*^9}, 
   3.908561987601351*^9, {3.9085625191831017`*^9, 3.9085625463987517`*^9}, 
   3.908627544364862*^9, 3.9087209838160887`*^9, 3.9088200691022243`*^9, 
   3.9088236159223504`*^9, 3.908829617946108*^9, {3.9088296603684535`*^9, 
   3.908829668745688*^9}, {3.9088299692600503`*^9, 3.908829975802884*^9}, {
   3.9088300579663253`*^9, 3.9088300983132877`*^9}, {3.9088303587281427`*^9, 
   3.9088303846741056`*^9}, 3.908830415573431*^9, 3.908831406932914*^9, 
   3.9088315650396185`*^9, 3.908831637543359*^9, 3.908831696099083*^9, {
   3.9088319760800858`*^9, 3.908832076926712*^9}, 3.9088321899241858`*^9, {
   3.908834094218106*^9, 3.9088341252908354`*^9}, {3.9088342817404957`*^9, 
   3.908834302736191*^9}, 3.9088343384011197`*^9, 3.908834380468869*^9, {
   3.9088344148784094`*^9, 3.908834418063855*^9}, {3.9088346123083863`*^9, 
   3.9088346245444136`*^9}, {3.908835697314076*^9, 3.9088358305594015`*^9}, {
   3.908837478513893*^9, 3.908837541633789*^9}, {3.908837800749715*^9, 
   3.9088378397747407`*^9}, {3.908864501039669*^9, 3.9088645050914125`*^9}, 
   3.9088649893115444`*^9, {3.908865968544375*^9, 3.9088659788344097`*^9}, 
   3.908873923841136*^9, 3.908916637731451*^9, 3.9090537535245757`*^9, 
   3.909054437599844*^9, 3.909082037222108*^9, 3.9090820748521786`*^9, 
   3.9090821975851526`*^9, 3.90908258790053*^9, 3.909083072606299*^9, 
   3.909138762340972*^9, 3.9091399122069793`*^9, 3.9091412360663433`*^9, 
   3.909142476058153*^9, 3.9092169007290444`*^9, 3.909487648003021*^9, 
   3.910087908222227*^9, 3.910092263499446*^9, 3.910170303560622*^9, 
   3.9276195410446944`*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"ba64dfc0-d671-4631-9ff9-6cf8ee957a78"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Aux", "=", 
   RowBox[{"Normal", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ScalingexpBIstarAstarIstar", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"Aux", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SCalingconstBIstarAstarIstar", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"(", 
     RowBox[{"Aux", "/.", 
      RowBox[{"{", 
       RowBox[{"x", "->", "0"}], "}"}]}], ")"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907913391190467*^9, 3.9079133949551897`*^9}, {
  3.9079134488574133`*^9, 3.907913529592462*^9}, {3.907913617543748*^9, 
  3.9079136474528036`*^9}, {3.907913758946082*^9, 3.9079137612022448`*^9}, {
  3.9079140927792892`*^9, 3.9079140957022033`*^9}, {3.90791446134632*^9, 
  3.907914462900561*^9}, {3.9079147076068316`*^9, 3.9079147098945436`*^9}, {
  3.907943013439031*^9, 3.907943016763689*^9}, {3.9082983396644115`*^9, 
  3.9082983488595004`*^9}, {3.908883536658125*^9, 3.908883544005973*^9}, {
  3.9088835751856174`*^9, 3.9088835795965676`*^9}, {3.9090830872123346`*^9, 
  3.9090831123589835`*^9}, {3.9091407145968423`*^9, 3.90914075597561*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"a39526eb-3068-4514-9b26-15b7331d0193"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"B0C", "=", "SCalingconstBIstarAstarIstar"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]BC", "=", "ScalingexpBIstarAstarIstar"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9088836211540146`*^9, 3.90888362179373*^9}, {
   3.9088836581164246`*^9, 3.9088836720179167`*^9}, 3.9090710860467777`*^9, {
   3.9090831397422476`*^9, 3.909083155042466*^9}, {3.909140693304256*^9, 
   3.909140696145994*^9}, {3.909140761561122*^9, 3.9091407765682745`*^9}, 
   3.9091408282302947`*^9, {3.909142470249984*^9, 3.909142472723013*^9}, {
   3.9091426141185975`*^9, 3.9091426167288876`*^9}, 3.9091428528290777`*^9},
 CellLabel->
  "In[159]:=",ExpressionUUID->"31260894-0eac-49fb-9e58-a9cfbbe77c9e"],

Cell[BoxData["0.03007644272271547`"], "Output",
 CellChangeTimes->{3.9091428582796063`*^9, 3.909216900762179*^9, 
  3.9094876480337467`*^9, 3.910087908243166*^9, 3.9100922635099506`*^9, 
  3.910170303566671*^9, 3.9276195410764184`*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"42eb4558-f81c-4011-9001-11d17e836111"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmEXACTCD", "[", "\"\<ParameterTable\>\"", "]"}]], "Input",
 CellChangeTimes->{
  3.9088236957266445`*^9, {3.9090820961953344`*^9, 3.909082096370902*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"ce7f4c98-6992-4f23-9547-5b433500e454"],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"\<\"\"\>", "\<\"Estimate\"\>", "\<\"Standard Error\"\>", "\<\"t\
\[Hyphen]Statistic\"\>", "\<\"P\[Hyphen]Value\"\>"},
     {"1", 
      RowBox[{"-", "3.504013047441851`"}], "0.07156647281538506`", 
      RowBox[{"-", "48.96165633984651`"}], "4.671343451698391`*^-17"},
     {"x", "0.8499643090982822`", "0.07438165186064213`", 
      "11.427069550575917`", "1.748062386915722`*^-8"}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
    GridBoxDividers->{
     "ColumnsIndexed" -> {2 -> GrayLevel[0.7]}, 
      "RowsIndexed" -> {2 -> GrayLevel[0.7]}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    GridBoxSpacings->{
     "ColumnsIndexed" -> {2 -> 1}, "RowsIndexed" -> {2 -> 0.75}}],
   "Grid"], "DialogStyle",
  StripOnInput->False]], "Output",
 CellChangeTimes->{
  3.9088236963086643`*^9, 3.9088296195706663`*^9, {3.9088296623383617`*^9, 
   3.9088296698966002`*^9}, {3.908829970955557*^9, 3.9088299787448416`*^9}, {
   3.908830059582793*^9, 3.908830099590012*^9}, {3.908830359903206*^9, 
   3.9088304165421867`*^9}, 3.908831408119751*^9, 3.9088315673077497`*^9, 
   3.908831697085588*^9, {3.90883197763575*^9, 3.90883207824533*^9}, 
   3.908832191869707*^9, {3.908834095800818*^9, 3.9088341263321867`*^9}, {
   3.908834282656129*^9, 3.908834303599911*^9}, 3.9088343392077117`*^9, 
   3.9088343817571135`*^9, 3.908834418852583*^9, 3.908834613334302*^9, {
   3.9088356982016335`*^9, 3.908835831263266*^9}, {3.90883747978965*^9, 
   3.9088375424916487`*^9}, {3.9088378016895876`*^9, 3.9088378364495096`*^9}, 
   3.908864507770815*^9, 3.9088649902070713`*^9, 3.9088659697508073`*^9, 
   3.9088739245542564`*^9, 3.908916637752509*^9, 3.9090537536206045`*^9, 
   3.909054437651847*^9, 3.909082096740009*^9, 3.909082199944033*^9, 
   3.9090825909633894`*^9, 3.909138762942021*^9, 3.909140112011923*^9, {
   3.9091408067727203`*^9, 3.909140830355631*^9}, 3.909216900771179*^9, 
   3.909487648058814*^9, 3.910087908276038*^9, 3.910092263513979*^9, 
   3.9101703035829763`*^9, 3.9276195411076655`*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"12036562-542a-46cc-ad2e-cbc3742729e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"lmEXACTCD", "[", "#", "]"}]}], "}"}], "&"}], "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ParameterConfidenceIntervals\>\"", ",", "\"\<AdjustedRSquared\>\"",
        ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", ",", "\"\<RSquared\>\""}], 
      "}"}], "]"}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908565455811391*^9, 3.9085654594714317`*^9}, {
  3.9090821218584633`*^9, 3.9090821220087643`*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"f4da3f49-302f-477f-b140-97ef4220832d"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.65750786563752`"}], ",", 
         RowBox[{"-", "3.3505182292461817`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6904315323622405`", ",", "1.009497085834324`"}], "}"}]}], 
      "}"}]},
    {"\<\"AdjustedRSquared\"\>", "0.8962497167326511`"},
    {"\<\"AIC\"\>", "6.790604032942964`"},
    {"\<\"BIC\"\>", "9.108370199662307`"},
    {"\<\"RSquared\"\>", "0.9031664022838076`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.908565460104661*^9, 3.9087209951126814`*^9, 3.9088200691883173`*^9, 
   3.9088236488812532`*^9, 3.9088645241975603`*^9, 3.90891663785767*^9, 
   3.9090537538749285`*^9, 3.909054437847519*^9, 3.909082122747602*^9, 
   3.9090822045161977`*^9, 3.9090825959432783`*^9, 3.9091387630166073`*^9, 
   3.9091401150814667`*^9, {3.9091408080177937`*^9, 3.9091408311176825`*^9}, 
   3.909216900797554*^9, 3.90948764808959*^9, 3.9100879083010283`*^9, 
   3.9100922635199633`*^9, 3.910170303599537*^9, 3.9276195411389227`*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"1d4390eb-ed2a-4a46-95ba-5aa042f5aef8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpBIstarAstarIstar", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Acttot", "[", 
              RowBox[{"[", "i", "]"}], "]"}], 
             RowBox[{
              RowBox[{"Ntab", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "/", 
              RowBox[{"NTrack", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{"Acttot", "[", 
               RowBox[{"[", "i", "]"}], "]"}], 
              RowBox[{
               RowBox[{"Ntab", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "/", 
               RowBox[{"NTrack", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"Btab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{"Acttot", "[", 
               RowBox[{"[", "i", "]"}], "]"}], 
              RowBox[{
               RowBox[{"Ntab", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "/", 
               RowBox[{"NTrack", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[SuperscriptBox[StyleBox[\"A\",FontSlant->\"Italic\
\"], \"*\"],FontSlant->\"Italic\"]\)/\!\(\*SuperscriptBox[StyleBox[\"I\",\
FontSlant->\"Italic\"], \"*\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"B\",FontSlant->\"Italic\"]\)/\!\(\*\
SuperscriptBox[StyleBox[\"I\",FontSlant->\"Italic\"], \"*\"]\) [mW]\>\""}], 
        "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", ".05", "]"}], ",", 
         RowBox[{"Hue", "[", 
          RowBox[{".2", ",", ".7", ",", ".5"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.1", ",", "50"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.5"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmEXACTCD", "[", "x", "]"}], ",", 
        RowBox[{"lmEXACTCD", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "200"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "140"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.908561725889757*^9, 3.9085618482095566`*^9}, {
   3.9087211838301864`*^9, 3.9087212282246017`*^9}, {3.908864813907333*^9, 
   3.908864816847732*^9}, 3.908882507361575*^9, {3.9088835935751*^9, 
   3.908883596951809*^9}, {3.9088838466314907`*^9, 3.9088838716151657`*^9}, {
   3.90888390552658*^9, 3.908883909954342*^9}, {3.9089161106232915`*^9, 
   3.9089161324879065`*^9}, {3.9089628201087976`*^9, 3.908962833352515*^9}, {
   3.9089630099752617`*^9, 3.908963074558509*^9}, {3.908984887574338*^9, 
   3.9089848893402233`*^9}, 3.9090882106514406`*^9, {3.909088376556486*^9, 
   3.909088380446416*^9}, {3.909088446349789*^9, 3.9090884688542695`*^9}, {
   3.9090888819365854`*^9, 3.909088904532073*^9}, {3.909088961792103*^9, 
   3.9090889621611223`*^9}, {3.90908900246678*^9, 3.9090891505379066`*^9}, {
   3.9090892295172896`*^9, 3.909089258000802*^9}, {3.9090896845006466`*^9, 
   3.9090896849848776`*^9}, 3.9091396839600945`*^9, {3.9091399535167*^9, 
   3.90913999061731*^9}, {3.9091400214021206`*^9, 3.9091400852151175`*^9}, {
   3.9091401475226974`*^9, 3.909140187136259*^9}, {3.909140226626648*^9, 
   3.9091402277736664`*^9}, {3.909140278916106*^9, 3.9091402925683937`*^9}, {
   3.9091403500832043`*^9, 3.9091403885358276`*^9}, {3.9091404436295953`*^9, 
   3.9091404877704096`*^9}, {3.909140533729887*^9, 3.9091405639673977`*^9}, {
   3.909140620876221*^9, 3.909140626733197*^9}, {3.909492531422861*^9, 
   3.909492578184225*^9}, {3.9094926136607237`*^9, 3.909492662743888*^9}, 
   3.910183741667404*^9},
 CellLabel->
  "In[163]:=",ExpressionUUID->"1042d7d9-75a7-4a98-9df2-d7b0cf3c353a"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{0.719122666963206, -3.2371546192930505`}, {
      0.25344890080953875`, -3.105622262575168}, {
      2.899588413001089, -0.954538667300343}, {
      1.3862943611198906`, -1.8317484774444182`}, {
      0.3184537311185346, -3.2152303691896695`}, {
      0.49643688631389105`, -2.870170050579145}, {-0.21465693743689113`, \
-3.8076134159878694`}, {0.49643688631389105`, -2.9174074194055164`}, {
      1.2692378056988731`, -2.9723007608688157`}, {
      0.6455191315706907, -3.041024262745698}, {-0.2876820724517809, \
-3.847760116598823}, {-0.03846628082779605, -3.827112941328746}, \
{-0.7967820702503019, -3.966654897065113}, {-0.4499168706789983, \
-3.7033807792942603`}, {-0.24625112632435933`, -3.7852299210222}, \
{-0.5007752879124893, -3.9239652430534764`}}]}, {{}, {}}}, {
    GraphicsComplexBox[CompressedData["
1:eJw91mk8lYvzAPCD0CLZS6VCCpGSLF0xtnRKOA4O51gePHjqRpZyRZROpVDJ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     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{78, 157, 149, 142, 136, 131, 128, 160, 152, 145, 139, 
          134, 79, 158, 150, 143, 137, 132, 129, 80, 81, 82, 83, 84, 85, 86, 
          87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
          103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 159, 151, 
          144, 138, 133, 130, 161, 153, 146, 140, 135, 162, 154, 147, 141, 
          163, 155, 148, 164, 156, 165, 127, 50, 77, 70, 76, 64, 69, 75, 59, 
          63, 68, 74, 55, 58, 62, 67, 73, 52, 54, 57, 61, 66, 72, 49, 48, 47, 
          46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 
          29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 
          12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 51, 53, 56, 60, 65, 71, 1}}]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
          11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
          45, 46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 
          68, 63, 59, 75, 69, 64, 76, 70, 77, 50, 215, 253, 244, 252, 236, 
          243, 251, 229, 235, 242, 250, 223, 228, 234, 241, 249, 218, 221, 
          226, 232, 239, 247, 214, 213, 212, 211, 210, 209, 208, 207, 206, 
          205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 
          192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 
          179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 168, 217, 
          220, 225, 231, 238, 246, 167, 222, 227, 233, 240, 248, 216, 219, 
          224, 230, 237, 245, 166}}]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$38204#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[{78, 157, 149, 142, 136, 131, 128, 160, 152, 145, 139, 134, 
          79, 158, 150, 143, 137, 132, 129, 80, 81, 82, 83, 84, 85, 86, 87, 
          88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
          104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
          117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 159, 151, 144, 
          138, 133, 130, 161, 153, 146, 140, 135, 162, 154, 147, 141, 163, 
          155, 148, 164, 156, 165, 127}], 
         LineBox[{166, 245, 237, 230, 224, 219, 216, 248, 240, 233, 227, 222, 
          167, 246, 238, 231, 225, 220, 217, 168, 169, 170, 171, 172, 173, 
          174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
          187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 
          200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 
          213, 214, 247, 239, 232, 226, 221, 218, 249, 241, 234, 228, 223, 
          250, 242, 235, 229, 251, 243, 236, 252, 244, 253, 215}]},
        Annotation[#, "Charting`Private`Tag$38204#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-2.30258509299404, -4.60517018598808},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"B\\\",FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*\
SuperscriptBox[StyleBox[\\\"I\\\",FontSlant->\\\"Italic\\\"], \\\"*\\\"]\\) \
[mW]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[SuperscriptBox[StyleBox[\\\"A\\\",FontSlant->\\\"\
Italic\\\"], \
\\\"*\\\"],FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*SuperscriptBox[StyleBox[\\\"\
I\\\",FontSlant->\\\"Italic\\\"], \\\"*\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.01\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.02\"", ShowStringCharacters -> False], 
           0.02`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.05\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.10\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.20\"", ShowStringCharacters -> False], 
           0.2`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.50\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.199705077879927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.8971199848858813`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.199705077879927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.8971199848858813`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.1\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.5\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->140,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-2.3025850929940455`, 
   3.912023005428146}, {-4.605170185988091, -0.6931471805599453}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.908561755058904*^9, 3.908561848815012*^9}, 
   3.9085619891965847`*^9, {3.908562523560464*^9, 3.908562550455783*^9}, 
   3.9087209875225296`*^9, {3.90872119117194*^9, 3.9087212294397335`*^9}, 
   3.9088200693454833`*^9, 3.9088323294478893`*^9, 3.908833929422016*^9, 
   3.9088341993430166`*^9, 3.908834522076676*^9, 3.9088358389001274`*^9, 
   3.908836230063722*^9, {3.908864824900614*^9, 3.9088648346284647`*^9}, 
   3.9088680783390565`*^9, {3.9088824783647194`*^9, 3.90888250831894*^9}, 
   3.9088835973881454`*^9, {3.908883840692136*^9, 3.9088838721730776`*^9}, 
   3.9088839243183537`*^9, 3.908916074413335*^9, {3.908916126571002*^9, 
   3.9089161337667713`*^9}, 3.908916637673383*^9, 3.908917253893717*^9, 
   3.9089628344789963`*^9, 3.9089630303942814`*^9, 3.908963076064682*^9, 
   3.9089848905971723`*^9, 3.9090537520537624`*^9, 3.909054436968068*^9, {
   3.9090884480549793`*^9, 3.909088469951398*^9}, {3.9090888830199523`*^9, 
   3.909088905323657*^9}, 3.9090889631754045`*^9, {3.909089007186205*^9, 
   3.9090890264596405`*^9}, {3.909089085256922*^9, 3.9090891050943813`*^9}, {
   3.9090891375910764`*^9, 3.9090891511603203`*^9}, {3.9090892475721726`*^9, 
   3.9090892585550547`*^9}, 3.9090896865099516`*^9, 3.9091387625258207`*^9, 
   3.909139945517314*^9, 3.9091400307114487`*^9, {3.909140068609254*^9, 
   3.90914008597348*^9}, 3.9091401590778475`*^9, 3.9091402345366163`*^9, {
   3.9091402795333767`*^9, 3.909140293110012*^9}, {3.9091403511220446`*^9, 
   3.909140389278879*^9}, {3.909140452328319*^9, 3.909140489238495*^9}, {
   3.9091405358518558`*^9, 3.909140565412092*^9}, 3.9091406304336033`*^9, 
   3.9092169015088377`*^9, 3.9094876487291856`*^9, {3.9094925322429104`*^9, 
   3.9094925887532415`*^9}, {3.9094926265770197`*^9, 3.9094926831285686`*^9}, 
   3.910087908817336*^9, 3.910092264020166*^9, 3.9101703040335617`*^9, 
   3.9101837423771276`*^9, 3.927619542577959*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"9547fdc7-2407-4183-b16e-336a0062ea5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<FigExpBIstarAstarIstar.pdf\>\"", ",", "FigExpBIstarAstarIstar"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.90914063552334*^9, 3.9091406568556795`*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"20df1352-898a-40bb-837a-72a9cc7787e8"],

Cell[BoxData["\<\"FigExpBIstarAstarIstar.pdf\"\>"], "Output",
 CellChangeTimes->{3.9091406581459837`*^9, 3.9092169021851077`*^9, 
  3.909487649019372*^9, 3.909492684522278*^9, 3.910087909067788*^9, 
  3.910092264234383*^9, 3.910170304228288*^9, 3.9101837435805163`*^9, 
  3.9276195433636985`*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"41d67f3e-05ac-488c-b6e2-83c59a9ac0ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"100", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B0C", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "-", 
            RowBox[{
             RowBox[{"Acttot", "[", 
              RowBox[{"[", "i", "]"}], "]"}], 
             RowBox[{
              RowBox[{"Ntab", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "/", 
              RowBox[{"NTrack", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"B0C", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", 
          "\[Alpha]BC"}]}], ")"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.909152795771498*^9, 3.909152826367221*^9}, {
  3.9094975300884953`*^9, 3.909497531898015*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"fcfb1d51-754c-4619-86f0-f377a3f5c696"],

Cell[BoxData["1.8492364184484096`"], "Output",
 CellChangeTimes->{{3.9091528149125304`*^9, 3.9091528267153187`*^9}, 
   3.909216902229276*^9, 3.90948764904897*^9, 3.9094975322119102`*^9, 
   3.910087909090344*^9, 3.9100922642403617`*^9, 3.910170304246876*^9, 
   3.9276195434106045`*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"5f84bdae-0dde-4ea3-abc8-4035c5ffa98c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"100", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B0C", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "-", 
            RowBox[{
             RowBox[{"Acttot", "[", 
              RowBox[{"[", "i", "]"}], "]"}], 
             RowBox[{
              RowBox[{"Ntab", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "/", 
              RowBox[{"NTrack", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"B0C", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", 
          "\[Alpha]BC"}]}], ")"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.909153013177619*^9, 3.90915308215413*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"fc07208c-573e-4c51-bf40-298714f28da4"],

Cell[BoxData["9.791329869016757`"], "Output",
 CellChangeTimes->{{3.90915301788074*^9, 3.9091530824083853`*^9}, 
   3.9092169022756443`*^9, 3.9094876490699635`*^9, 3.9100879091083355`*^9, 
   3.910092264244873*^9, 3.910170304261706*^9, 3.9276195434418507`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"fe2c5fa3-41ee-4dfe-90a2-539d1d9baa83"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"BB0C", " ", 
      RowBox[{"AA", "^", "\[Alpha]\[Alpha]BC"}], " ", 
      RowBox[{"II", "^", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]\[Alpha]BC"}], ")"}]}]}], ",", "AA"}], 
    "]"}], "-", 
   RowBox[{"\[Alpha]\[Alpha]BC", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"BB0C", " ", 
        RowBox[{"AA", "^", "\[Alpha]\[Alpha]BC"}], " ", 
        RowBox[{"II", "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      "AA"}], ")"}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.909650833511876*^9, 3.9096508598063602`*^9}, {
  3.909650908952875*^9, 3.9096509690520554`*^9}, {3.909651016315818*^9, 
  3.909651017136653*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"8102c11c-33b6-441c-ae83-f9ef16183b6e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.909650847427238*^9, 3.9096508601794624`*^9}, {
   3.909650917738553*^9, 3.9096509221619115`*^9}, {3.909650962852169*^9, 
   3.909650969464813*^9}, 3.9096510176524506`*^9, 3.910087909114319*^9, 
   3.9100922642478657`*^9, 3.9101703042776966`*^9, 3.927619543473584*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"eb210c01-404f-433b-8f48-c1f8379dc4ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"BB0C", " ", 
      RowBox[{"AA", "^", "\[Alpha]\[Alpha]BC"}], " ", 
      RowBox[{"II", "^", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]\[Alpha]BC"}], ")"}]}]}], ",", "II"}], 
    "]"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Alpha]\[Alpha]BC"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"BB0C", " ", 
        RowBox[{"AA", "^", "\[Alpha]\[Alpha]BC"}], " ", 
        RowBox[{"II", "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      "II"}], ")"}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.909651028591791*^9, 3.909651037661932*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"a1977c53-d23e-4bb3-aba0-4b188646f4ba"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9096510380705285`*^9, 3.910087909121687*^9, 
  3.910092264251469*^9, 3.9101703042823133`*^9, 3.927619543504805*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"78e5c012-8a3d-4336-8530-844503c54e2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"\[Alpha]BC", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"B0C", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "/", 
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", "\[Alpha]BC"}], 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Acttot", "[", 
         RowBox[{"[", "i", "]"}], "]"}], 
        RowBox[{
         RowBox[{"Ntab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "/", 
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.90965129987605*^9, 3.9096513134566793`*^9}, {
  3.909651425003098*^9, 3.909651425355533*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"ba06c662-0eb4-4000-abce-b21e5917a242"],

Cell[BoxData["0.024380063312858816`"], "Output",
 CellChangeTimes->{3.909651313764479*^9, 3.909651425787155*^9, 
  3.9100879091386795`*^9, 3.910092264254467*^9, 3.910170304299821*^9, 
  3.9276195435572214`*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"c61feb25-b59a-4030-a5c1-6097040aedc8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]BC"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"B0C", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "/", 
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", "\[Alpha]BC"}], 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Ntab", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"Acttot", "[", 
          RowBox[{"[", "i", "]"}], "]"}], 
         RowBox[{
          RowBox[{"Ntab", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.909651366458453*^9, 3.9096513720428314`*^9}, {
  3.909651438676226*^9, 3.9096514390675783`*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"04734ba0-eea7-40ce-aa60-99f61bb3a482"],

Cell[BoxData["0.009127116259007832`"], "Output",
 CellChangeTimes->{3.9096513725197067`*^9, 3.90965143942531*^9, 
  3.9100879091471643`*^9, 3.910092264259451*^9, 3.910170304315601*^9, 
  3.9276195435834303`*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"cdda6af3-1813-4d1a-8222-864213c01e28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"\[Alpha]BC", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"B0C", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "/", 
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", "\[Alpha]BC"}], 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Acttot", "[", 
         RowBox[{"[", "i", "]"}], "]"}], 
        RowBox[{
         RowBox[{"Ntab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "/", 
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.90965129987605*^9, 3.9096513134566793`*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"eb1d3f72-1a52-4aa7-8643-febde5fee165"],

Cell[BoxData["0.028810129967287122`"], "Output",
 CellChangeTimes->{3.909651313764479*^9, 3.910087909169655*^9, 
  3.9100922642630057`*^9, 3.910170304331639*^9, 3.9276195436302905`*^9},
 CellLabel->
  "Out[171]=",ExpressionUUID->"05631476-c4b5-48ab-8434-9add7e6d8ee4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]BC"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"B0C", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "/", 
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", "\[Alpha]BC"}], 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Ntab", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"Acttot", "[", 
          RowBox[{"[", "i", "]"}], "]"}], 
         RowBox[{
          RowBox[{"Ntab", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.909651366458453*^9, 3.9096513720428314`*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"85f97287-284b-45d3-8b5c-8acb2ed3bdac"],

Cell[BoxData["0.05305912298447067`"], "Output",
 CellChangeTimes->{3.9096513725197067`*^9, 3.9100879091936283`*^9, 
  3.9100922642680016`*^9, 3.9101703043513985`*^9, 3.927619543661969*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"ce54af10-64f0-415c-b26f-aebfe2b5500c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"\[Alpha]BC", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"B0C", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "/", 
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", "\[Alpha]BC"}], 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Acttot", "[", 
         RowBox[{"[", "i", "]"}], "]"}], 
        RowBox[{
         RowBox[{"Ntab", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "/", 
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.9096513217380753`*^9, 3.9096513222305913`*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"437b1ce2-73a3-4e36-8a93-ef1b7f1430d6"],

Cell[BoxData["0.016545920252138326`"], "Output",
 CellChangeTimes->{3.909651322612975*^9, 3.9100879092116156`*^9, 
  3.910092264271499*^9, 3.910170304365986*^9, 3.9276195436932383`*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"0c3811bd-72d8-4668-846e-2310f178148e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]BC"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"B0C", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Acttot", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{
            RowBox[{"Ntab", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "/", 
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", "\[Alpha]BC"}], 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Ntab", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"Acttot", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", 
             RowBox[{"NTrack", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Ntab", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"Acttot", "[", 
          RowBox[{"[", "i", "]"}], "]"}], 
         RowBox[{
          RowBox[{"Ntab", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.9096513781329613`*^9, 3.9096513786279993`*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"4a607d82-28c5-4ec2-b066-01006b5faab3"],

Cell[BoxData["0.0022924562382098993`"], "Output",
 CellChangeTimes->{3.9096513790133505`*^9, 3.910087909234166*^9, 
  3.910092264276804*^9, 3.91017030438209*^9, 3.9276195437088704`*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"7645d968-2469-45b0-a970-99f9c5de4fd6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigBcontrib", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"\[Alpha]BC", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"B0C", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Acttot", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], 
                 RowBox[{
                  RowBox[{"Ntab", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "/", 
                  RowBox[{"NTrack", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", 
               "\[Alpha]BC"}], " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Ntab", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "-", 
                 RowBox[{
                  RowBox[{"Acttot", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], 
                  RowBox[{
                   RowBox[{"Ntab", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", 
                   RowBox[{"NTrack", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Acttot", "[", 
               RowBox[{"[", "i", "]"}], "]"}], 
              RowBox[{
               RowBox[{"Ntab", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "/", 
               RowBox[{"NTrack", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}]}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[SubscriptBox[\"MP\", \
\"B\"],FontSlant->\"Italic\"]\) [mW]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<OpenMarkers\>\"", ",", "5"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", 
         RowBox[{".7", ",", ".3", ",", ".9"}], "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"20", ",", "500"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".001", ",", "0.1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Alpha]BC"}], ")"}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"B0C", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Acttot", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], 
                 RowBox[{
                  RowBox[{"Ntab", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "/", 
                  RowBox[{"NTrack", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", 
               "\[Alpha]BC"}], " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Ntab", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "-", 
                 RowBox[{
                  RowBox[{"Acttot", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], 
                  RowBox[{
                   RowBox[{"Ntab", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", 
                   RowBox[{"NTrack", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Ntab", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{"Acttot", "[", 
                RowBox[{"[", "i", "]"}], "]"}], 
               RowBox[{
                RowBox[{"Ntab", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "/", 
                RowBox[{"NTrack", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}]}]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<N\>\"", ",", "\"\<B [mW]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Rectangle", "[", "]"}], "}"}], ",", 
         RowBox[{"ImageSize", "->", "5"}]}], "]"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"CMYKColor", "[", 
         RowBox[{"0", ",", "1", ",", "1", ",", ".25"}], "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.1", ",", "1000"}], "}"}], ",", "All"}], "}"}]}]}], "]"}],
     ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "140"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9091512444671884`*^9, 3.909151261000268*^9}, {
   3.9091513428159637`*^9, 3.9091513706324043`*^9}, {3.9091514445338564`*^9, 
   3.9091515418825393`*^9}, {3.9091516490225554`*^9, 
   3.9091516621633806`*^9}, {3.909151696511489*^9, 3.9091517145050135`*^9}, {
   3.9091517548761015`*^9, 3.909151782803926*^9}, {3.9091518190260253`*^9, 
   3.909151820459897*^9}, {3.9091518862187014`*^9, 3.9091518923182383`*^9}, {
   3.9091520508200307`*^9, 3.9091520597580137`*^9}, {3.909152098406737*^9, 
   3.9091522570848846`*^9}, {3.9091524011762257`*^9, 
   3.9091524379702816`*^9}, {3.909152469102252*^9, 3.9091525237714148`*^9}, {
   3.9091526041029625`*^9, 3.9091526337041645`*^9}, {3.9091526782388663`*^9, 
   3.9091526842534943`*^9}, {3.9091527420021095`*^9, 3.90915278921387*^9}, {
   3.9091528311439047`*^9, 3.9091528393945613`*^9}, {3.9096510929227085`*^9, 
   3.9096511933936844`*^9}, 3.90965125145595*^9, {3.909651390092678*^9, 
   3.90965140459062*^9}, {3.9096519575743113`*^9, 3.9096519778618374`*^9}, 
   3.9101837550608826`*^9},
 CellLabel->
  "In[175]:=",ExpressionUUID->"5b24a77e-9a05-422f-bbaa-24e5d29f159b"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.7, 0.3, 0.9], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[{
           {GrayLevel[1], 
            DiskBox[{0, 0}, NCache[
             Offset[{Rational[5, 2], Rational[5, 2]}], Offset[{2.5, 2.5}]]]}, 
           {AbsoluteThickness[1.25], Dashing[{}], 
            CircleBox[{0, 0}, NCache[
             Offset[{Rational[5, 2], Rational[5, 2]}], Offset[{2.5, 2.5}]]]}}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], 
           Hue[0.7, 0.3, 0.9]]}],
        TraditionalForm], {0., 0.}, Automatic, Scaled[8.125]], {{{
      5.44673737166631, -3.7744680332982496`}}, {{
      4.77912349311153, -3.70460034805858}}, {{
      4.74493212836325, -4.101615717992573}}, {{
      4.499809670330265, -3.874567599381118}}, {{
      4.736198448394496, -3.714353392685939}}, {{
      3.6109179126442243`, -3.7410572183445416`}}, {{
      5.0689042022202315`, -3.634367765202149}}, {{
      4.30406509320417, -3.741057218344542}}, {{
      5.278114659230517, -3.8570049382139504`}}, {{
      4.8283137373023015`, -3.763424876012825}}, {{
      5.730099782973574, -3.6234113886169985`}}, {{
      4.6443908991413725`, -3.6608026520969217`}}, {{
      5.634789603169249, -3.5470282187092343`}}, {{
      4.727387818712341, -3.599070378576677}}, {{
      5.860786223465865, -3.6296275092439383`}}, {{
      5.0689042022202315`, -3.5914398008088826`}}}]}, {{}, {}}}, {{}, 
    {CMYKColor[0, 1, 1, 0.25], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[RectangleBox[{0, 0}],
          ImageSize->5],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], 
           CMYKColor[0, 1, 1, 0.25]]}],
        TraditionalForm], {0., 0.}], {{{
      5.44673737166631, -4.789666520503728}}, {{
      4.77912349311153, -5.185472601417725}}, {{
      4.74493212836325, -2.9363484591601687`}}, {{
      4.499809670330265, -4.222594392429911}}, {{
      4.736198448394496, -5.130220815736088}}, {{
      3.6109179126442243`, -4.978941486199335}}, {{
      5.0689042022202315`, -5.583345856807724}}, {{
      4.30406509320417, -4.978941486199335}}, {{
      5.278114659230517, -4.322088286683761}}, {{
      4.8283137373023015`, -4.852226898610819}}, {{
      5.730099782973574, -5.645414615237463}}, {{
      4.6443908991413725`, -5.4335900870934015`}}, {{
      5.634789603169249, -6.07813144312822}}, {{
      4.727387818712341, -5.78330840342436}}, {{
      5.860786223465865, -5.610199789736981}}, {{
      5.0689042022202315`, -5.826536242890056}}}]}, {{}, {}}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.9957322735539975`, -6.907755278982122},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"MP\\\", \
\\\"B\\\"],FontSlant->\\\"Italic\\\"]\\) [mW]\"", HoldForm], TraditionalForm],
      None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"N\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->140,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.995732273553991, 
   6.214608098422191}, {-6.907755278982137, -2.3025850929940455`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.9096511468491287`*^9, 3.909651194760958*^9}, 
   3.909651255796424*^9, {3.909651394825736*^9, 3.909651404958277*^9}, 
   3.9096514475759735`*^9, 3.909652107173334*^9, 3.910087909288645*^9, 
   3.9100922643173213`*^9, 3.9101703044286523`*^9, 3.9101837553105335`*^9, 
   3.9276195439129457`*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"b9ddba81-e6af-4bba-9fcd-b028c1b5c61f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigBcontrib.pdf\>\"", ",", "FigBcontrib"}], "]"}]], "Input",
 CellChangeTimes->{{3.90914063552334*^9, 3.9091406568556795`*^9}, {
  3.909152644483833*^9, 3.909152646100706*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"32143f1f-fbcc-40a6-96be-8bfebdb91132"],

Cell[BoxData["\<\"FigBcontrib.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9091406581459837`*^9, 3.909152646781199*^9, {3.9091527588441095`*^9, 
   3.909152763988462*^9}, 3.9091528583452654`*^9, 3.909216902842025*^9, 
   3.909487649349555*^9, 3.909651448863909*^9, 3.909652109204111*^9, 
   3.9100879095282574`*^9, 3.910092264497608*^9, 3.9101703046226935`*^9, 
   3.9101837566402655`*^9, 3.9276195444463463`*^9},
 CellLabel->
  "Out[176]=",ExpressionUUID->"083e8b62-0405-46da-831d-af5d30303ee7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"B0C", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Acttot", "[", 
              RowBox[{"[", "i", "]"}], "]"}], 
             RowBox[{
              RowBox[{"Ntab", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "/", 
              RowBox[{"NTrack", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], "^", 
           "\[Alpha]BC"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "->", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"B\",FontSlant->\"Italic\"]\) [mW]\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotMarkers", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<OpenMarkers\>\"", ",", "5"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Hue", "[", 
        RowBox[{".7", ",", ".3", ",", ".9"}], "]"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"20", ",", "500"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".01", ",", "5"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"B0C", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Ntab", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{"Acttot", "[", 
               RowBox[{"[", "i", "]"}], "]"}], 
              RowBox[{
               RowBox[{"Ntab", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "/", 
               RowBox[{"NTrack", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Alpha]BC"}], ")"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<N\>\"", ",", "\"\<B [mW]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotMarkers", "->", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Rectangle", "[", "]"}], "}"}], ",", 
        RowBox[{"ImageSize", "->", "5"}]}], "]"}]}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"CMYKColor", "[", 
        RowBox[{"0", ",", "1", ",", "1", ",", ".25"}], "]"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.1", ",", "1000"}], "}"}], ",", "All"}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"AspectRatio", "->", "1"}], ",", 
   RowBox[{"ImageSize", "->", "150"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9091512444671884`*^9, 3.909151261000268*^9}, {
   3.9091513428159637`*^9, 3.9091513706324043`*^9}, {3.9091514445338564`*^9, 
   3.9091515418825393`*^9}, {3.9091516490225554`*^9, 
   3.9091516621633806`*^9}, {3.909151696511489*^9, 3.9091517145050135`*^9}, {
   3.9091517548761015`*^9, 3.909151782803926*^9}, {3.9091518190260253`*^9, 
   3.909151820459897*^9}, {3.9091518862187014`*^9, 3.9091518923182383`*^9}, {
   3.9091520508200307`*^9, 3.9091520597580137`*^9}, {3.909152098406737*^9, 
   3.9091522570848846`*^9}, {3.9091524011762257`*^9, 
   3.9091524379702816`*^9}, {3.909152469102252*^9, 3.9091525237714148`*^9}, {
   3.9091526041029625`*^9, 3.9091526337041645`*^9}, {3.9091526782388663`*^9, 
   3.9091526842534943`*^9}, {3.9091527420021095`*^9, 3.90915278921387*^9}, {
   3.9091528311439047`*^9, 3.9091528393945613`*^9}, 3.9096510414012547`*^9},
 CellLabel->
  "In[177]:=",ExpressionUUID->"2a1c2260-7cf5-4fc2-aeaa-2c665fb2fee3"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.7, 0.3, 0.9], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[{
           {GrayLevel[1], 
            DiskBox[{0, 0}, NCache[
             Offset[{Rational[5, 2], Rational[5, 2]}], Offset[{2.5, 2.5}]]]}, 
           {AbsoluteThickness[1.25], Dashing[{}], 
            CircleBox[{0, 0}, NCache[
             Offset[{Rational[5, 2], Rational[5, 2]}], Offset[{2.5, 2.5}]]]}}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], 
           Hue[0.7, 0.3, 0.9]]}],
        TraditionalForm], {0., 0.}, Automatic, Scaled[8.125]], {{{
      5.44673737166631, 0.8134505170770544}}, {{4.77912349311153, 
      0.07693832331900075}}, {{4.74493212836325, 0.7747175598609671}}, {{
      4.499809670330265, -0.02396630040243431}}, {{
      4.736198448394496, -0.21269888699573292`}}, {{
      3.6109179126442243`, -0.7726903447864303}}, {{5.0689042022202315`, 
      0.5172615455418764}}, {{4.30406509320417, 0.20256078829730517`}}, {{
      5.278114659230517, 1.1105086886678943`}}, {{4.8283137373023015`, 
      0.3735344421512676}}, {{5.730099782973574, 0.6944702466296993}}, {{
      4.6443908991413725`, 0.18796038077451274`}}, {{5.634789603169249, 
      0.505457755527012}}, {{4.727387818712341, 0.08418590104329395}}, {{
      5.860786223465865, 0.8882888022980371}}, {{5.0689042022202315`, 
      0.17102670131349948`}}}]}, {{}, {}}}, {{}, 
    {CMYKColor[0, 1, 1, 0.25], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[RectangleBox[{0, 0}],
          ImageSize->5],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], 
           CMYKColor[0, 1, 1, 0.25]]}],
        TraditionalForm], {0., 0.}], {{{
      5.44673737166631, -2.8497884906269286`}}, {{
      4.77912349311153, -2.90992993008246}}, {{
      4.74493212836325, -3.183773316521625}}, {{
      4.499809670330265, -3.097708864522945}}, {{
      4.736198448394496, -2.97080973202804}}, {{
      3.6109179126442243`, -3.096363243925612}}, {{
      5.0689042022202315`, -2.7619714966707667`}}, {{
      4.30406509320417, -2.924211924171806}}, {{
      5.278114659230517, -2.879888690218007}}, {{
      4.8283137373023015`, -2.9163993142601665`}}, {{
      5.730099782973574, -2.719734242033556}}, {{
      4.6443908991413725`, -2.8465346217065353`}}, {{
      5.634789603169249, -2.676715555067119}}, {{
      4.727387818712341, -2.803120618256899}}, {{
      5.860786223465865, -2.6917375132525923`}}, {{
      5.0689042022202315`, -2.7801609033388384`}}}]}, {{}, {}}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.9957322735539975`, -4.60517018598808},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"B\\\",FontSlant->\\\"Italic\\\"]\\) [mW]\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"N\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.01\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.05\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.10\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.50\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->150,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.995732273553991, 6.214608098422191}, {-4.605170185988091, 
   1.6094379124341003`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.9091513628276577`*^9, 3.9091513709743457`*^9}, {
   3.909151469977398*^9, 3.9091515420994015`*^9}, 3.9091516626032763`*^9, {
   3.909151703805089*^9, 3.9091517149131627`*^9}, 3.909151764870905*^9, 
   3.9091518209081163`*^9, {3.9091518872010636`*^9, 3.9091518928062706`*^9}, 
   3.909152060175072*^9, {3.9091521012522306`*^9, 3.9091521981368713`*^9}, {
   3.9091522328509655`*^9, 3.909152257625202*^9}, {3.9091522877613773`*^9, 
   3.9091523100852623`*^9}, {3.9091524037161274`*^9, 3.909152438232963*^9}, {
   3.9091524955153637`*^9, 3.9091525242076707`*^9}, {3.9091526046158743`*^9, 
   3.9091526345065365`*^9}, 3.90915268454876*^9, {3.9091527436622868`*^9, 
   3.909152790207451*^9}, {3.9091528351807966`*^9, 3.9091528396951475`*^9}, 
   3.9092169023625813`*^9, 3.9094876491344385`*^9, 3.9100879095898204`*^9, 
   3.9100922645317383`*^9, 3.910170304667904*^9, 3.92761954485411*^9},
 CellLabel->
  "Out[177]=",ExpressionUUID->"f4c36842-21b1-4430-a021-dfc45fb88123"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Edges based on proximity and then averaged in time (E ~ N^3/2, with N tracked \
animal, superlinear and less than 2): figure \
\>", "Subsection",
 CellChangeTimes->{{3.9075120331426153`*^9, 3.9075120394840794`*^9}, {
  3.90751380904602*^9, 3.90751380988955*^9}, {3.908297989640889*^9, 
  3.908298010405667*^9}, {3.908298053836505*^9, 3.9082980609705143`*^9}, {
  3.9082996030596685`*^9, 3.908299618603257*^9}, {3.9082996975444283`*^9, 
  3.90829970059264*^9}, {3.9083000740754533`*^9, 3.9083001056681175`*^9}, {
  3.9083001395119324`*^9, 3.9083002193183517`*^9}, {3.9083002961303806`*^9, 
  3.908300298345977*^9}, {3.9083003866064515`*^9, 3.908300418236044*^9}, {
  3.9087213313422832`*^9, 3.9087213316425095`*^9}, {3.9089536134039693`*^9, 
  3.9089536282377434`*^9}},ExpressionUUID->"662986a1-7001-4d45-9eea-\
5755a583c819"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dthr", "=", "6."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Edges", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1", ",", "Ts"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9075120486823177`*^9, 3.9075120624104433`*^9}, {
  3.907512166930231*^9, 3.9075122889769306`*^9}, {3.907513136770433*^9, 
  3.9075131369323225`*^9}, {3.907513452580872*^9, 3.9075134787051945`*^9}, {
  3.9075135924896007`*^9, 3.9075136208179927`*^9}, {3.9075138135294905`*^9, 
  3.9075138279444723`*^9}, {3.907513981462042*^9, 3.90751399396795*^9}, {
  3.9075159520100822`*^9, 3.9075159553790464`*^9}},
 CellLabel->
  "In[178]:=",ExpressionUUID->"f834792f-4dac-4461-9325-caa6c4f33197"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"Ncol", "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"t", "=", "1"}], ",", 
     RowBox[{"t", "<", 
      RowBox[{"Ts", "+", "1"}]}], ",", 
     RowBox[{"t", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Aux", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"n", "=", "1"}], ",", 
        RowBox[{"n", "<", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
        RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"m", "=", 
           RowBox[{"n", "+", "1"}]}], ",", 
          RowBox[{"m", "<", 
           RowBox[{
            RowBox[{"NTrack", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
          RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"dist", "=", 
            RowBox[{"Norm", "[", 
             RowBox[{
              RowBox[{"Tracks", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "n", ",", "t"}], "]"}], "]"}], "-", 
              RowBox[{"Tracks", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "m", ",", "t"}], "]"}], "]"}]}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"dist", "<", "dthr"}], ",", 
             RowBox[{"Aux", "++"}]}], "]"}]}]}], "\[IndentingNewLine]", 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Edges", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "t"}], "]"}], "]"}], "=", "Aux"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.9075120840763884`*^9, 3.9075121241798663`*^9}, {
  3.9075124870945153`*^9, 3.9075125554444275`*^9}, {3.9075125970890446`*^9, 
  3.90751260828236*^9}, {3.907512648053403*^9, 3.9075128630667725`*^9}, {
  3.907512952109296*^9, 3.907512955541356*^9}, {3.9075130014430833`*^9, 
  3.907513007849038*^9}, {3.9075130680554123`*^9, 3.907513082948818*^9}, {
  3.9075138370427446`*^9, 3.9075138375926285`*^9}, {3.907514011432705*^9, 
  3.9075141385144787`*^9}, {3.907514598652588*^9, 3.907514599356658*^9}, {
  3.90751595822768*^9, 3.9075159599845657`*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"d55ee4fb-8ca7-4926-bb77-3a94bf87a99b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Edgesave", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{"Edges", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "//", 
   "N"}]}]], "Input",
 CellChangeTimes->{{3.907512843057182*^9, 3.9075128460164304`*^9}, {
   3.907512943048951*^9, 3.9075129751280746`*^9}, {3.907513091903166*^9, 
   3.907513111778291*^9}, {3.9075131483889217`*^9, 3.9075131620444326`*^9}, {
   3.90751320061703*^9, 3.9075132213579683`*^9}, {3.907514168072343*^9, 
   3.9075141744727554`*^9}, 3.907515967774539*^9},
 CellLabel->
  "In[181]:=",ExpressionUUID->"a9abb431-3cff-4117-8c12-d5bf32057acf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "210.47252747252747`", ",", "138.83516483516485`", ",", 
   "50.16483516483517`", ",", "35.34065934065934`", ",", "76.68131868131869`",
    ",", "24.593406593406595`", ",", "170.06593406593407`", ",", 
   "36.362637362637365`", ",", "175.6813186813187`", ",", 
   "178.1978021978022`", ",", "377.4835164835165`", ",", 
   "144.82417582417582`", ",", "490.83516483516485`", ",", 
   "158.65934065934067`", ",", "539.2747252747253`", ",", 
   "262.35164835164835`"}], "}"}]], "Output",
 CellChangeTimes->{{3.9075128463758965`*^9, 3.907512882812622*^9}, {
   3.9075129286890044`*^9, 3.9075129446728415`*^9}, 3.9075129754308767`*^9, {
   3.9075130884107914`*^9, 3.9075131122018433`*^9}, {3.907513216775799*^9, 
   3.907513221772372*^9}, {3.907513457620887*^9, 3.9075134825237083`*^9}, {
   3.90751359563229*^9, 3.907513624384843*^9}, 3.907514258515906*^9, 
   3.907514730466671*^9, 3.907515978985319*^9, 3.9075176013479595`*^9, 
   3.9075778959305515`*^9, 3.9076869878755684`*^9, 3.9078545532246904`*^9, 
   3.907937015352215*^9, 3.9082983227558928`*^9, 3.90829978538611*^9, 
   3.908557754121912*^9, 3.9087214376321735`*^9, 3.9088201693301115`*^9, 
   3.908878206989915*^9, 3.908916365563558*^9, 3.9089167458057947`*^9, 
   3.909054205156722*^9, 3.9090546927954726`*^9, 3.9091411763352456`*^9, 
   3.909217187949049*^9, 3.9094877376628685`*^9, 3.9100880159530816`*^9, 
   3.9100923573384476`*^9, 3.910170402512142*^9, 3.927619735578642*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"0a2fedfa-5394-4b6f-91d5-ee69f0be78ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lmNtE", "=", 
  RowBox[{"LinearModelFit", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NTrack", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"Edgesave", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], "]"}], ",", "x",
     ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9074962849395475`*^9, 3.9074963020195236`*^9}, {
   3.907513423267853*^9, 3.9075134236984496`*^9}, 3.907873850339946*^9, 
   3.9079132038905706`*^9, {3.9079137305657845`*^9, 3.907913754588001*^9}, {
   3.907914084956211*^9, 3.9079140891266136`*^9}, {3.9079143543535028`*^9, 
   3.9079143546025906`*^9}, 3.907914456061963*^9, {3.9079146961454973`*^9, 
   3.907914704084815*^9}, {3.9079429745569954`*^9, 3.907942975092173*^9}, 
   3.907943009187583*^9, {3.9082983247745867`*^9, 3.908298343807744*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"2da3974c-443c-4ad8-86ce-d3b567e40829"],

Cell[BoxData[
 TagBox[
  RowBox[{"FittedModel", "[", 
   TagBox[
    PanelBox[
     TagBox[
      RowBox[{
       RowBox[{"-", "2.3605984633005095`"}], "+", 
       RowBox[{"1.4714122232075881`", " ", "x"}]}],
      Short[#, 2]& ],
     FrameMargins->5],
    Editable -> False], "]"}],
  InterpretTemplate[
  FittedModel[{
    "Linear", {-2.3605984633005095`, 
     1.4714122232075881`}, {{$CellContext`x}, {1, $CellContext`x}}, {0, 
     0}}, {{1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
    1.}}, {{
      Log[232], 5.349355133785811}, {
      Log[119], 4.933287364941796}, {
      Log[115], 3.915314286512219}, {
      Log[90], 3.565034123782007}, {
      Log[114], 4.339658115229869}, {
      Log[37], 3.2024783823550207`}, {
      Log[159], 5.1361862093035535`}, {
      Log[74], 3.593541801404762}, {
      Log[196], 5.168671664448042}, {
      Log[125], 5.182894181614986}, {
      Log[308], 5.933526902791411}, {
      Log[104], 4.975520426127039}, {
      Log[280], 6.19610835826357}, {
      Log[113], 5.066759392182257}, {
      Log[351], 6.290225135446179}, {
      Log[159], 5.569685773138134}}, {{1., 5.44673737166631}, {1., 
    4.77912349311153}, {1., 4.74493212836325}, {1., 4.499809670330265}, {1., 
    4.736198448394496}, {1., 3.6109179126442243`}, {1., 
    5.0689042022202315`}, {1., 4.30406509320417}, {1., 5.278114659230517}, {
    1., 4.8283137373023015`}, {1., 5.730099782973574}, {1., 
    4.6443908991413725`}, {1., 5.634789603169249}, {1., 4.727387818712341}, {
    1., 5.860786223465865}, {1., 5.0689042022202315`}}, 
    Function[Null, 
     Internal`LocalizedBlock[{$CellContext`x}, #], {HoldAll}]]& ],
  Editable->False,
  SelectWithContents->True,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9074962858950477`*^9, 3.9074963299363155`*^9}, 
   3.907512026765726*^9, 3.9075134242091208`*^9, 3.907513743873456*^9, 
   3.9075777155338397`*^9, 3.907686902046938*^9, 3.9078544593399534`*^9, 
   3.90787286189167*^9, 3.9078738510602846`*^9, 3.907913079301836*^9, 
   3.907913206387114*^9, 3.9079132495991855`*^9, 3.907913397020169*^9, 
   3.907913624705275*^9, 3.9079136712390223`*^9, 3.9079137551756735`*^9, 
   3.907914089994602*^9, 3.907914457755934*^9, 3.9079147048431187`*^9, 
   3.907943011412777*^9, {3.908298335055463*^9, 3.9082983448400106`*^9}, 
   3.9082997854661803`*^9, 3.9085577541952887`*^9, 3.908721437671335*^9, 
   3.9088201693631268`*^9, 3.908878207039003*^9, 3.9089163655952234`*^9, 
   3.90891674582582*^9, 3.9090542052976913`*^9, 3.9090546928895574`*^9, 
   3.909141176361631*^9, 3.9092171879880466`*^9, 3.909487737696559*^9, 
   3.9100880159711466`*^9, 3.910092357342008*^9, 3.910170402517129*^9, 
   3.9276197356099215`*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"55126299-08a8-4dc2-981f-ef5b68226aab"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Aux", "=", 
   RowBox[{"Normal", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ScalingexpNtE", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"Aux", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SCalingconstNtE", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"(", 
     RowBox[{"Aux", "/.", 
      RowBox[{"x", "->", "0"}]}], ")"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907913391190467*^9, 3.9079133949551897`*^9}, {
  3.9079134488574133`*^9, 3.907913529592462*^9}, {3.907913617543748*^9, 
  3.9079136474528036`*^9}, {3.907913758946082*^9, 3.9079137612022448`*^9}, {
  3.9079140927792892`*^9, 3.9079140957022033`*^9}, {3.90791446134632*^9, 
  3.907914462900561*^9}, {3.9079147076068316`*^9, 3.9079147098945436`*^9}, {
  3.907943013439031*^9, 3.907943016763689*^9}, {3.9082983396644115`*^9, 
  3.9082983488595004`*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"b80635a0-e885-474f-b9f1-31b8bd65ffcc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigExpEN", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Edgesave", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"E\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", ".05", "]"}], ",", 
          RowBox[{"Hue", "[", 
           RowBox[{".2", ",", ".7", ",", ".5"}], "]"}]}], "}"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"20", ",", "500"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "1000"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lmNtE", "[", "x", "]"}], ",", 
        RowBox[{"lmNtE", "[", 
         RowBox[{"\"\<MeanPredictionBands\>\"", ",", 
          RowBox[{"ConfidenceLevel", "->", ".95"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"Filling", "->", 
       RowBox[{"{", 
        RowBox[{"2", "->", 
         RowBox[{"{", "1", "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", "Thin"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"AspectRatio", "->", "1"}], ",", 
    RowBox[{"ImageSize", "->", "140"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.908561725889757*^9, 3.9085618482095566`*^9}, {
   3.908606548814151*^9, 3.908606585547086*^9}, {3.908606621136112*^9, 
   3.9086066438813686`*^9}, {3.908606701596376*^9, 3.9086067047713194`*^9}, {
   3.90860674251923*^9, 3.9086067453039455`*^9}, {3.9086067755918436`*^9, 
   3.908606804312431*^9}, {3.908606848100778*^9, 3.9086068491981263`*^9}, {
   3.908607393535187*^9, 3.9086074262609696`*^9}, {3.908607466460007*^9, 
   3.908607549257204*^9}, {3.9086076391927834`*^9, 3.9086077332040863`*^9}, {
   3.9086077655012703`*^9, 3.9086077931736217`*^9}, {3.9086953173740196`*^9, 
   3.9086953972992516`*^9}, 3.908916371560877*^9, {3.908963198882139*^9, 
   3.9089632502989173`*^9}, 3.9089838309601307`*^9, 3.9101704442984705`*^9},
 CellLabel->
  "In[186]:=",ExpressionUUID->"fcfcdd68-7c7c-42f7-a28e-cd8980aeb164"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.2, 0.7, 0.5], PointSize[0.05], AbsoluteThickness[1.6], 
     PointBox[{{5.44673737166631, 5.349355133785811}, {4.77912349311153, 
      4.933287364941796}, {4.74493212836325, 3.915314286512219}, {
      4.499809670330265, 3.565034123782007}, {4.736198448394496, 
      4.339658115229869}, {3.6109179126442243`, 3.2024783823550207`}, {
      5.0689042022202315`, 5.1361862093035535`}, {4.30406509320417, 
      3.593541801404762}, {5.278114659230517, 5.168671664448042}, {
      4.8283137373023015`, 5.182894181614986}, {5.730099782973574, 
      5.933526902791411}, {4.6443908991413725`, 4.975520426127039}, {
      5.634789603169249, 6.19610835826357}, {4.727387818712341, 
      5.066759392182257}, {5.860786223465865, 6.290225135446179}, {
      5.0689042022202315`, 5.569685773138134}}]}, {{}, {}}}, {
    GraphicsComplexBox[CompressedData["
1:eJxF1ns0lekXB3DXEirHLfdzjvPixYsUJV3eXZKSUmTMj1wzVG4Z6UKFIskk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     "], {{{}, {}, {}, {}, {}, {}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{78, 148, 142, 137, 133, 130, 128, 79, 80, 81, 82, 83, 
          84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
           101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
          114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
          149, 143, 138, 134, 131, 129, 150, 144, 139, 135, 132, 151, 145, 
          140, 136, 152, 146, 141, 153, 147, 154, 127, 50, 77, 70, 76, 64, 69,
           75, 59, 63, 68, 74, 55, 58, 62, 67, 73, 52, 54, 57, 61, 66, 72, 49,
           48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32,
           31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15,
           14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 51, 53, 56, 60, 65, 71,
           1}}]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 
          11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
          45, 46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 
          68, 63, 59, 75, 69, 64, 76, 70, 77, 50, 204, 231, 224, 230, 218, 
          223, 229, 213, 217, 222, 228, 209, 212, 216, 221, 227, 206, 208, 
          211, 215, 220, 226, 203, 202, 201, 200, 199, 198, 197, 196, 195, 
          194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 
          181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 
          168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 
          205, 207, 210, 214, 219, 225, 155}}]]}, {}, {}}, {{}, {}, {}, 
       TagBox[
        {GrayLevel[0.3], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[{1, 71, 65, 60, 56, 53, 51, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 
          29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
          46, 47, 48, 49, 72, 66, 61, 57, 54, 52, 73, 67, 62, 58, 55, 74, 68, 
          63, 59, 75, 69, 64, 76, 70, 77, 50}]},
        Annotation[#, "Charting`Private`Tag$41973#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Tiny], Opacity[1.],
          LineBox[{78, 148, 142, 137, 133, 130, 128, 79, 80, 81, 82, 83, 84, 
          85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
          101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
          114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
          149, 143, 138, 134, 131, 129, 150, 144, 139, 135, 132, 151, 145, 
          140, 136, 152, 146, 141, 153, 147, 154, 127}], 
         LineBox[{155, 225, 219, 214, 210, 207, 205, 156, 157, 158, 159, 160, 
          161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 
          174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
          187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 
          200, 201, 202, 203, 226, 220, 215, 211, 208, 206, 227, 221, 216, 
          212, 209, 228, 222, 217, 213, 229, 223, 218, 230, 224, 231, 204}]},
        Annotation[#, "Charting`Private`Tag$41973#2"]& ]}}], {}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.9957322735539975`, 2.3025850929940512`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"E\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"N\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {{{
       2.995732273553991, 
        FormBox["20", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
        FormBox["200", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.70805020110221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.0106352940962555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->140,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{2.995732273553991, 6.214608098422191}, {2.302585092994046, 
   6.907755278982137}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{{3.908561755058904*^9, 3.908561848815012*^9}, 
   3.9085619891965847`*^9, {3.908562523560464*^9, 3.908562550455783*^9}, {
   3.9086065497571774`*^9, 3.908606585937473*^9}, 3.9086067156145*^9, 
   3.9086067458918576`*^9, {3.9086067771477194`*^9, 3.908606796462225*^9}, {
   3.9086068400823402`*^9, 3.9086068502548504`*^9}, {3.908607394155098*^9, 
   3.9086074269255877`*^9}, {3.9086074725734053`*^9, 
   3.9086075498312087`*^9}, {3.9086076515298853`*^9, 
   3.9086076914761157`*^9}, {3.9086077220618286`*^9, 
   3.9086077338027563`*^9}, {3.9086077816304255`*^9, 3.908607793877743*^9}, {
   3.9086953194167805`*^9, 3.908695333249984*^9}, {3.908695376883313*^9, 
   3.9086953977867403`*^9}, 3.9087214377582507`*^9, 3.9088201694837418`*^9, 
   3.9088782071666226`*^9, {3.908916365669326*^9, 3.9089163732706175`*^9}, 
   3.9089167464592323`*^9, {3.9089632114614315`*^9, 3.9089632221585665`*^9}, 
   3.908963253113632*^9, 3.9089838326949396`*^9, 3.9090542080933313`*^9, 
   3.909054694297613*^9, 3.909141177404446*^9, 3.90921718892472*^9, 
   3.909487738351329*^9, 3.9100880164177523`*^9, 3.9100923577013035`*^9, 
   3.910170402888023*^9, 3.910170444859519*^9, 3.9276197365219975`*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"99487c6b-8196-4c68-b252-f1b2eb7a75a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FigExpEN.pdf\>\"", ",", "FigExpEN"}], "]"}]], "Input",
 CellChangeTimes->{{3.9089632543916073`*^9, 3.9089632771084223`*^9}},
 CellLabel->
  "In[187]:=",ExpressionUUID->"482b4aa7-7d5a-4873-b866-f247f3bbbf3d"],

Cell[BoxData["\<\"FigExpEN.pdf\"\>"], "Output",
 CellChangeTimes->{3.908963277970498*^9, 3.9089838391285925`*^9, 
  3.9090542092569923`*^9, 3.9090546958103905`*^9, 3.9091411779153605`*^9, 
  3.9092171894354963`*^9, 3.9094877386999245`*^9, 3.9100880167372017`*^9, 
  3.9100923578660088`*^9, 3.9101704031453853`*^9, 3.9276197370907145`*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"19616d7d-5e83-4a5e-a338-18c65151c7ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaling exponent\>\"", ",", "ScalingexpNtE"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Intercept\>\"", ",", "SCalingconstNtE"}], "}"}], "}"}], 
     ",", 
     RowBox[{"Transpose", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", 
          RowBox[{"lmNtE", "[", "#", "]"}]}], "}"}], "&"}], "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<ParameterConfidenceIntervals\>\"", ",", 
         "\"\<AdjustedRSquared\>\"", ",", "\"\<AIC\>\"", ",", "\"\<BIC\>\"", 
         ",", "\"\<RSquared\>\""}], "}"}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"Alignment", "->", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9079130734392757`*^9, 3.907913073440441*^9}, {
  3.907913104058184*^9, 3.907913105007386*^9}, {3.9079135789480753`*^9, 
  3.9079136668919992`*^9}, {3.9079137829676533`*^9, 3.9079137873094325`*^9}, {
  3.907914119614028*^9, 3.9079141239962473`*^9}, {3.9079144859044704`*^9, 
  3.90791449130338*^9}, {3.9079147222392983`*^9, 3.9079147275228705`*^9}, {
  3.907943025411437*^9, 3.907943030580187*^9}, {3.908298362411597*^9, 
  3.908298370513174*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"10637eb2-e469-4eef-9789-97f04a26d321"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Scaling exponent\"\>", "1.4714122232075881`"},
    {"\<\"Intercept\"\>", "0.09436373306321522`"},
    {"\<\"ParameterConfidenceIntervals\"\>", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4.3623386256359575`"}], ",", 
         RowBox[{"-", "0.35885830096506144`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.0683729183304762`", ",", "1.8744515280847`"}], "}"}]}], 
      "}"}]},
    {"\<\"AdjustedRSquared\"\>", "0.8008273004124692`"},
    {"\<\"AIC\"\>", "21.577192479322136`"},
    {"\<\"BIC\"\>", "23.89495864604148`"},
    {"\<\"RSquared\"\>", "0.8141054803849712`"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.907913077586193*^9, 3.9079131059054856`*^9}, {
   3.907913592284546*^9, 3.9079136288937016`*^9}, 3.907913673732597*^9, 
   3.907913787764436*^9, 3.9079141251931033`*^9, 3.907914491760281*^9, 
   3.9079147280219812`*^9, 3.907943030979746*^9, 3.908298372079321*^9, {
   3.9082997805391912`*^9, 3.908299787642547*^9}, 3.908557754762559*^9, 
   3.9087214379203653`*^9, 3.9088201694953775`*^9, 3.9088782074840584`*^9, 
   3.9089163658276987`*^9, 3.908916746471294*^9, 3.909054209338771*^9, 
   3.909054695899178*^9, 3.909141177941676*^9, 3.909217189504178*^9, 
   3.909487738754133*^9, 3.910088016756195*^9, 3.9100923578725166`*^9, 
   3.9101704031538973`*^9, 3.9276197371542873`*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"7d0a2909-2caf-476c-93e6-3cccad0b7b0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Beta]edN", "=", "ScalingexpNtE"}]], "Input",
 CellChangeTimes->{{3.9088839682535515`*^9, 3.9088839861827126`*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"1b4ca0c7-ab26-4b05-942c-61db42ee3048"],

Cell[BoxData["1.4714122232075881`"], "Output",
 CellChangeTimes->{3.9088839866464944`*^9, 3.908916365856696*^9, 
  3.908916746489236*^9, 3.90905420936543*^9, 3.909054696000614*^9, 
  3.909141177960165*^9, 3.9092171895445137`*^9, 3.909487738785054*^9, 
  3.9100880167621813`*^9, 3.910092357875509*^9, 3.9101704031578865`*^9, 
  3.9276197371855817`*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"e2c3809a-7916-400b-b724-16bb049f169c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"E0N", "=", "SCalingconstNtE"}]], "Input",
 CellChangeTimes->{{3.9077866662506*^9, 3.907786699873871*^9}, 
   3.907943050670195*^9, {3.908298386532684*^9, 3.908298387570619*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"039ab1f5-3263-4408-963a-310cf6699429"],

Cell[BoxData["0.09436373306321522`"], "Output",
 CellChangeTimes->{{3.907786668241021*^9, 3.9077867040313563`*^9}, 
   3.9078545532627506`*^9, 3.907943051076668*^9, 3.9082983882372494`*^9, 
   3.908557754853114*^9, 3.9087214379556336`*^9, 3.9088201695174465`*^9, 
   3.9088782075372267`*^9, 3.908916365865733*^9, 3.908916746508236*^9, 
   3.9090542093921304`*^9, 3.9090546960365367`*^9, 3.909141177987996*^9, 
   3.9092171895924172`*^9, 3.909487738814687*^9, 3.9100880167830954`*^9, 
   3.9100923578775043`*^9, 3.9101704031614227`*^9, 3.9276197372168427`*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"426f9eac-806b-42c6-9b44-585161b30929"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "=", 
  RowBox[{"2", "SCalingconstNtAr", " ", 
   RowBox[{"(", "E0N", ")"}]}]}]], "Input",
 CellChangeTimes->{{3.909056885591973*^9, 3.909056917364388*^9}, {
  3.9090569642076397`*^9, 3.909057016538867*^9}, {3.909057062568575*^9, 
  3.909057072416297*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"09e273d5-7473-4cde-92a0-f42d1f27ef25"],

Cell[BoxData["576.3004078114027`"], "Output",
 CellChangeTimes->{
  3.9090569013031363`*^9, {3.9090569646869273`*^9, 3.9090569868041754`*^9}, 
   3.9090570168990517`*^9, {3.909057062827409*^9, 3.9090570727333164`*^9}, 
   3.9091411780156865`*^9, 3.9092171896488004`*^9, 3.90948773884976*^9, 
   3.9100880167876043`*^9, 3.9100923578794975`*^9, 3.9101704031644044`*^9, 
   3.9276197372168427`*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"ea857412-2e8b-4faa-a0fb-21177ea6fe62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"dthr", "^", "2"}]}]], "Input",
 CellChangeTimes->{{3.909054878022052*^9, 3.9090549063298063`*^9}, {
   3.909055225490374*^9, 3.909055238328508*^9}, 3.909056467964778*^9, {
   3.9090566678890495`*^9, 3.909056668948397*^9}, {3.909056928069459*^9, 
   3.909056931103948*^9}},
 CellLabel->
  "In[192]:=",ExpressionUUID->"57e5f1b7-5cd4-409e-8b9f-ca6dbd342349"],

Cell[BoxData["113.09733552923255`"], "Output",
 CellChangeTimes->{{3.9090548803181076`*^9, 3.909054906731991*^9}, {
   3.9090552259513607`*^9, 3.909055239678584*^9}, 3.909056468580916*^9, 
   3.909056669268459*^9, 3.909056931448511*^9, 3.909141178045271*^9, 
   3.909217189703067*^9, 3.9094877388777227`*^9, 3.9100880167915926`*^9, 
   3.91009235788101*^9, 3.910170403166399*^9, 3.9276197372483377`*^9},
 CellLabel->
  "Out[192]=",ExpressionUUID->"f68fce58-9a05-4c05-91fc-ff09c52d9bfc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"2", "dthr", " ", 
   RowBox[{"Mean", "[", "Lengthsave", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9090567189347396`*^9, 3.909056740493684*^9}, {
  3.9090569362416153`*^9, 3.909056938529355*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"4498b333-a24d-421e-aec9-df31257f03c7"],

Cell[BoxData["924.5106782439751`"], "Output",
 CellChangeTimes->{{3.909056734271139*^9, 3.9090567417489843`*^9}, 
   3.909056938944295*^9, 3.9091411780701027`*^9, 3.9092171897650623`*^9, 
   3.9094877389091787`*^9, 3.910088016809614*^9, 3.9100923578830385`*^9, 
   3.910170403169896*^9, 3.927619737263975*^9},
 CellLabel->
  "Out[193]=",ExpressionUUID->"45c151ba-6b4d-4a2e-8a8a-8726f0710f75"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualization of some networks", "Subsection",
 CellChangeTimes->{{3.910092397323126*^9, 
  3.9100924063147*^9}},ExpressionUUID->"5e9c1c39-e231-45b2-bd1f-3b892787c4e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Netave", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "1", ",", 
       RowBox[{"NTrack", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"NTrack", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9100925723142843`*^9, 3.9100925798649416`*^9}, {
  3.910092778906004*^9, 3.910092790826255*^9}},
 CellLabel->
  "In[194]:=",ExpressionUUID->"0d884cbe-f489-4680-9830-552e5628d9ce"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"Ncol", "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"n", "=", "1"}], ",", 
      RowBox[{"n", "<", 
       RowBox[{
        RowBox[{"NTrack", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
      RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"m", "=", 
         RowBox[{"n", "+", "1"}]}], ",", 
        RowBox[{"m", "<", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
        RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Aux", "=", "0"}], ";", "\[IndentingNewLine]", 
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"t", "=", "1"}], ",", 
           RowBox[{"t", "<", 
            RowBox[{"Ts", "+", "1"}]}], ",", 
           RowBox[{"t", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"dist", "=", 
             RowBox[{"Norm", "[", 
              RowBox[{
               RowBox[{"Tracks", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "n", ",", "t"}], "]"}], "]"}], "-", 
               RowBox[{"Tracks", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "m", ",", "t"}], "]"}], "]"}]}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"dist", "<", "dthr"}], ",", 
              RowBox[{"Aux", "++"}]}], "]"}]}]}], "\[IndentingNewLine]", 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Netave", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "m", ",", "n"}], "]"}], "]"}], "=", "Aux"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"n", "=", "1"}], ",", 
      RowBox[{"n", "<", 
       RowBox[{
        RowBox[{"NTrack", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
      RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"m", "=", 
         RowBox[{"n", "+", "1"}]}], ",", 
        RowBox[{"m", "<", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
        RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Netave", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "n", ",", "m"}], "]"}], "]"}], "=", 
         RowBox[{"Netave", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "m", ",", "n"}], "]"}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.9075120840763884`*^9, 3.9075121241798663`*^9}, {
  3.9075124870945153`*^9, 3.9075125554444275`*^9}, {3.9075125970890446`*^9, 
  3.90751260828236*^9}, {3.907512648053403*^9, 3.9075128630667725`*^9}, {
  3.907512952109296*^9, 3.907512955541356*^9}, {3.9075130014430833`*^9, 
  3.907513007849038*^9}, {3.9075130680554123`*^9, 3.907513082948818*^9}, {
  3.9075138370427446`*^9, 3.9075138375926285`*^9}, {3.907514011432705*^9, 
  3.9075141385144787`*^9}, {3.907514598652588*^9, 3.907514599356658*^9}, {
  3.90751595822768*^9, 3.9075159599845657`*^9}, {3.9100927993062305`*^9, 
  3.9100928011816583`*^9}, {3.910092836795329*^9, 3.9100928650974665`*^9}, {
  3.9100929349058137`*^9, 3.9100930324131875`*^9}, {3.9100930667309437`*^9, 
  3.910093109467073*^9}},
 CellLabel->
  "In[195]:=",ExpressionUUID->"69b8e4c1-fa48-4bf4-8026-6b451c0b036e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Thr", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NetaveThr", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "1", ",", 
       RowBox[{"NTrack", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"NTrack", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9100941323782063`*^9, 3.910094141545257*^9}, {
  3.9100942475768633`*^9, 3.9100942525885067`*^9}, {3.91009441326153*^9, 
  3.9100944302362833`*^9}, {3.9100964907820687`*^9, 3.910096514145948*^9}, {
  3.910196190372854*^9, 3.9101961911674323`*^9}, {3.9101962306608973`*^9, 
  3.9101962307983913`*^9}},
 CellLabel->
  "In[196]:=",ExpressionUUID->"210ae2d5-c5d5-4c99-ba56-1b670be6bdf4"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{"Ncol", "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aux", "=", "Thr"}], ";", "\[IndentingNewLine]", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"n", "=", "1"}], ",", 
      RowBox[{"n", "<", 
       RowBox[{
        RowBox[{"NTrack", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
      RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"m", "=", "1"}], ",", 
        RowBox[{"m", "<", 
         RowBox[{
          RowBox[{"NTrack", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], ",", 
        RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Netave", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n", ",", "m"}], "]"}], "]"}], "<", "Aux"}], 
          ",", 
          RowBox[{
           RowBox[{"NetaveThr", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n", ",", "m"}], "]"}], "]"}], "=", "0"}], ",", 
          RowBox[{
           RowBox[{"NetaveThr", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "n", ",", "m"}], "]"}], "]"}], "=", "1"}]}], 
         "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
     "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9100939948895836`*^9, 3.9100939964404016`*^9}, {
  3.910094167881533*^9, 3.9100941902493496`*^9}, {3.9100942386015444`*^9, 
  3.9100942743612895`*^9}, {3.9100943167291927`*^9, 3.910094384461337*^9}, {
  3.910196197987829*^9, 3.9101962031994286`*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"3a350f83-b540-4875-a69f-de6180a7bf99"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NTrack", "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", 
     RowBox[{"2", 
      RowBox[{
       RowBox[{"Edgesave", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "/", 
       RowBox[{"NTrack", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Ncol"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.92761978089038*^9},ExpressionUUID->"49a306dc-c588-42b0-b7e8-dfa584d38ab4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"232", ",", "1.8144183402804093`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"119", ",", "2.33336411487672`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"115", ",", "0.8724319159101769`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "0.7853479853479854`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114", ",", "1.3452862926547138`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "1.3293733293733294`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"159", ",", "2.1391941391941396`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"74", ",", "0.9827739827739829`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"196", ",", "1.792666517156313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125", ",", "2.8511648351648353`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"308", ",", "2.45119166547738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104", ",", "2.785080304311074`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"280", ",", "3.5059654631083204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"113", ",", "2.808129923174171`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"351", ",", "3.072790457405842`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"159", ",", "3.3000207339829983`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.910095426872382*^9, {3.9100964935121803`*^9, 3.910096516527315*^9}, 
   3.9101706913169155`*^9, {3.9101962084801083`*^9, 3.910196232771551*^9}, 
   3.9276199552555895`*^9},
 CellLabel->
  "Out[199]=",ExpressionUUID->"b209a2ed-bbf6-40ca-a1ee-8ec91662f7df"]
}, Open  ]],

Cell[BoxData["74"], "Input",
 CellChangeTimes->{{3.927619805472934*^9, 
  3.9276198077681746`*^9}},ExpressionUUID->"e00348a3-e949-4010-a30e-\
5226fe6d286e"],

Cell[BoxData["104"], "Input",
 CellChangeTimes->{{3.927619822864665*^9, 
  3.9276198240712523`*^9}},ExpressionUUID->"cf208cfd-6ec2-49f6-aae1-\
29447d60afb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigEmblow", "=", 
  RowBox[{"AdjacencyGraph", "[", 
   RowBox[{
    RowBox[{"Netave", "[", 
     RowBox[{"[", "8", "]"}], "]"}], ",", 
    RowBox[{"GraphLayout", "\[Rule]", "\"\<GravityEmbedding\>\""}], ",", 
    RowBox[{"EdgeStyle", "\[Rule]", "Gray"}], ",", 
    RowBox[{"VertexStyle", "\[Rule]", "Black"}], ",", 
    RowBox[{"ImageSize", "->", "150"}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.9101965651500807`*^9, 3.9101966444326296`*^9},
 CellLabel->
  "In[200]:=",ExpressionUUID->"6b1c4550-427f-4f45-af66-70aa9d03f51e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
       38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
       56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
       74}, {Null, SparseArray[
       Automatic, {74, 74}, 0, {
        1, {{0, 2, 3, 6, 24, 24, 32, 39, 40, 44, 51, 53, 65, 81, 88, 90, 92, 
          93, 93, 95, 96, 101, 107, 109, 110, 111, 111, 113, 113, 119, 120, 
          121, 121, 123, 125, 127, 128, 130, 136, 138, 143, 147, 150, 158, 
          163, 167, 168, 170, 171, 174, 177, 179, 181, 182, 184, 184, 185, 
          185, 185, 185, 186, 186, 186, 187, 187, 187, 187, 187, 187, 187, 
          187, 187, 187, 187, 187}, {{7}, {25}, {3}, {16}, {32}, {47}, {10}, {
          11}, {12}, {21}, {22}, {36}, {37}, {47}, {51}, {53}, {54}, {56}, {
          58}, {59}, {60}, {61}, {62}, {66}, {7}, {8}, {22}, {29}, {35}, {
          36}, {46}, {65}, {8}, {12}, {22}, {29}, {35}, {36}, {62}, {35}, {
          13}, {21}, {22}, {34}, {11}, {12}, {13}, {51}, {53}, {54}, {58}, {
          12}, {13}, {29}, {35}, {36}, {37}, {43}, {44}, {45}, {48}, {51}, {
          60}, {61}, {62}, {15}, {16}, {17}, {18}, {21}, {38}, {39}, {40}, {
          41}, {42}, {51}, {53}, {54}, {56}, {58}, {66}, {15}, {16}, {17}, {
          18}, {31}, {32}, {68}, {17}, {18}, {17}, {32}, {32}, {22}, {74}, {
          33}, {35}, {36}, {41}, {62}, {65}, {29}, {34}, {35}, {36}, {45}, {
          65}, {24}, {72}, {72}, {26}, {28}, {46}, {35}, {37}, {43}, {45}, {
          61}, {65}, {31}, {68}, {69}, {70}, {38}, {39}, {36}, {37}, {37}, {
          43}, {45}, {39}, {40}, {41}, {55}, {57}, {64}, {40}, {43}, {41}, {
          43}, {55}, {57}, {64}, {42}, {43}, {63}, {64}, {43}, {63}, {64}, {
          44}, {45}, {48}, {55}, {61}, {62}, {63}, {64}, {45}, {48}, {60}, {
          61}, {62}, {48}, {60}, {61}, {62}, {70}, {66}, {67}, {62}, {50}, {
          59}, {63}, {51}, {59}, {63}, {52}, {53}, {53}, {55}, {54}, {55}, {
          56}, {58}, {62}, {64}}}, {1, 1, 2, 2, 2, 2, 1, 5, 9, 5, 3, 3, 7, 1, 
         1, 2, 1, 3, 2, 3, 4, 3, 4, 2, 1, 1, 2, 1, 4, 6, 1, 1, 1, 5, 1, 2, 2, 
         4, 1, 4, 1, 1, 1, 1, 3, 2, 2, 1, 3, 1, 3, 3, 4, 12, 6, 9, 7, 9, 35, 
         23, 36, 1, 9, 34, 32, 10, 8, 8, 2, 6, 1, 2, 4, 4, 3, 1, 1, 1, 1, 2, 
         1, 3, 2, 2, 4, 1, 3, 3, 51, 21, 14, 6, 3, 1, 8, 1, 8, 2, 3, 3, 9, 10,
          6, 8, 5, 1, 5, 1, 14, 22, 42, 4, 2, 4, 35, 14, 26, 17, 3, 51, 91, 
         17, 2, 3, 1, 30, 4, 45, 19, 1, 54, 7, 4, 9, 8, 2, 19, 2, 2, 16, 6, 5,
          2, 11, 14, 2, 31, 13, 10, 40, 5, 13, 8, 7, 20, 1, 24, 31, 4, 91, 9, 
         16, 76, 5, 3, 87, 3, 1, 33, 37, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
         91, 91, 91, 91, 91, 91, 91, 91}}]}, {EdgeStyle -> {
         GrayLevel[0.5]}, GraphLayout -> "GravityEmbedding", ImageSize -> 150,
        VertexStyle -> {
         GrayLevel[0]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.18466385335553248`, 
          0.9728534744148059}, {0.013324837591314708`, 0.9590217491909848}, {
          0.17100435468061592`, 0.8384895615563193}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.18466385335553248`, 
          0.9728534744148059}, {-0.24081072133692774`, 
          0.938350128841363}, {-0.30667829675631797`, 0.9404511162881559}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.8290308724873388, -0.47502926987607186`}, \
{-0.7005984016943555, -0.40391519114641505`}, {-0.5550268312752085, \
-0.4229159709529937}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.8290308724873388, -0.47502926987607186`}, \
{-0.6834593020681841, -0.49403004968264985`}, {-0.5550268312752085, \
-0.4229159709529937}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.5550268312752085, -0.4229159709529937}, \
{-0.3936647647201011, -0.4289073830712941}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.5550268312752085, -0.4229159709529937}, \
{-0.4287207540391823, -0.5235161120828834}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.5550268312752085, -0.4229159709529937}, \
{-0.4702873233222642, -0.4871276572604766}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.5550268312752085, -0.4229159709529937}, \
{-0.5249430317168713, -0.5248909182228818}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.5550268312752085, -0.4229159709529937}, \
{-0.48808359617551544`, -0.27940448932081297`}, {-0.3490255448364592, \
-0.20364301861396683`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.5550268312752085, -0.4229159709529937}, \
{-0.4159687799361572, -0.34715450024615163`}, {-0.3490255448364592, \
-0.20364301861396683`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3808152167102063, -0.057900245482357414`}, {
          0.37628771381959325`, -0.18844770404565425`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3761664796629737, 0.05013787104904145}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.37256897495570707`, 0.040916536137907904`}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.37553303084887996`, 0.04851417792307446}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.36533747375123204`, 0.022380328420896562`}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.36173996904397043`, 0.013158993509761189`}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.35452675319352855`, 0.25027597859710515`}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.36804128854921464`, 0.2424101445740654}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.38160610731962596`, 0.2345150442104726}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3952056024244591, 0.22659976125944212`}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.359294887262389, 0.24750079245876003`}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.4224400036663521, 0.210748585155544}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.43603949877119685`, 0.20283330220453807`}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.44960431754160823`, 0.19493820184094324`}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.46311885289729526`, 0.18707236781790615`}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.21445981338271747`, 0.16908144992924018`}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.23633953178484585`, 0.17800503061181885`}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.2183123953255682, 0.17065271447531247`}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.28032090855945857`, 0.19594270956024187`}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.30220062696158384`, 0.20486629024282868`}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.06604576459088993, 0.26405835553854207`}, {-0.007554972057710163, 
          0.5798727299868585}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.07364580866667769, 0.2686835686523034}, {-0.007554972057710163, 
          0.5798727299868585}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.23913333555929386`, 0.3693954950457483}, {-0.007554972057710163, 
          0.5798727299868585}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.17607706585435506`, 0.25385345676686927`}, {0.18497102874082172`, 
          0.4961446935965368}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.1824680145244919, 0.25569845057692236`}, {0.18497102874082172`, 
          0.4961446935965368}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3216280350943606, 0.2958723574270979}, {0.18497102874082172`, 
          0.4961446935965368}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.2675572699494811, 0.30095090726235274`}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.29340204617359067`, 0.2973852019718999}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.31936188175279784`, 0.2938036223806884}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.27439157566349814`, 0.3000080041460816}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.371400883800974, 0.28662399957009854`}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.39736071938017903`, 0.2830424199788716}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.42320549560428833`, 0.2794767146884157}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.020437884567426963`, -0.17429489156492156`}, \
{-0.3490255448364592, -0.20364301861396683`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.48096942696304146`, -0.07442370121875375}, {
          0.5509614267221918, -0.2738967293892265}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.42643634638390804`, -0.2060127792821378}, {
          0.36385767676944925`, -0.48242028662729686`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.25015540259343594`, -0.22282638674773375`}, {
          0.36385767676944925`, -0.48242028662729686`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.41316302073473343`, -0.15859314634384086`}, {
          0.38021419779405585`, -0.3910114509609599}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3405388103159914, -0.2182102577700127}, {
          0.20159082976000198`, -0.45344868047248443`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3332169211444352, -0.2166052663047112}, {
          0.20159082976000198`, -0.45344868047248443`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.17378609165190456`, -0.18165730210504213`}, {
          0.20159082976000198`, -0.45344868047248443`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.2486974086970067, -0.18822912660063776`}, {
          0.053632163688175805`, -0.34482555093159606`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.1176688271990644, -0.10301530373352877`}, {
          0.053632163688175805`, -0.34482555093159606`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.5678235862225686, -0.15367000183295362`}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.5602356119803263, -0.1585418238868515}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.39501090026138114`, -0.26462354856119624`}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.41649801028750233`, 0.32580796197752043`}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.46353623049787235`, 0.2876215293514337}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.5107872753886975, 0.24926232200545143`}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.5578254955990508, 0.211075889379345}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3786622148597771, 0.31679897320374895`}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.38495722774124214`, 0.3128245566796592}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.5220282898459506, 0.22628343206859086`}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.30888640684414526`, 0.3446184344933024}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.3666325400271464, 0.32646914680696887`}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.42463994590045756`, 0.30823774257082864`}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.4823860790834566, 0.2900884548844879}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.10365683335468237`, -0.17047449736816922`}, \
{-0.19759694549236073`, -0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3127340722078942, 0.0535811205974297}, {
          0.01148029336085086, -0.0026360696454697952`}, \
{-0.19759694549236073`, -0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.02510540957600116, 0.8591769984114758}, {
          0.17100435468061592`, 0.8384895615563193}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {-0.01572556337495825, 0.9101244212207394}, {
          0.12412959117936762`, 0.954446836225221}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {-0.022258714076061538`, 
          0.7045364514923667}, {-0.007554972057710163, 0.5798727299868585}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {-0.09338396965178837, 
          0.6714730938558992}, {-0.007554972057710163, 0.5798727299868585}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.12613945317858088`, 0.8225294538794442}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.04752414151499581, 0.804517814654986}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.03906936907166357, 0.7732312393729929}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.030576342964901748`, 0.7418031078127889}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.022121570521559032`, 0.7105165325307986}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.08777258718740427, 0.6943315527206929}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.06810387343064779, 0.6751174198789781}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.04834001300353244, 0.6558103393851549}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.02854330406713617, 0.6364711695728021}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {0.008779443640036437, 0.6171640890789656}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {-0.010889270116723103`, 0.5979499562372516}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {-0.2835857172048457, 
          0.6586420242569593}, {-0.5057876068371856, 0.6404572017026267}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.10808771167013953`, 
          0.7961368153614057}, {-0.027039912335899353`, 0.8004323844957816}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.1301733817296565, 0.8894369843655828}, {
          0.12412959117936762`, 0.954446836225221}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.4127328249315008, 0.6660363397247885}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.3754399559589935, 0.6386518113999657}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.4061662946425833, 0.6612144705672965}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.3004759326045383, 0.5836049759739522}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.2631830636320412, 0.5562204476491166}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.12051721604687199`, 
          0.6823972467608399}, {-0.007554972057710163, 0.5798727299868585}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.27381256351188177`, 0.8042277816167899}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.2334067517997588, 0.7498930706466613}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.19403469191992143`, 0.7798000798288318}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.15470308646739117`, 0.7775870135518531}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.23428313759233105`, 0.6696138178945517}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.1968093571117343, 0.6680849967356542}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.15916602630970494`, 0.6665492584171901}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.12169224582910836`, 0.6650204372583015}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17100435468061592`, 
          0.8384895615563193}, {0.3633759531165556, 0.7559377740242063}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.12412959117936762`, 0.954446836225221}, {
          0.18966541105717422`, 0.8454868382974742}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.12412959117936762`, 0.954446836225221}, {
          0.1638816948353428, 0.8396192514251435}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.12412959117936762`, 0.954446836225221}, {
          0.1379813200507277, 0.8337251166244386}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.12412959117936762`, 0.954446836225221}, {
          0.11219760382889568`, 0.8278575297521235}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.03924349353723855, 
          0.2112056168456662}, {0.21419316349299466`, 
          0.039704061955986455`}, {
          0.3313733698817143, -0.24298255195937912`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.03924349353723855, 
          0.2112056168456662}, {0.06596728689023731, 0.3022615974612006}, {
          0.20392636813640586`, 0.32036661957464174`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.03924349353723855, 
          0.2112056168456662}, {-0.0786992997686532, 
          0.4002924516381916}, {-0.007554972057710163, 0.5798727299868585}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.03924349353723855, 
          0.2112056168456662}, {0.13802225081109473`, 0.27890872527930843`}, {
          0.3232825190837265, 0.23785402992666116`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.3681438997046614, -0.08132734958533792}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.3710055279582669, -0.08203328064022238}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.4333161906139795, -0.09740461049894572}, {0.4251723764990487, 
          0.009715743961372869}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {0.34650417323521693`,
           0.11881075796272379`}, {0.5049115338829289, 
          0.38376722581757994`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {0.5346950744673046, 
          0.07650876380919866}, {0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.36279829298911265`, -0.2231008762788959}, {
          0.3313733698817143, -0.24298255195937912`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.34486279071220277`, -0.20832937972613366`}, {
          0.3313733698817143, -0.24298255195937912`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.47644192407242836`, -0.20497115978205058`}, {
          0.5509614267221918, -0.2738967293892265}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.4184137664255982, -0.33747799991651445`}, {
          0.36385767676944925`, -0.48242028662729686`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.41416858268176765`, -0.33729850089399716`}, {
          0.36385767676944925`, -0.48242028662729686`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.32173162416344486`, -0.3333899907564383}, {
          0.36385767676944925`, -0.48242028662729686`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.4086355178441204, -0.28914060490713767`}, {
          0.38021419779405585`, -0.3910114509609599}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.2406748287386941, -0.319694347235016}, {
          0.053632163688175805`, -0.34482555093159606`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.2384166157867758, -0.31503496000833775`}, {
          0.053632163688175805`, -0.34482555093159606`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.37628771381959325`, -0.18844770404565425`}, {
          0.18924504876907455`, -0.21357890774223492`}, {
          0.053632163688175805`, -0.34482555093159606`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.4251723764990487, 
          0.009715743961372869}, {0.40353265002960276`, 0.2098538515094368}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.4251723764990487, 
          0.009715743961372869}, {0.4089342329125577, 0.20870235849705843`}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.4251723764990487, 
          0.009715743961372869}, {0.526551260352375, 0.18362911826951894`}, {
          0.5049115338829289, 0.38376722581757994`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.4251723764990487, 
          0.009715743961372869}, {
          0.4198267697834905, -0.13205778273219185`}, {
          0.3313733698817143, -0.24298255195937912`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.4251723764990487, 
          0.009715743961372869}, {0.3921658893222472, -0.1217903485970634}, {
          0.3313733698817143, -0.24298255195937912`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.4251723764990487, 
          0.009715743961372869}, {
          0.3643798570585148, -0.11147645940094539`}, {
          0.3313733698817143, -0.24298255195937912`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.4251723764990487, 
          0.009715743961372869}, {
          0.3367189765972713, -0.10120902526581647`}, {
          0.3313733698817143, -0.24298255195937912`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.36599127246331187`, 0.5219586677095807}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3758643424499837, 0.526977448742056}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3857662868999619, 0.5320109075403107}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.39569133359235587`, 0.5370561099093246}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4056332463301214, 0.5421098858009443}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.415585430388957, 0.5471688829165905}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4255410641250493, 0.5522296336080106}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.43549324818382745`, 0.557288630723776}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4454351609215952, 0.5623424066153851}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4553602076139897, 0.5673876089844025}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.465262152063965, 0.5724210677826591}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4751352220506437, 0.5774398488151241}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.28621340087135255`, 0.4975309659216375}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.30818591808707624`, 0.5189821045671301}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3302647265366162, 0.5405370122969866}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3523802310530227, 0.5621277453449589}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.37445903950254505`, 0.5836826530748346}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.39643155671827907`, 0.6051337917203158}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.32646184654375776`, 0.387344703987349}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.33106146244967133`, 0.4004398863711616}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3356781921066693, 0.413583791886728}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.34030672370991105`, 
          0.42676129773790905`}, {0.18497102874082172`, 0.4961446935965368}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.32808466114503176`, 0.3919648839357423}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3495758389138617, 0.4531506216761986}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3542043705170808, 0.4663281275273879}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3588211001740755, 0.4794720330429542}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.3634207160799878, 0.49256721542677223`}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.41794205063888124`, 
          0.43444215448282697`}, {0.37802869334587497`, 0.5268465013533392}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.42575553543810024`, 0.4413711603930465}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4336038053913308, 0.4483310138116738}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.420008222284038, 0.43627443750490147`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4493364218374487, 0.46228271335927174`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.457184691790712, 0.4692425667778673}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4649981765899242, 0.47617157268808774`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6022466835912746, 0.3652975153013593}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5985176147947423, 0.3585560710115394}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5947746712841904, 0.35178954388831246`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5910221595248598, 0.3450057191983756}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6009310112795088, 0.3629190309994115}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5835073650320419, 0.33142040576314313`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5797548532727235, 0.3246365810731921}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5760119097621922, 0.31787005394995876`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5722828409656365, 0.31112860966014766`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5475377829282325, 0.5445126366958642}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5500838245200509, 0.542855622823938}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5526325822509989, 0.5411968412353135}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.55518391479528, 0.5395363839076094}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5577376759139618, 0.537874346015991}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5602937146028683, 0.5362108258369219}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.562851875270031, 0.5345459246327363}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5654119979429102, 0.532879746516702}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5679739185053196, 0.5312123982988344}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5705374689636014, 0.5295439893127443}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5731024777410244, 0.527874631223889}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5756687699993757, 0.5262044378204932}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5782361679856163, 0.524533524787614}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5808044914020544, 0.5228620094666475}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5833735577967998, 0.5211900106007185}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5859431829725574, 0.5195176480692268}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5885131814096679, 0.5178450426121662}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5513618397813077, 0.5420238653918337}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5936535519905819, 0.5144995884814755}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5962235504275661, 0.5128269830242256}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.598793175603283, 0.5111546204926691}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6013622419980759, 0.5094826216268138}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6039305654144739, 0.5078111063057914}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6064979634007239, 0.506140193272931}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.609064255659051, 0.5044699998694903}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6116292644364897, 0.5028006417806586}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6141928148947675, 0.5011322327945595}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6167547354571781, 0.4994648845766969}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6193148581300628, 0.49779870646066976`}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6218730187972115, 0.49613380525647005`}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6244290574861278, 0.49447028507741597`}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6269828186048091, 0.4928082471857901}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6295341511490948, 0.4911477898580874}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.632082908880034, 0.48948900826945807`}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6346289504718484, 0.4878319943975261}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4627596397477151, 0.5634785043427318}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4679522809079133, 0.5630237707519755}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.47315323791675273`, 0.5625683089199253}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4783618030462932, 0.5621121808242261}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.48357723286909193`, 0.5616554515688295}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.48879875044831433`, 0.5611981891921796}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4940255480607146, 0.5607404644287839}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.49925679043986926`, 0.5602823504251557}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5044916185096681, 0.5598239224129471}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5097291535606142, 0.5593652573430771}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5149685018044369, 0.558906433487137}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.46780466796919196`, 0.563036697615125}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5254490166504704, 0.5579886265365134}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5306883648942836, 0.5575298026804376}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5359258999452291, 0.5570711376105624}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5411607280150295, 0.5566127095983746}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5463919703941822, 0.5561545955947522}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5516187680065843, 0.5556968708313712}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5568402855858038, 0.5552396084547145}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5620557154086036, 0.554782879199312}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5672642805381463, 0.5543267511036126}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5724652375469848, 0.5538712892715624}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5776578787071838, 0.5534165556808106}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6186216793619661, 0.5230477607286174}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6203390522538796, 0.5203589013467144}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.622058207548911, 0.5176672512888042}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6237790554224699, 0.5149729511916004}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6255015030070498, 0.5122761464560452}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6272254544798278, 0.5095769871102281}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6289508111673922, 0.5068756276452209}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.630677471668051, 0.5041722268238885}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6324053319912305, 0.5014669474623401}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6341342857142044, 0.4987599561846981}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6358642241553815, 0.49605142315177586`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6375950365635081, 0.4933415217646845}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6393266103221439, 0.4906304283450386}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6410588311677333, 0.4879183217931669}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6427915834204643, 0.48520538322679785`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6445247502261328, 0.4824917956025331}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6462582138070446, 0.4797777433226724}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6479918557204217, 0.47706341183048195`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6497255571230849, 0.47434898719789015`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6514591990365383, 0.4716346557057557}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.653192662617525, 0.4689206034259369}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6549258294232022, 0.46620701580167656`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6566585816759091, 0.4634940772352973}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6583908025214943, 0.4607819706834215}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6601223762801343, 0.45807087726377954`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6618531886882772, 0.45536097587669955`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6635831271294398, 0.45265244284376727`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6653120808524147, 0.449945451566125}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6670399411755945, 0.44724017220457335`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6687666016762438, 0.44453677138323894`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6704919583638221, 0.4418354119182413}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6722159098365825, 0.43913625257240835`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6739383574211689, 0.4364394478368599}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6756592052947299, 0.4337451477396529}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6773783605897702, 0.43105349768174755`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6790957334816738, 0.4283646382998477}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.6265860735835813, 0.06184273214006617}, {
          0.5509614267221918, -0.2738967293892265}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5668827909769019, 0.45929920919799816`}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5709567846411416, 0.45288637418536715`}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.575045936378327, 0.4464496789929869}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.579145541391391, 0.4399965293975662}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5683201580395162, 0.45703666325786924`}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5873554261701653, 0.42707342717943225`}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5914550311832655, 0.42062027758403037`}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.595544182920462, 0.41418358239166647`}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5996181765846949, 0.4077707473790205}, {
          0.6615894336786612, 0.48330273075943886`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5290469955491746, 0.45029022042421}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5300944082486507, 0.44946756893067125`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5311429703834093, 0.448644014655817}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.532192620139234, 0.4478196061492675}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.533243293495241, 0.44699439369391136`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5342949242933015, 0.4461684292511274}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5353474443219216, 0.4453417663951865}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.536400783414065, 0.4445144602361145}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5374548695593346, 0.4436865673318444}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5385096290299163, 0.44285814558915554`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5395649865200525, 0.4420292541542587}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.54062086529801, 0.44119995329311185`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5416771873701812, 0.4403703042628886}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5427338736557711, 0.43954036917475175`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5437908441708652, 0.43871021084917394`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5448480182203267, 0.43787989266478533`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5459053145966777, 0.4370494784029923}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5469626517836659, 0.4362190320889555}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5480199481604137, 0.4353886178276639}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5490771222099029, 0.4345582996433242}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5501340927249895, 0.43372814131773263`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5511907790105697, 0.43289820622958164`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.552247101082769, 0.43206855719940224`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5533029798607558, 0.4312392563382826}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5543583373508356, 0.4304103649033113}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5554130968214169, 0.42958194316062437`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5564671829666895, 0.42875405025637126`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.55752052205882, 0.4279267440972873}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5585730420874641, 0.42710008124135446`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5596246728855154, 0.4262741167985714}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5606753462415159, 0.4254489043432092}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5617249959973374, 0.4246244958366476}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.562773558132112, 0.42380094156180914`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5638209708315832, 0.4229782900682625}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.45927118753354906`, 0.4781096817137886}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.46135244943659853`, 0.478387801776053}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4634361342468747, 0.47866624561264737`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4655221022968066, 0.47894499455965317`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4676102086498194, 0.4792240292491882}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4697003032837469, 0.4795033296337029}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4717922313125921, 0.4797828750156705}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4738858332469704, 0.480062644082451}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4759809452928219, 0.4803426149462063}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.47807739968734303`, 
          0.48062276518870556`}, {0.47853841371970907`, 0.5811257687803653}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.48017502507063753`, 
          0.48090307191090176`}, {0.47853841371970907`, 0.5811257687803653}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4822736468905398, 0.4811835117875625}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.48437308783817773`, 0.4814640611245508}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4864731683100992, 0.4817446959215245}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4885737068935974, 0.48202539193630367`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.49067452087021757`, 
          0.48230612475169143`}, {0.47853841371970907`, 0.5811257687803653}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4927754267324561, 0.48258686984599247`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.49487624070904146`, 
          0.48286760266162476`}, {0.47853841371970907`, 0.5811257687803653}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.49697677929253503`, 0.4831482986764733}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.4990768597644708, 0.4834289334733366}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.501176300712094, 0.48370948281037696`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5032749225320061, 0.48398992268700386`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5053725479152903, 0.48427022940926395`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5074690023098172, 0.48455037965178}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.509564114355665, 0.48483035051552137`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5116577162900453, 0.485110119582294}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5137496443188836, 0.48538966496424135`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5158397389528141, 0.485668965348732}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5179278453058345, 0.48594800003828814`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5200138133557619, 0.4862267489853059}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5220974981660395, 0.4865051928218881}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5049115338829289, 
          0.38376722581757994`}, {0.5241787600690908, 0.4867833128841757}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.2526397939122053, -0.5456057980060192}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.23447327738365376`, -0.5339034669277206}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.21624467994910793`, -0.5221611451712737}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.19797029961960153`, -0.5103893314319331}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.17966783920503962`, -0.49859942933479473`}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.1613559133204605, -0.4868034298624613}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.14305345290589436`, -0.4750135277653356}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.12477907257639165`, -0.46324171402599096`}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.10655047514184542`, -0.451499392269543}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.08838395861329591, -0.4397970611912419}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.07912372172088504, -0.4847009849559957}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.06571702199552436, -0.4566859018508752}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.052255792540997124`, -0.4285568716203786}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.038760661519643275`, -0.4003569995545266}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.02525402087809037, -0.37213307660599404`}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.01175888985663244, -0.3439332045401908}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {-0.001702339597888431, \
-0.31580417430969265`}, {-0.2673586874840721, -0.529507524201184}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, \
{-0.015109039323244047`, -0.2877890912045679}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.1792072867629508, -0.5085650702041548}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.16100569351421032`, -0.4883389924860358}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.1427300680300516, -0.4680306482472375}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.12440841611556676`, -0.44767115825732734`}, \
{-0.10089381559003696`, -0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.10607113817621747`, -0.42729430422744746`}, \
{-0.10089381559003696`, -0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.0877494862616313, -0.4069348142376289}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.06947386077746295, -0.3866264699988407}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.05127226752872801, -0.36640039228071786`}, \
{-0.10089381559003696`, -0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.32964570704898855`, -0.5338394827194073}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.1573414710132668, -0.47603541541796573`}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {0.17501231031701509`, 
          0.01773455361438527}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {0.21194779227174843`, 
          0.02609050170308073}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {0.24906194824499928`, 
          0.03448687137948414}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {0.2862377897731201, 
          0.04289719623578318}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {0.32335194574637227`, 
          0.05129356591218064}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {0.3602874277011042, 
          0.05964951400087818}, {0.20392636813640586`, 
          0.32036661957464174`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.47504929559685805`, -0.12557750191009148`}, {
          0.659625554707274, -0.10664810730847174`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.4329673878115025, -0.062485608716234445`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5202711242438146, -0.15802297688868588`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5320913347300432, -0.098108851735231}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5476708457173233, -0.14717467545233492`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5633208462858925, -0.19646249775286767`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5789003572731704, -0.24552832146997222`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.44191170289073334`, -0.0064431293898008935`}, {0.6712724017658185,
           0.11830979164009126`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.48145951341891263`, -0.043649183572238834`}, {0.6712724017658185, 
          0.11830979164009126`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5211862582286363, -0.08102357674703103}, {0.6712724017658185, 
          0.11830979164009126`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5607340687568019, -0.11822963092948414`}, {0.6712724017658185, 
          0.11830979164009126`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5296226163684233, -0.01614605745811883}, {0.8238127719950978, 
          0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.5338352535558072, -0.023257250367041946`}, {0.8238127719950978, 
          0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.6255635255083845, -0.17810026390998224`}, {0.8238127719950978, 
          0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.4458045249164302, -0.22550143214823118`}, {
          0.5509614267221918, -0.2738967293892265}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.3835311835257694, -0.35782877326017776`}, {
          0.36385767676944925`, -0.48242028662729686`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.37799811868812216`, -0.30967087727331827`}, {
          0.38021419779405585`, -0.3910114509609599}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.2980520190978239, -0.3676829972341886}, {
          0.20159082976000198`, -0.45344868047248443`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.20924990563130721`, -0.33957602291549255`}, {
          0.053632163688175805`, -0.34482555093159606`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.17575562793858585`, -0.2482320799754818}, {
          0.053632163688175805`, -0.34482555093159606`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.3313733698817143, -0.24298255195937912`}, {
          0.06444458254243028, -0.3141826670913354}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.1351393836158704, -0.705508702803929}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.13486033064348218`, -0.7095986722638766}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.12878407821484866`, -0.798655909859314}, {
          0.009650382643786148, -0.7424203072378823}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.3086554558071964, -0.6446038897538965}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.23227707615138338`, -0.6466479398726328}, {-0.2673586874840721, \
-0.529507524201184}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.2085718907651268, -0.6684679750020618}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.16589576929941147`, -0.7252592409487855}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.05813347047909445, -0.6937423875173108}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.058696985715110554`, -0.7407221596296485}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.05926305057883736, -0.7879144919737036}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.0598265658148776, -0.8348942640860395}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.3326943298879846, -0.8484335203162163}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.38527801440935655`, -0.7028241639430914}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.3827849392534618, -0.7004179068712735}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.3284993538290729, -0.6480227460126303}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.4339522944632189, -0.816269261865546}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.43399867142701554`, -0.811622040040574}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2735738444745075, -0.761744305425359}, \
{-0.43500850886575415`, -0.7104308839016158}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.06378212450546676, \
-0.7053795794360176}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.06306021943311409, \
-0.7046569762255088}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.06233778201698212, \
-0.7039338401564085}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.06161483047529801, \
-0.703210189464554}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.060891383471693435`, -0.702486042831634}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.060167460107661885`, -0.7017614193776037}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05944307991380256, \
-0.7010363386519569}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05871826283984704, \
-0.7003108206237213}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05799302924349229, \
-0.6995848856702763}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05726739987795823, \
-0.6988585545649054}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05654139587833807, \
-0.6981318484631488}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.055815038746735504`, -0.69740478888791}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.055088350336195364`, -0.6966773977133678}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.054361352833442164`, -0.6959496971476917}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.053634068740486034`, -0.6952217097146531}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05290652085512335, \
-0.694493458234076}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05217873225032382, \
-0.6937649658013043}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.05145072625276453, \
-0.6930362557655215}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.050722526420223034`, -0.6923073517073208}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04999415651828194, \
-0.6915782774152324}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04926564049610325, \
-0.6908490568616035}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04853700246160069, \
-0.6901197141776513}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04780826665593872, \
-0.6893902736279723}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04707945742752201, \
-0.688660759584493}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.046350599205486544`, -0.6879311965001056}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.062187325979983596`, -0.7037832386167618}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.044892833740769994`, -0.6864720212632645}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04416397551877633, \
-0.6857424581788363}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04343516629034208, \
-0.6850129441353737}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.042706430484656444`, -0.6842835035857194}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04197779245014919, \
-0.6835541609017718}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.041249276427972284`, -0.6828249403481412}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.04052090652602944, \
-0.6820958660560531}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.03979270669349, \
-0.681366961997851}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.03906470069592492, \
-0.6806382519620755}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.03833691209113541, \
-0.6799097595292944}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.0376093642057576, \
-0.6791815080487312}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.03688208011280069, \
-0.6784535206156933}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.03615508261005065, \
-0.6777258200500159}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.035428394199516114`, -0.6769984288754654}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.03470203706791618, \
-0.6762713693002237}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.033976033068294755`, -0.6755446631984715}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.033250403702759654`, -0.6748183320930988}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {-0.03252517010640383, \
-0.674092397139653}, {-0.10089381559003696`, -0.6319829105254944}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.031800353032449054`, -0.6733668791114203}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.031075972838588827`, -0.6726417983857721}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.030352049474557302`, -0.6719171749317426}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.029628602470953842`, -0.6711930282988213}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.028905650929269593`, -0.6704693776069675}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.028183213513137954`, -0.6697462415378665}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, \
{-0.027461308440782754`, -0.6690236383273592}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08665629578056845, -0.730653991951266}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08625615496182068, -0.733040631035356}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08585531522025533, -0.7354314388431329}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08545384304623996, -0.7378260187929113}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.0850518085489503, -0.74022395271873}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08464928519420074, -0.7426248024338348}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08424634947657941, -0.7450281116864456}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08384308052831303, -0.7474334084925622}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08343955967007606, -0.749840207815027}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08303586991171494, -0.7522480145425496}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08630290125318014, -0.7327618128774236}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.0822283209126786, -0.7570646388733352}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08182463115421473, -0.7594724456008412}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08142111029600815, -0.7618792449233097}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08101784134775528, -0.7642845417294296}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08061490563012338, -0.7666878509820382}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.08021238227537203, -0.7690887006971441}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.0798103477780846, -0.7714866346229616}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.07940887560407808, -0.7738812145727421}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.07900803586250979, -0.7762720223805177}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.009650382643786148, -0.7424203072378823}, {
          0.07860789504375855, -0.7786586614646069}, {
          0.15561380818054138`, -0.7668923461779915}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.16727512244200549`, -0.5533716094493392}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.16985415022228628`, -0.55756107917916}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.17243975065572348`, -0.5617612257739554}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.17503086570832666`, -0.5659703305235377}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.17762635949286065`, -0.5701865482499737}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.1802250308720796, -0.5744079277807228}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.18282562936315183`, -0.5786324377843632}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.18542687371099797`, -0.5828579969422891}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.1880274722020408, -0.5870825069459478}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.19062614358124014`, -0.591303886476707}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.19322163736578252`, -0.5955201042031378}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.19581275241838378`, -0.5997292089527245}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.1983983528518138, -0.603929355547523}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.2009773806321036, -0.6081188252773376}, {-0.10089381559003696`, \
-0.6319829105254944}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.34398124608623726`, -0.5877277983903809}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.3478885439492835, -0.5763953820951696}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.3518147432202472, -0.5650081456581414}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.3557474680277545, -0.5536019830734092}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.3596736672987008, -0.5422147466363778}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.2673586874840721, -0.529507524201184}, \
{-0.3635809651617698, -0.5308823303411769}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.10089381559003696`, -0.6319829105254944}, \
{-0.27759993923425696`, -0.6663390994665268}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.10089381559003696`, -0.6319829105254944}, \
{-0.27698071557624687`, -0.6614392137540118}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.10089381559003696`, -0.6319829105254944}, \
{-0.2634974001196912, -0.5547464155893324}, {-0.4402035237639179, \
-0.5891026045303649}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.17374288365243243`, 
          0.6973327774688813}, {-0.007554972057710163, 0.5798727299868585}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5331929091946074, 
          0.6515940163209036}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5332773984417932, 
          0.6662250901926533}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5333622313362566, 
          0.6809156737507563}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5334472778789889, 
          0.6956432549548041}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5335323969555278, 
          0.7103833969012432}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5336174434982572, 
          0.7251109781052903}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5337022763927199, 
          0.7398015616633894}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.3771438268087728, 
          0.7039161685255855}, {-0.5337867656399298, 
          0.7544326355351434}, {-0.6898358480257527, 0.702110483330459}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.9494424305074785, 
          0.1723169946291181}, {-0.9474442735718696, 
          0.30820934652967036`}, {-0.8709729580198187, 
          0.42056085668392473`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.12529517493563716`, 0.5153248883465635}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.14394270931981445`, 0.5165504741590096}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.16266608973772734`, 0.5177810448569221}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.1814366242388612, 0.5190147146977624}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.2002231676042518, 0.5202494367011888}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.21899370210537794`, 0.5214831065421034}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.2377170825232919, 0.5227136772400116}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.25636461690746815`, 0.5239392630524535}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.16554362060804476`, 
          0.40513862641226756`}, {0.18497102874082172`, 0.4961446935965368}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.22335377626918418`, 0.4113726867589074}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.4708257607101231, 0.29618893657045153`}, {
          0.6712724017658185, 0.11830979164009126`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.46790790914129476`, 0.2894401106517784}, {
          0.6712724017658185, 0.11830979164009126`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.40437300919210317`, 
          0.14248747464428047`}, {0.6712724017658185, 0.11830979164009126`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.2983529615978336, 0.4959036041387056}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.30211851854719896`, 
          0.49193800101499896`}, {0.47853841371970907`, 0.5811257687803653}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.3841118202582816, 0.40558878421630223`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.051261554123461374`, 
          0.5134211098356094}, {0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.06923142422000236, 0.5200083104885781}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.0872681546566731, 0.5266200200819958}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.10535099316948804`, 0.5332486314753352}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.057601598199358756`, 
          0.5157451746314178}, {0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.14156375517671416`, 0.5465231141654336}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.15964659368951142`, 0.553151725558817}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.1776833241261784, 0.5597634351522454}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.20392636813640586`, 
          0.32036661957464174`}, {0.19565319422271793`, 0.566350635805215}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.14200575512530936`, 0.704281794937421}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.14694382821080057`, 0.6917775296947482}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.15189877630094148`, 0.6792305333035965}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.15686616922502464`, 0.6666520239109708}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.1618411949559918, 0.6540541866064421}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.16681879361731466`, 0.6414498340875513}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.17179381934830532`, 0.6288519967830295}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.17676121227237485`, 0.6162734873903976}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.18171616036251328`, 0.6037264909992474}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.18665423344799822`, 0.5912222257565716}, {
          0.3362149606310201, 0.7156312907071349}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.21410558410150457`, 0.46326654419624647`}, {
          0.3232825190837265, 0.23785402992666116`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.1916814355226516, 0.4415754815277219}, {
          0.3232825190837265, 0.23785402992666116`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.16914881096009687`, 0.4197794891512946}, {
          0.3232825190837265, 0.23785402992666116`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.14657873606592334`, 0.39794727076222175`}, {
          0.3232825190837265, 0.23785402992666116`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.1240461115033672, 0.3761512783857955}, {
          0.3232825190837265, 0.23785402992666116`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.10162196292451187`, 0.3544602157172731}, {
          0.3232825190837265, 0.23785402992666116`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.062227883533348634`, 0.6798540931494786}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.06873294924552911, 0.6711843221861671}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.07526447333141474, 0.662479288237013}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.08181244679893664, 0.6537523310087108}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.0883660048500361, 0.6450179308025102}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.09491397831757631, 0.6362909735742238}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.10144550240346757`, 0.6275859396250736}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.10795056811563927`, 0.6189161686617556}, {
          0.17773342370669987`, 0.7188975318243771}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.10247632920575404`, 0.5696678312151865}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.0956095921994102, 0.5538783122993929}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.10126723380010402`, 0.5668876119114774}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.08180646448369534, 0.5221391112840026}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.07493972747735447, 0.5063495923682106}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.24098724062426422`, 0.7379594255908601}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {-0.01180573727882721, 0.6779503146385264}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.002918144961151902, 0.6738051331389613}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {-0.009213155335866752, 0.6772204308666435}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.03251526319091155, 0.6654727229140774}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.007554972057710163, 
          0.5798727299868585}, {0.047239145430890986`, 0.6613275414145149}, {
          0.042988380209774135`, 0.7594051260661834}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9376090823148779, -0.18780889836009867`}, {-0.9372876768438552, \
-0.2617812247557181}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.8959358277380379, -0.16911462031021596`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.8991185653307402, -0.17222854810477836`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9023094141312504, -0.17535041174535057`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9055070684364815, -0.17847893375773421`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9087101264658564, -0.18161274266747499`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9119171059148178, -0.18475038821690867`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9151264635821673, -0.18789036056834169`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9183366182912011, -0.1910311127299222}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9215459759585838, -0.19417108508131734`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9247529554075907, -0.19730873063071533`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9279560134369557, -0.2004425395404572}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9311536677421826, -0.20357106155284288`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9343445165426864, -0.20669292519342006`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9785961234304765, -0.12622910594046566`}, \
{-0.9375272541353861, -0.2098068529879901}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8975718961449615, -0.24368347153951403`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8974303675982034, -0.24496689848630032`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8972886025612817, -0.24625247000251999`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8971466222813103, -0.24753999341299882`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8970044491179378, -0.24882926595309832`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8968621064693969, -0.2501200754396169}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8967196186803417, -0.25141220110756535`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8965770109317799, -0.2527054146076651}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8964343091144656, -0.2539994811536139}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8962915396879756, -0.2552941608020386}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8961487295271974, -0.25658920984265304`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.896005905760041, -0.25788438227084887`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.895863095598919, -0.2591794313114238}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8957203261723101, -0.26047411095984313`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.895577624355068, -0.2617681775057867}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8954350166064594, -0.2630613910058919}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8952925288174396, -0.2643535166738449}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8951501861688905, -0.26564432616035805`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8950080130054806, -0.2669335987004601}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8948660327255248, -0.26822112211094434`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8947242676886192, -0.26950669362715834`}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.9372876768438552, -0.2617812247557181}, \
{-0.8945827391418258, -0.2707901205739409}, {-0.8548669584429502, \
-0.25269236735773637`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.35246794236455825`, 
          0.8800188533971299}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3531207847931947, 
          0.8809636619771314}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.35377420987873426`, 
          0.8819093137915942}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3544281929231694, 
          0.882855773097052}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.355082708503397, 
          0.8838030031005262}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3557377304876111, 
          0.8847509659835027}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.35639323205461676`, 
          0.8856996229297608}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.35704918571631106`, 
          0.8866489341577618}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.35770556334282577`, 
          0.8875988589575105}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3583623361911704, 
          0.8885493557312782}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3590194749361919, 
          0.8895003820392197}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3596769497050146, 
          0.8904518946485764}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3603347301139761, 
          0.8914038495873472}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3609927853082643, 
          0.8923562022015594}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3616510840038157, 
          0.8933089072166457}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3623095945324204, 
          0.8942619188013844}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3629682848880505, 
          0.8952151906357205}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3636271227752853, 
          0.8961686759812401}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.36428607565974214`, 
          0.8971223277535945}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3649451108199614, 
          0.898076098597225}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.36560419539987776`, 
          0.8990299409617719}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3662632964610948, 
          0.8999838071803186}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.366922381041331, 
          0.9009376495446342}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3675814162015672, 
          0.9018914203882675}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.36824036908610985`, 
          0.9028450721605616}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.36889920697320155`, 
          0.9037985575061634}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3695578973288888, 
          0.9047518293404639}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3702164078575266, 
          0.9057048409251881}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37087470655305327`, 
          0.9066575459402794}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37153276174725475`, 
          0.9076098985545663}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3721905421562751, 
          0.9085618534932765}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3728480169251096, 
          0.9095133661026332}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37350515567015224`, 
          0.910464392410553}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37416192851846525`, 
          0.9114148891843454}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37481830614501066`, 
          0.9123648139840761}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37547425980668836`, 
          0.9133141252121062}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37612976137373233`, 
          0.9142627821583237}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3767847833579311, 
          0.9152107450412984}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3774392989381365, 
          0.9161579750448181}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37809328198259434`, 
          0.9171044343502482}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.37874670706811225`, 
          0.9180500861647227}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.30667829675631797`, 
          0.9404511162881559}, {-0.3793995494967521, 
          0.9189948947447306}, {-0.4251891951049984, 0.8585626318536903}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.6322554508447418, 
          0.41079620040130216`}, {-0.6655862121214551, 
          0.2968220167792939}, {-0.7600611233307917, 0.22488075371297578`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.6322554508447418, 
          0.41079620040130216`}, {-0.6859369031619653, 
          0.3108118912104674}, {-0.7600611233307917, 0.22488075371297578`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.6322554508447418, 
          0.41079620040130216`}, {-0.7063796710135729, 
          0.3248650629038063}, {-0.7600611233307917, 0.22488075371297578`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.6322554508447418, 
          0.41079620040130216`}, {-0.7267303620540826, 
          0.33885493733497407`}, {-0.7600611233307917, 
          0.22488075371297578`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.6322554508447418, 
          0.41079620040130216`}, {-0.6067871554937727, 
          0.5464231678152087}, {-0.5057876068371856, 0.6404572017026267}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.6322554508447418, 
          0.41079620040130216`}, {-0.5312559021881548, 
          0.5048302342887131}, {-0.5057876068371856, 0.6404572017026267}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.25643708903906043`, 0.6912035889191921}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.2567946185774706, 0.7085513072019953}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.25715376576021826`, 0.7259775153295164}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.2575112952986688, 0.7433252336123206}, {0.17773342370669987`, 
          0.7188975318243771}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3881657388065912, 0.6281147774803875}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.38635065025304527`, 0.6277127555384134}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3845336253473784, 0.6273103047159456}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3827147648416005, 0.6269074473284949}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.38089417299035117`, 0.6265042064672177}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3790719574454201, 0.626100605975848}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.37724822912926426`, 0.6256966704224894}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.37542310208729096`, 0.6252924250668905}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.37359669331891804`, 0.6248878958231376}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3717691225878583, 0.6244831092175682}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3699405122122019, 0.6240780923422671}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3681109868351929, 0.6236728728043222}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.36628067317801444`, 0.6232674786711094}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.36444969977603614`, 0.622861938411758}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.36261819670026363`, 0.622456280835564}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.36078629526615336`, 0.6220505350273562}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.35895412773181995`, 0.6216447302809479}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.38543954539151687`, 0.6275109559374653}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3552895262450753, 0.6208330617795155}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.35345735871073697`, 0.6204272570331552}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3516254572766257, 0.6200215112249361}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.34979395420086373`, 0.6196158536486871}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3479629807988839, 0.6192103133893591}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3461326671417107, 0.6188049192561326}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3443031417646977, 0.6183996997181959}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.34247453138903494`, 0.6179946828429067}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3406469606579775, 0.6175898962373286}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.338820551889606, 0.6171853669935835}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.336995424847631, 0.6167811216379839}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3351716965314776, 0.6163771860846075}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.33334948098654293`, 0.6159735855932583}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3315288891352949, 0.6155703447319889}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3297100286295197, 0.6151674873445238}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.3278930037238482, 0.6147650365220683}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.32607791517030027`, 0.6143630145800932}, {0.37802869334587497`, 
          0.5268465013533392}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.5724703717589893, 0.558970138298914}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.5618253028574318, 0.5505792875067853}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.5511531049942802, 0.5421670526286602}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.5404581452588322, 0.5337368759714843}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.5297451120836643, 0.5252924531372662}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.5190189632241253, 0.5168376920186075}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.508284860112081, 0.508376661053737}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.49754809119293064`, 0.499913528797323}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4868139880808772, 0.49145249783246314`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.47608783922136216`, 0.48299773671377205`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.465374806046177, 0.47455331387957894`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4546798463107227, 0.46612313722241144`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.44400764844757873`, 0.4577109023442754}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43336257954602336`, 0.4493200515521468}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.432983327915416, 0.7571511273402858}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4332121543992959, 0.7545447231509378}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43344130662324837`, 0.7519346086815788}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4336707606574277, 0.749321056500692}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43390049148578236`, 0.7467043515487914}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4341304730597302, 0.744084790527426}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43436067836418774`, 0.7414626811464904}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43459107949597797`, 0.7388383412314332}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43482164775426857`, 0.7362120976949342}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4350523537416277, 0.7335842853814579}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43528316747594403`, 0.7309552457968025}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43551405851059605`, 0.7283253257378475}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43574499606165634`, 0.7256948758411856}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4359759491413418, 0.7230642490719053}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43620688669239915`, 0.7204337991752482}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4364377777270773, 0.7178038791162951}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43666859146138254`, 0.7151748395316367}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4368992974487055, 0.7125470272181648}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4371298657069866, 0.7099207836816621}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4373602668387764, 0.7072964437666035}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4375904721432655, 0.7046743343856732}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4378204537172006, 0.7020547733643023}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4380501845455626, 0.6994380684124049}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4382796385797453, 0.6968245162315152}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4385087908036846, 0.6942144017621543}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43873761728755567`, 0.6916079975728078}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.49927068371689093`, 0.6439628434217756}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.49464785374948855`, 0.6388164321135253}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.49001517019531476`, 0.6336590512020129}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4853738577318783, 0.6284920640717826}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4807252197646732, 0.6233169217517517}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4760706298765044, 0.6181351533967208}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.47141152103090594`, 0.6129483542675045}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.46674937274177647`, 0.6077581714476874}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.49600519746926086`, 0.6403275084710429}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.45742202038700824`, 0.5973744039344199}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4527598720979293, 0.5921842211145522}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4481007632523281, 0.5869974219853344}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.44344617336417436`, 0.5818156536302984}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.43879753539696487`, 0.5766405113102708}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4341562229335457, 0.571473524180023}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.4295235393793554, 0.5663161432685215}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.42490070941196145`, 0.5611697319602669}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.18240346822688128`, 0.6892998104082396}, {0.042988380209774135`, 
          0.7594051260661834}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.18303559511653983`, 0.6935342213234723}, {0.042988380209774135`, 
          0.7594051260661834}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3362149606310201, 0.7156312907071349}, {
          0.19679987261390713`, 0.7857366063650792}, {0.042988380209774135`, 
          0.7594051260661834}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5298682581485321, -0.7339299904644836}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5313006342747467, -0.7357097049630241}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5327340666568969, -0.737490731850099}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5341685191470809, -0.7392730262122723}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5356039547136526, -0.7410565420380317}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5370403354561607, -0.7428412322364193}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5384776226227417, -0.7446270486586145}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5399157766299088, -0.7464139421224569}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5413547570847135, -0.7482018624400909}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5427945228094487, -0.7499907584485294}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5442350318685991, -0.751780578043407}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5456762415986117, -0.7535712682154598}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5471181086394639, -0.7553627750903706}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5485605889691293, -0.7571550439711343}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5500036379399822, -0.7589480193835212}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5514472103175444, -0.7607416451240516}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5528912603213028, -0.7625358643107796}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5543357416673798, -0.7643306194364881}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5557806076133129, -0.7661258524240726}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.557225811004377, -0.7679215046842263}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5586713043215462, -0.7697175171749994}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5601170397308398, -0.7715138304630942}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.561562969133934, -0.773310384786683}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5630090442197353, -0.7751071201195715}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.564455216516668, -0.7769039762364701}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5330325957068953, -0.7378616515190369}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.56734765837504, -0.780497809321295}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5687938306720726, -0.7822946654381008}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5702399057578497, -0.7840914007710043}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5716858351609271, -0.7858879550946087}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5731315705702204, -0.7876842683827042}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5745770638874105, -0.7894802808734592}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5760222672784666, -0.7912759331336187}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5774671332244037, -0.7930711661212003}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5789116145704504, -0.7948659212469334}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5803556645742073, -0.7966601404336685}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5817992369517769, -0.7984537661741962}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5832422859226529, -0.8002467415865553}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5846847662523188, -0.8020390104673235}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5861266332931717, -0.8038305173422351}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5875678430231597, -0.8056212075143034}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5890083520823259, -0.8074110271091722}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5904481178070514, -0.8091999231176105}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.591887098261856, -0.8109878434352489}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5933252522690203, -0.8127747368990904}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5947625394356107, -0.8145605533212782}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.596198920178115, -0.816345243519671}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5976343557446867, -0.8181287593454281}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.5990688082348717, -0.8199110537076035}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.6005022406170157, -0.8216920805946829}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.7020322416452682, -0.6691380869822283}, \
{-0.60193461674323, -0.8234717950932284}, {-0.429770633246497, \
-0.8882636985754768}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5328556323919648, -0.8538438417873356}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.532407908930087, -0.8532424988096345}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5319599992670376, -0.8526409057427803}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.531511906833228, -0.8520390671942566}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5310636351071106, -0.8514369878360172}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5306151876147689, -0.8508346724039465}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5301665679294657, -0.8502321256974033}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5297177796713113, -0.8496293525785142}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5292688265066711, -0.8490263579716082}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5288197121476014, -0.8484231468625079}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5283704403514806, -0.8478197242976947}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5279210149201873, -0.8472160953836069}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.527471439699627, -0.846612265285646}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5270217185788681, -0.8460082392273955}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5265718554896718, -0.8454040224894682}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5261218544054336, -0.8447996204087053}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.525671719340556, -0.8441950383769032}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5252214543495974, -0.8435902818397324}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5247710635263236, -0.8429853562955719}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5243205510027975, -0.8423802672942784}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5238699209483879, -0.8417750204358451}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5234191775689098, -0.841169621369019}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5229683251053359, -0.8405640757900461}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5225173678329526, -0.8399583894410464}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5220663100600982, -0.839352568108617}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5216151561270829, -0.8387466176222541}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5211639104049541, -0.8381405438527728}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.520712577294278, -0.8375343527106373}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5202611612239162, -0.8369280501443329}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5198096666497594, -0.8363216421385086}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5193580980532102, -0.8357151347124526}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5189064599402382, -0.8351085339179178}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5184547568395691, -0.8345018458376365}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5180029933015428, -0.8338950765832132}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5175511738967284, -0.8332882322931868}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5170993032140497, -0.8326813191314001}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5166473858598509, -0.8320743432846022}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5161954264562679, -0.831467310960558}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.515743429639311, -0.8308602283862826}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5152914000578672, -0.8302531018056274}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5148393423719825, -0.8296459374773018}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5143872612508318, -0.8290387416731188}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5139351613720028, -0.8284315206752998}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5134830474193958, -0.8278242807746777}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5130309240815853, -0.8272170282686028}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.531074974785528, -0.8514522182998345}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5121266680195795, -0.8260025106485159}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5116745446814107, -0.8253952581427141}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5112224307287421, -0.8247880182421341}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5107703308501106, -0.8241807972441667}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5103182497289942, -0.8235736014399694}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5098661920429316, -0.82296643711177}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5094141624616935, -0.8223593105309567}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5089621656446354, -0.8217522279567581}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5085102062410926, -0.8211451956326942}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5080582888869142, -0.8205382197858759}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5076064182042521, -0.8199313066240735}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5071545987994129, -0.8193244623340714}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5067028352613727, -0.8187176930796634}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.506251132160764, -0.8181110049993274}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5057994940477012, -0.8175044042048574}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5053479254512128, -0.8168978967787549}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5048964308770467, -0.8162914887729421}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5044450148066387, -0.8156851862066625}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5039936816959937, -0.8150789950645184}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5035424359738626, -0.8144729212950343}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5030912820408328, -0.8138669708086861}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5026402242680174, -0.8132611494762336}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.502189266995624, -0.8126554631272366}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5017384145320412, -0.8120499175482662}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5012876711525607, -0.8114445184814478}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5008370410981701, -0.8108392716229984}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.5003865285746256, -0.8102341826217084}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4999361377513158, -0.8096292570775822}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4994858727603946, -0.8090245005403737}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49903573769551346`, -0.8084199185085732}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4985857366112758, -0.8078155164278082}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49813587352206756`, -0.8072112996898996}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4976861524013518, -0.8066072736316254}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4972365771807706, -0.8060034435336622}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4967871517494905, -0.8053998146195785}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4963378799533483, -0.8047963920547793}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4958887655942806, -0.8041931809456797}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4954398124296194, -0.80359018633879}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49499102417145063`, -0.8029874132199055}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49454240448618575`, -0.8023848665133296}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49409395699384784`, -0.8017825510812644}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49364568526773744`, -0.8011804717230125}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.4931975928339305, -0.8005786331744985}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49274968317086437`, -0.7999770401076437}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.429770633246497, -0.8882636985754768}, \
{-0.49230195970898644`, -0.7993756971299386}, {-0.5953869588544571, \
-0.7649558403418042}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.8864304236946833, 
          0.3574770283146199}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.888570381486245, 
          0.358812822189802}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.89071490060929, 
          0.36015146331676373`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.8928634141473508, 
          0.3614925978177742}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.8950153187400441, 
          0.36283584906610805`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.8971699785410632, 
          0.3641808201569793}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.8993267302161886, 
          0.36552709702707414`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9014848888823784, 
          0.3668742521623379}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.8879420524563261, 
          0.35842060974846673`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9058026207666627, 
          0.36956944541749176`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9079607794329226, 
          0.37091660055263825`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9101175311080432, 
          0.37226287742277786`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9122721909090321, 
          0.3736078485136521}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.914424095501744, 
          0.3749510997619866}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9165726090398099, 
          0.3762922342629575}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9187171281628452, 
          0.37763087538994466`}, {-0.9363145516292586, 
          0.31588284089584073`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.9208570859543842, 
          0.3789666692651463}, {-0.9363145516292586, 0.31588284089584073`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.850652395380824, 
          0.5083403847261422}, {-0.7821960843307232, 0.5669228418843191}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.8709729580198187, 
          0.42056085668392473`}, {-0.802516646969714, 
          0.47914331384211406`}, {-0.7821960843307232, 0.5669228418843191}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3232825190837265, 
          0.23785402992666116`}, {0.5481042257486244, 0.12091146139686883`}, {
          0.659625554707274, -0.10664810730847174`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3232825190837265, 
          0.23785402992666116`}, {0.5431293574807702, 0.11605441665262684`}, {
          0.659625554707274, -0.10664810730847174`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3232825190837265, 
          0.23785402992666116`}, {0.4348038480423733, 0.01029446122132232}, {
          0.659625554707274, -0.10664810730847174`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.3232825190837265, 
          0.23785402992666116`}, {0.5048808401644956, 0.17495139160404188`}, {
          0.6218651421736041, 0.022473966354459307`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.21798186937910632`, 0.6087112698900902}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.2154707030099914, 0.6086296779763781}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.21295642405770895`, 0.6085479849297376}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.21043922583489566`, 0.6084661970312153}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.20791930938404066`, 0.6083843208130014}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.20539688317822763`, 0.6083023630487259}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.20287216275700248`, 0.6082203307416367}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.20034537029731278`, 0.6081382311106347}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.19781673412048334`, 0.6080560715742204}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.19528648813752195`, 0.6079738597325628}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.19275487123613916`, 0.6078916033475238}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.19022212661422533`, 0.6078093103209676}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.1876885010656613, 0.60772698867172}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.18515424422542276`, 0.6076446465107828}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.18261960778196568`, 0.607562292015901}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.18008484466555505`, 0.6074799334050259}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.17755020822209736`, 0.6073975789101976}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.1750159513818604, 0.6073152367491865}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.17248232583329773`, 0.6072329150999052}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.1699495812113841, 0.6071506220733879}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.1674179643100018, 0.6070683656883467}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.164887718327039, 0.6069861538466922}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.16235908215021194`, 0.606903994310288}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.15983228969051938`, 0.6068218946792656}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.1573075692692931, 0.606739862372191}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.15478514306348, 0.6066579046079126}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.15226522661262648`, 0.6065760283897027}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.14974802838981102`, 0.6064942404911768}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.14723374943753287`, 0.6064125474445357}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.14472258306841498`, 0.6063309555308297}, {
          0.18497102874082172`, 0.4961446935965368}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.30946207347423704`, 0.6558087203855646}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.2884397686859938, 0.6338839840502579}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.267322348366595, 0.6118600491274456}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.17773342370669987`, 
          0.7188975318243771}, {0.2463000435783422, 0.5899353127921498}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27645123283594714`, 0.5432421440920203}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2766793023599497, 0.5418080080300401}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2769075621038328, 0.5403726758364441}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2771360045982656, 0.5389361944793166}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27736462216841307`, 0.5374986122192829}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2775934069380852, 0.536059978583157}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27782235083460377`, 0.534620344333013}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2780514455945322, 0.5331797614307087}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27828068276998236`, 0.5317382829977415}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27851005373579263`, 0.5302959632705223}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27873954969735387`, 0.5288528575509872}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2789691616991321, 0.5274090221527661}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27919888063400133`, 0.5259645143428965}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2794286972531776, 0.5245193922792811}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27965860217673916`, 0.5230737149440726}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2798885859049255, 0.5216275420732193}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28011863882990334`, 0.5201809340824044}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2803487512480429, 0.5187339519897112}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28057891337256075`, 0.5172866573352705}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28080911534704917`, 0.5158391120984461}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28103934725867236`, 0.5143913786126159}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28126959915194194`, 0.5129435194783001}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.27689458987982796`, 0.540454247165696}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2817301229346324, 0.5100476754715537}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28196037482809155`, 0.5085998163372709}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2821906067395835, 0.5071520828514228}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28242080871411374`, 0.5057045376146015}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2826509708386555, 0.5042572429601649}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28288108325676764`, 0.5028102608674662}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28311113618175043`, 0.5013636528766541}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28334111990996036`, 0.49991748000580344`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2835710248335317, 0.4984718026705978}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2838008414526886, 0.49702668060698113`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2840305603875508, 0.49558217279711}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28426017238934165`, 0.49413833739888874`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2844896683509025, 0.4926952316793539}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28471903931671155`, 0.4912529119521316}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28494827649217436`, 0.4898114335191689}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2851773712520948, 0.48837085061686275`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2854063151486207, 0.4869312163667178}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2856350999182757, 0.4854925827305921}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28586371748843187`, 0.484055000470561}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.28609215998287696`, 0.4826185191134348}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2863204197267452, 0.48118318691983847`}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.18497102874082172`, 
          0.4961446935965368}, {0.2865484892507499, 0.4797490508578569}, {
          0.37802869334587497`, 0.5268465013533392}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.562333326298268, 0.45770186217187087`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5580782496326604, 0.45240382417457775`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5538150016394834, 0.4470956119765737}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5495444631790286, 0.4417783223457462}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5452675670898947, 0.43645311676863185`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5409852936434933, 0.4311212157908768}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5366986648273059, 0.42578389189912325`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5324087375278265, 0.4204424610332672}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5281165957431871, 0.415098272890067}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5589514823413457, 0.45349109484784916`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5195300882766944, 0.40440712760718855`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5152379464920436, 0.3990629394639961}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5109480191925679, 0.39372150859813426`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5066613903763629, 0.38838418470639524`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.5023791169299734, 0.3830522837286299}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.4981022208408407, 0.3777270781515158}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.49383168238038816`, 0.37240978852068735`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.4895684343871975, 0.3671015763226918}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.48531335772159634`, 0.36180353832539447`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.37802869334587497`, 
          0.5268465013533392}, {0.4258251390310289, 0.6536087614635627}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6195124181694718, -0.048296420927985605`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6203086680637429, -0.04806356589681386}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6211054729640089, -0.04783054855989197}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6219028150232786, -0.047597374136384284`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.622700675981323, -0.047364047966306375`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6234990371711258, -0.047130575508635975`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6242978795263163, -0.04689696233913161}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6250971835896079, -0.04666321414787487}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.625896929522245, -0.046429336736517765`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6266970971144424, -0.04619533601517378}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6274976657968828, -0.04596121799915977}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6282986146531696, -0.04572698880522612}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6290999224333331, -0.04549265464774038}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6299015675682763, -0.04525822183433569}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6307035281852132, -0.045023696761498797`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6315057821240178, -0.04478908590970774}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6323083069545109, -0.044554395838468173`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6331110799945573, -0.04431963318089749}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6339140783290482, -0.04408480463830275}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6347172788295918, -0.0438499169743532}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6355206581749443, -0.04361497700909928}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6363241928720907, -0.043379991612785315`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6371278592779485, -0.04314496769965557}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6379316336215014, -0.04290991222124833}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6387354920264958, -0.042674832159997095`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6395394105343631, -0.04243973452222441}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6403433651274297, -0.0422046263310498}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6411473317533076, -0.04196951462248877}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6419512863465218, -0.04173440643180919}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6427552048543907, -0.041499308794044586`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6435590632593668, -0.041264228732727413`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6443628376029268, -0.04102917325434211}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6451665040087855, -0.04079414934121395}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6459700387059412, -0.04055916394493287}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6467734180512887, -0.04032422397966127}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6475766185518264, -0.040089336315697575`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6483796168863214, -0.039854507773116686`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.649182389926372, -0.03961974511555478}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6499849147568596, -0.03938505504429827}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6507871686956659, -0.03915044419251549}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6515891293126017, -0.038915919119677934`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6523907744475442, -0.03868148630626911}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6531920822277106, -0.03844715214878328}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6539930310839979, -0.03821292295486095}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6547935997664358, -0.037978804938837575`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.655593767358635, -0.03774480421750241}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6563935132912695, -0.0375109268061371}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6571928173545618, -0.03727717861488164}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6579916597097525, -0.03704356544537618}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6587900208995559, -0.036810092987707356`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6595878818575986, -0.036576766817627344`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6603852239168697, -0.036343592394119835`}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6611820288171344, -0.03611057505719999}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6619782787114032, -0.03587772002602292}, {0.6218651421736041, 
          0.022473966354459307`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7186363650880113, -0.08391966394698586}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7189636662437554, -0.09047240654856537}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7192924245241074, -0.09705432155741175}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7187229155049892, -0.0856524491650145}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7199514523046726, -0.1102484069968807}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7202802105850236, -0.11683032200573248`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7206075117407559, -0.12338306460731192`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {0.6284567332487012, 
          0.007746058398440757}, {0.6712724017658185, 0.11830979164009126`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {0.6530810922256988, 
          0.00647117032268169}, {0.6712724017658185, 0.11830979164009126`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {0.6778168642473931, 
          0.00519051400894477}, {0.6712724017658185, 0.11830979164009126`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {0.7024412232243914, 
          0.003915625933176559}, {0.6712724017658185, 0.11830979164009126`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7172606176006153, -0.17322550942023468`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7109423230828379, -0.17586555183384806`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7046005201413319, -0.17851541703041546`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6982425053739625, -0.18117205619227347`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7150314269881067, -0.1741569566246186}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6855099205286291, -0.18649225200336433`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6791519057612669, -0.18914889116523081`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.672810102819769, -0.19179875636182211`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.6664918083019866, -0.19443879877542408`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.8319377486559799, -0.1477055402346558}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.8236849067312009, -0.16111654443257217`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.8153984976165602, -0.1745820958674483}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.807091219512632, -0.18808155975395177`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7987768563633885, -0.20159253695591187`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.790469578259527, -0.21509200084245125`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7821831691448838, -0.22855755227732694`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.7739303272200982, -0.24196855647524204`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {0.7719739754580937, 
          0.0720700239554693}, {0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.659625554707274, -0.10664810730847174`}, {
          0.8561224952717722, -0.029503500001990635`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7209890890921439, -0.013149276664538755`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7187519015765637, -0.016015576454059776`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7165104178300346, -0.018887380603749906`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7142651009816336, -0.021764095749516918`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7120164414889797, -0.024645093513710768`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7097649547484406, -0.027529713567038278`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7075111780893703, -0.03041726747951655}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7052556671899466, -0.03330704331244768}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7029989919828306, -0.03619831086429927}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.7192110202875939, -0.015427350453498478`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.6984844723122896, -0.041982344027076665`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.6962277971051678, -0.04487361157892606}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.6939722862057403, -0.04776338741185407}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.6917185095466465, -0.050650941324314955`}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {0.689467022806125, -0.05353556137765741}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.6872183633134762, -0.05641655914185442}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {0.6849730464650665, -0.0592932742876142}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.6827315627185394, -0.06216507843730411}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {
          0.6804943752029581, -0.06503137822682616}, {
          0.7796183221214985, -0.10065462124582458`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {0.6013121541982798, 
          0.16541894683671632`}, {0.6696179906739919, 0.29265889914392407`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6218651421736041, 
          0.022473966354459307`}, {0.6901709786493175, 
          0.14971391866166764`}, {0.6696179906739919, 0.29265889914392407`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.6894386902821863, -0.00898889890039689}, {0.6712724017658185, 
          0.11830979164009126`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7614520336051306, 
          0.026644069294663758`}, {0.6712724017658185, 
          0.11830979164009126`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.6599413872276321, 
          0.07791360225543514}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.6685186622322018, 
          0.08031245976860352}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.6771152787591668, 
          0.08271672664038132}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.6857286345849815, 
          0.08512567509142034}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.6943559526069252, 
          0.0875385284328812}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.702994302292414, 
          0.08995446706530345}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7116406267911455, 
          0.09237263606115381}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.720291775036248, 
          0.09479215414298345}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7289445377592115, 
          0.09721212375523546}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7375956860043498, 
          0.0996316418369297}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7462420105030745, 
          0.102049810832798}, {0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7548803601885663, 
          0.10446574946521725`}, {0.6696179906739919, 0.29265889914392407`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7635076782105021, 
          0.10687860280669334`}, {0.6696179906739919, 0.29265889914392407`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7721210340363234, 
          0.10928755125772367`}, {0.6696179906739919, 0.29265889914392407`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7807176505632879, 
          0.11169181812949958`}, {0.6696179906739919, 0.29265889914392407`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.7892949255678571, 
          0.11409067564266662`}, {0.6696179906739919, 0.29265889914392407`}}],
           0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.7782425746341042, -0.1899604667190763}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.7677286118373751, -0.1863222196284697}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.7571637881371597, -0.1826663726530244}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.7465814051796811, -0.17900444947992958`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.7360165814794492, -0.17534860250452977`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.7255026186827224, -0.17171035541392826`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.8929197056894673, -0.1644404975335002}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.8779629925429312, -0.1781057475868509}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.8902861268684926, -0.16684667546652862`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.8478978507473636, -0.2055748630603875}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.8329411376008381, -0.21924011311374883`}, {
          0.9462425211688066, -0.2830259894014251}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {0.8329559324915805, 
          0.05533506665662644}, {0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          0.7796183221214985, -0.10065462124582458`}, {
          0.9151333056525098, -0.0067750566405026}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7589833152435151, 0.10860686357177772`}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7567061420971174, 0.1036141503975259}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7544217872631991, 0.09860569133852141}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7521318817885893, 0.09358506247289498}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7498381930611476, 0.08855613880701793}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7579786210377798, 0.10640406665007762`}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7452469806997669, 0.07848988342435263}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7429532919723256, 0.07346095975847744}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7406633864977226, 0.0684403308928472}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7383790316638, 0.06343187183384527}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7361018585174011, 0.05843915865959378}, {
          0.8238127719950978, 0.04873623059128018}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6417750987112657, 0.2052122927959259}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6461629932862384, 0.20525392983988824`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6505620704119762, 0.2052956729958814}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6549705299754331, 0.20533750518247346`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6593864394059457, 0.20537940806141636`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6638077551180709, 0.20542136224092733`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6682323495709432, 0.20546334753270853`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6726580428688668, 0.20550534325143083`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6770826373217421, 0.20554732854308885`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6815039530338647, 0.20558928272262328`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6859198624643789, 0.20563118560154928`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6903283220278351, 0.20567301778814365`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6947273991535715, 0.20571476094413016`}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.6991152937285443, 0.205756397988096}, {
          0.6696179906739919, 0.29265889914392407`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8347920298218415, 0.06674803823615243}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.7722660566950303, -0.02024548555175049}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8147896439752113, 0.18263375719711586`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8151264239946243, 0.17939508899421022`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8154636083691831, 0.17615253228218425`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8158011729212576, 0.17290631956688324`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8161390925345614, 0.16965669238093123`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8164773411885442, 0.16640390095274873`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8168158920001396, 0.1631482038050472}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8171547172729208, 0.15988986728253782`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8174937885534382, 0.1566291650097384}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8178330766946649, 0.1533663772809824}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8181725519261348, 0.150101790386015}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8185121839302707, 0.1468356958757496}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8188519419244359, 0.1435683897740636}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8191917947475724, 0.1403001717425927}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8195317109513617, 0.13703134420664645`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8152359329509258, 0.17834198858953623`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8202116068371222, 0.13049307869540283`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8205515230407632, 0.12722425115943656`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.820891375863971, 0.12395603312797661`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8212311338581135, 0.12068872702628844`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8215707658622909, 0.11742263251602493`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.821910241093743, 0.11415804562106}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8222495292349834, 0.11089525789230344`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8225886005154786, 0.10763455561950284`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8229274257882706, 0.10437621909699378`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8232659765998616, 0.1011205219492928}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8236042252538407, 0.09786773052110721}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8239421448671503, 0.09461810333515429}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8242797094192265, 0.0913718906198565}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.8246168937937896, 0.08812933390783122}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6712724017658185, 
          0.11830979164009126`}, {0.824953673813197, 0.08489066570492522}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7066045554628443, 0.14534165981542724`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7132557403602129, 0.14954618089115113`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7199250454903721, 0.15376215660266687`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7266092383271311, 0.15798754352092942`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7333048375206896, 0.1622201409240211}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7400081601837775, 0.1664576206887614}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7101269810516483, 0.14756834766943622`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7534226024853138, 0.17493750904644018`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7601259251483864, 0.1791749888112047}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7668215243419657, 0.18340758621426387`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7735057171787176, 0.18763297313253716`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7801750223088721, 0.19184894884405812`}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.7868262072062399, 0.1960534699197837}, {0.6696179906739919, 
          0.29265889914392407`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8996214865734273, 0.006877405255653917}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8952368462277779, 0.0028045097870361435`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8908372221374646, -0.0012823040924300343`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8864265479634367, -0.005379382402344801}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8820090964265913, -0.009482756209301087}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8775893603195549, -0.013588252155099855`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8731719087827179, -0.01769162596206414}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8687612346086916, -0.021788704271981447`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8643616105183752, -0.025875518151444177`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8599769701727262, -0.029948413620063615`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8796191007267963, 0.12276312421662298`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8804612470783588, 0.12155069122201738`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8813041818627574, 0.12033712312546986`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8821478697897218, 0.11912247073412147`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8829922744846206, 0.11790678641633347`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8838373585148993, 0.11669012406351956`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8846830834214352, 0.11547253904502924`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.885529409754881, 0.11425408815588638`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8863762971168829, 0.113034829557313}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.88722370420636, 0.11181482271025416`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8880715888705476, 0.11059412830181092`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8889199081607688, 0.10937280816488013`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8897686183928302, 0.10815092519132337`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8906176752116719, 0.10692854323888767`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8914670336600312, 0.10570572703232725`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8923166482506858, 0.1044825420591406}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8931664730423695, 0.10325905446087903`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8940164617180422, 0.10203533091987861`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8948665676658413, 0.10081143854279868`}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8957167440619836, 0.09958744474139654}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8965669439555769, 0.098363417111742}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8974171203518192, 0.09713942331040896}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8982672262996685, 0.09591553093336572}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.8991172149752813, 0.09469180739232289}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.899967039766986, 0.09346831979407698}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9008166543576883, 0.09224513482092285}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9016660128059882, 0.09102231861432293}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9025150696248682, 0.08979993666191215}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.90336377985693, 0.08857805368835875}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9042120991471444, 0.08735673355142565}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9050599838113323, 0.08613603914297532}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9059073909008042, 0.08491603229591395}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9067542782628164, 0.08369677369734857}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9076006045962595, 0.082478322808203}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9084463295027935, 0.08126073778971418}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9092914135330733, 0.08004407543689847}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9101358182279604, 0.07882839111910463}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9109795061549323, 0.07761373872776124}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9118224409393232, 0.07640017063120559}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.8238127719950978, 0.04873623059128018}, {
          0.9126645872909003, 0.07518773763661203}, {0.9684709160225906, 
          0.14921463126194956`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6149090900109474, 0.47187402053844263`}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6440988200304832, 0.4712476747306373}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6200488191757908, 0.47176373353634626`}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7027743701606689, 0.46998862968910843`}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7319641001801999, 0.469362283881297}, {
          0.6772551995171581, 0.6485774052758186}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5301309468304284, 0.4908398881852993}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5421414760117824, 0.49449680025023507`}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5541847262177313, 0.4981636750660031}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5662548602402239, 0.5018387353456748}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5783455915523006, 0.5055200669957184}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5904502696960031, 0.5092056451144991}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.536491647363675, 0.49277656575963763`}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6146737055499447, 0.5165810882354255}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6267783836936582, 0.5202666663541629}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6388691150057404, 0.5239479980041876}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.650939249028231, 0.5276230582838745}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6629824992341788, 0.5312899330996466}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6749930284155315, 0.5349468451645871}, {
          0.5355059845719685, 0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.685992986444681, 0.4504091445711806}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.698859782578248, 0.4446450988925884}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7117789124645492, 0.43885760882752184`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7247305786617179, 0.43305554320065426`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.737693290972981, 0.4272485291541357}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.750644957170159, 0.42144646352729676`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7635640870564653, 0.4156589734622316}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7764308831900245, 0.40989492778362563`}, {
          0.7928058789607131, 0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.78791917808046, 0.024784830169415}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7576832689203383, 
          0.021808128562694675`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7273127513512134, 0.01881817486339403}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.779923695939325, 0.02399768120657162}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6664321105181071, 
          0.012824523393344714`}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6360615929489799, 0.009834569694045421}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6058256837888581, 0.006857868087325382}, {
          0.7241268711953266, -0.26101620088718125`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5964183026318899, 0.37765160426679}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5998064185546752, 0.3790571898818405}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6032007329911871, 0.38046534699739654`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6066006194245839, 0.3818758156981392}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6100054158544816, 0.38328832134821006`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.61341442761235, 0.3847025757591085}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6168269308931951, 0.38611827865484016`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6202421769687457, 0.38753511941977065`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6236593970153401, 0.38895277910163123`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6270778074590189, 0.3903709326289577}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6304966157126203, 0.39178925119033015`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6339150261564351, 0.39320740471731436`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6373322462030618, 0.3946250643991043}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6407474922786282, 0.39604190516398724`}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6441599955594766, 0.3974576080597176}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.647569007317345, 0.3988718624706262}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6509738037472448, 0.4002843681206842}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6543736901806314, 0.4016948368214531}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6577680046171517, 0.4031029939369683}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.6611561205399377, 0.40450857955203}, {
          0.5879564324978332, 0.48950128467490694`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.5308081717513843, 0.40823039741900224`}, {
          0.47853841371970907`, 0.5811257687803653}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8626349217845705, 0.154194644584155}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8574534772876675, 0.15041066305731507`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.852264066543187, 0.1466208638219734}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8470673335345589, 0.14282571717582612`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8418639535724164, 0.13902571629467345`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8366546315136566, 0.13522137593177078`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8314400995540966, 0.13141323080585063`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8262211146024314, 0.1276018336833345}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8209984552557771, 0.12378775316959374`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8157729184098829, 0.1199715712333565}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8105453155497525, 0.11615388049776722`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.805316468777901, 0.11233528133986902`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8000872066472264, 0.10851637884825538`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7948583598753519, 0.10469777969039017`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7896307570151684, 0.10088008895487445`}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7844052201692622, 0.09706390701865293}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7791825608226242, 0.09324982650489089}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7739635758709468, 0.08943842938238702}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7687490439113871, 0.08563028425646912}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7635397218526345, 0.08182594389355809}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.758336341890487, 0.07802594301240527}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7531396088818628, 0.0742307963662564}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7479501981373802, 0.07044099713091631}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7427687536404802, 0.06665701560407584}, {
          0.9357856847510564, -0.07180723895569052}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8426325359379353, 0.27008036354512177`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8410693774193329, 0.2668236666901804}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8395043420934138, 0.2635630596800147}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8379375421802326, 0.2602987763147439}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8363690942566424, 0.25703105947153454`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8347991190965895, 0.25376016077174374`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8332277414772741, 0.2504863401772063}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8316550899512253, 0.24720986551528884`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8300812965846158, 0.24393101193368907`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8285064966628376, 0.24065006128704894`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8269308283649932, 0.23736730145880056`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.825354432409478, 0.23408302562284208`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8237774516736066, 0.23079753145092227`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.822200030790504, 0.22751112027280243`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8206223157272281, 0.22422409619725955`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8405610935305874, 0.2657647040052266}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8174665909693609, 0.21764943420861757`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8158888759059828, 0.21436241013311616`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8143114550229543, 0.21107599895496673`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8127344742871064, 0.2077905047830308}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8111580783316069, 0.20450622894706344`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8095824100337531, 0.20122346911882164`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8080076101119764, 0.19794251847217983`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8064338167453557, 0.19466366489058537`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8048611652193175, 0.19138719022866327`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8032897875999891, 0.1881133696341321}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8017198124399372, 0.18484247093433973`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.8001513645163602, 0.18157475409112514`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7985845646031724, 0.17831047072586081`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7970195292772555, 0.17504986371568992`}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6696179906739919, 
          0.29265889914392407`}, {0.7954563707586463, 0.1717931668607515}, {
          0.9684709160225906, 0.14921463126194956`}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5924770563366359, 0.6675432729226851}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6017321219438871, 0.6830594364796415}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6110290621451988, 0.6986458030021566}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6202841277524999, 0.7141619665590833}, {0.5355059845719685, 
          0.7331278342059582}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7483390959509006, 0.6271125293085595}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7480452358544104, 0.6266929716991525}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.747751253546103, 0.6262732396022882}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7474571512775289, 0.6258533362326029}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7471629313317512, 0.6254332648497252}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7468685960230288, 0.6250130287579166}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7465741476967119, 0.6245926313056495}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7462795887288179, 0.6241720758852533}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7459849215256724, 0.6237513659324767}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7456901485237462, 0.6233305049258802}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7453952721891697, 0.6229094963864135}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7451002950172178, 0.6224883438768479}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7448052195321145, 0.622067051001106}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7445100482864918, 0.6216456214036553}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7442147838608971, 0.6212240587688037}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7439194288632881, 0.620802366820023}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7436239859284005, 0.6203805493192606}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7433284577174614, 0.6199586100659313}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7430328469173613, 0.6195365528962398}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7427371562401753, 0.6191143816823435}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7424413884224697, 0.6186921003313464}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7421455462246428, 0.6182697127844082}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7418496324302336, 0.6178472230158011}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7415536498453026, 0.6174246350318148}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7412576012976132, 0.617001952869736}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7409614896359236, 0.616579180596815}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7406653177290948, 0.6161563223091288}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.740369088465386, 0.6157333821304624}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7400728047516852, 0.615310364211028}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7397764695125945, 0.614887272726315}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7394800856894482, 0.6144641118759983}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7391836562396714, 0.6140408858824167}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7388871841357303, 0.6136175989894589}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.738590672364072, 0.6131942554612616}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7382941239247172, 0.6127708595806152}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7379975418294591, 0.6123474156480947}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7377009291017762, 0.6119239279801132}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7374042887752408, 0.6115004009079297}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7371076238925317, 0.6110768387762195}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7368109375053122, 0.6106532459410589}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7365142326719573, 0.6102296267693008}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7362175124567153, 0.6098059856370445}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7359207799304757, 0.6093823269268033}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7356240381667379, 0.608958655028257}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.735327290243452, 0.6085349743346214}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7471703740486761, 0.6254438911598835}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7347337882352077, 0.6076876041515273}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7344370403108433, 0.6072639234586564}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7341402985474211, 0.6068402515598809}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.733843566020942, 0.6064165928498053}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.733546845806007, 0.6059929517173295}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7332501409724785, 0.6055693325456968}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7329534545852581, 0.6051457397105355}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7326567897027528, 0.6047221775786968}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7323601493759992, 0.6042986505066548}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7320635366484359, 0.6038751628385833}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7317669545531811, 0.6034517189060655}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7314704061137416, 0.6030283230254733}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7311738943421449, 0.6026049794972413}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7308774222382142, 0.6021816926042707}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7305809927884697, 0.601758466610668}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.730284608965217, 0.6013353057604192}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7299882737261452, 0.6009122142757011}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7296919900124701, 0.6004891963562515}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7293957607487512, 0.6000662561775795}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.729099588841913, 0.5996433978899135}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7288034771802497, 0.599220625616956}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.728507428632511, 0.5987979434549282}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7282114460476442, 0.5983753554708869}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7279155322532556, 0.5979528657022746}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7276196900553954, 0.5975304781553573}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7273239222377114, 0.5971081968043469}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7270282315605023, 0.5966860255904538}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7267326207604264, 0.5962639684207731}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.726437092549452, 0.5958420291674471}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7261416496146003, 0.5954202116666539}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7258462946169382, 0.5949985197179246}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7255510301913595, 0.5945769570830637}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7252558589457491, 0.5941555274855934}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7249607834606616, 0.5937342346098453}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7246658062887178, 0.5933130821002849}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.724370929954121, 0.5928920735608206}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7240761569521983, 0.5924712125542232}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7237814897490504, 0.592050502601436}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7234869307811462, 0.5916299471810605}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.723192482454841, 0.5912095497287949}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7228981471461288, 0.5907893136369748}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7226039272003373, 0.5903692422541017}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7223098249317765, 0.5899493388844084}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7220158426234385, 0.5895296067875675}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.7217219825269622, 0.589110049178152}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6966002075658309, 0.5633639777779523}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6898355060934214, 0.5640051784310144}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.683045635254796, 0.5646487647938266}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6762384071749274, 0.5652939963843321}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6942135177753666, 0.5635902031418543}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6626062260209014, 0.5665861396509589}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6557989979410237, 0.5672313712415045}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6490091271023957, 0.5678749576042521}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6422444256299895, 0.568516158257307}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6587644121381078, 0.5543549890041866}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6552953230721995, 0.556302392392527}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6518184113046035, 0.558254187122703}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6483347293076646, 0.5602097823800622}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6448454002839651, 0.5621685476452432}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6413516094907814, 0.5641298175634951}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6378545932749616, 0.5660928981009651}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6343556260891908, 0.5680570738324411}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6308560059258154, 0.5700216161183077}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6273570387400178, 0.5719857918497483}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6238600225242139, 0.573948872387247}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.620366231731026, 0.5759101423054961}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6168769027073151, 0.5778689075706407}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6133932207104054, 0.579824502828053}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6099163089427854, 0.5817762975581899}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.6064472198768821, 0.5837237009465471}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5889886041224687, 0.5821744502937342}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5886946964083273, 0.5830403210021042}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5884006425611831, 0.5839066222276098}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5881064458372407, 0.5847733443771378}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5878121095470523, 0.5856404776976827}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5875176370548799, 0.5865080122778692}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5872230317781457, 0.5873759380497292}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5869282971868273, 0.5882442447906306}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5866334368025974, 0.5891129221253407}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5863384541981899, 0.5899819595284307}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5860433529964794, 0.59085134632669}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5857481368695473, 0.591721071701919}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5854528095377274, 0.5925911246937198}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5851573747685983, 0.5934614942026758}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5848618363757768, 0.594332168993597}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5845661982178052, 0.595203137698994}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5842704641968349, 0.596074388822719}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5839746382574355, 0.5969459107439129}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5836787243851971, 0.5978176917209592}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5833827266051363, 0.5986897198957141}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5830866489804096, 0.5995619832979767}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5827904956105671, 0.6004344698499803}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5824942706301833, 0.6013071673712533}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5821979782069263, 0.6021800635834196}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5819016225400591, 0.6030531461153441}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5816052078584983, 0.6039264025083613}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5813087384190365, 0.6047998202215682}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5810122185045673, 0.6056733866374346}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5807156524219143, 0.6065470890673071}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5804190445004437, 0.6074209147574202}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.580122399089167, 0.6082948508943644}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5798257205557982, 0.6091688846115317}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.579529013283666, 0.610043002994729}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5792322816703436, 0.610917193088646}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5789355301251619, 0.611791441902929}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5786387630675162, 0.6126657364185739}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5783419849232864, 0.6135400635937996}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5780452001260538, 0.6144144103715437}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5777484131103446, 0.6152887636844846}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5774516283132077, 0.6161631104622595}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5771548501691722, 0.6170374376375503}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5768580831114521, 0.6179117321531691}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5765613315666333, 0.6187859809675742}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5762645999531455, 0.619660171061441}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5759678926811037, 0.6205342894446689}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5756712141476368, 0.6214083231617917}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.575374568736493, 0.6222822592987938}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5750779608150037, 0.6231560849888873}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5747813947322936, 0.6240297874187515}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5744848748178796, 0.6249033538346263}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5741884053784128, 0.6257767715478382}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5738919906968141, 0.6266500279408337}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5735956350299296, 0.6275231104727633}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5732993426067021, 0.628396006684943}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5730031176263186, 0.6292687042062047}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5727069642564983, 0.6301411907582213}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5724108866317145, 0.6310134541604673}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5721148888516588, 0.6318854823352259}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5718189749793825, 0.6327572633122568}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5715231490400322, 0.6336287852334576}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5712274150190788, 0.6345000363571982}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5709317768611082, 0.6353710050625859}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5706362384682763, 0.6362416798535089}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.570340803699141, 0.6371120493624645}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5700454763673314, 0.6379821023542664}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5697502602403858, 0.6388518277294858}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5694551590386752, 0.639721214527756}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.569160176434257, 0.6405902519308357}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5688653160500392, 0.6414589292655543}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5685705814586955, 0.6423272360064392}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5682759761819777, 0.6431951617783099}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5679815036897906, 0.644062696358497}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5676871673996287, 0.6449298296790472}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5673929706756834, 0.6457965518285683}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5670989168285331, 0.6466628530540734}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.6772551995171581, 0.6485774052758186}, {
          0.5668050091143872, 0.6475287237624532}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.6913680241862259, 0.6926970905918393}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.677796394405426, 0.6715953093642004}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.6889783309156022, 0.6889814878667316}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.6505154691272443, 0.6291776980526422}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.6369438393464589, 0.6080759168249963}, {0.7928058789607131, 
          0.5676451732108818}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.6396291358011582, 0.628948539061231}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.6360214746422928, 0.6271277998487024}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5574662824494732, 0.5874820259041632}, {0.6615894336786612, 
          0.48330273075943886`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.601793340373427, 0.6199395502874478}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.6008675940497774, 0.6197402460267394}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5999414451632472, 0.61954085509814}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5990149014895778, 0.6193413791756689}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.598087970918151, 0.6191418199578379}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5971606614511046, 0.6189421791674329}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5962329812022917, 0.61874245855128}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5953049383961279, 0.6185426598800288}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5943765413664203, 0.6183427849478581}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5934477985549753, 0.6181428355722403}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5925187185102072, 0.6179428135935247}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5915893098855862, 0.6177427208747035}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5906595814379632, 0.617542559301081}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5897295420258821, 0.617342330779829}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5887992006076787, 0.6171420372395459}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5878685662395289, 0.6169416806299748}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5869376480733949, 0.6167412629214652}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5860064553548571, 0.616540786104438}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5850749974208588, 0.6163402521890945}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5841432836972987, 0.6161396632046825}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5832113236965752, 0.6159390211992071}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5822791270150126, 0.6157383282386297}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5813467033302253, 0.6155375864064037}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.580414062398267, 0.6153367978030333}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5794812140508797, 0.6151359645450759}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5785481681924646, 0.6149350887648917}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5776149347970534, 0.6147341726098137}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5766815239052239, 0.6145332182414175}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5757479456208292, 0.6143322278350593}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5748142101077893, 0.6141312035788972}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.573880327586663, 0.6139301476732933}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5729463083312408, 0.6137290623300999}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5720121626650178, 0.6135279497719422}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5710779009576934, 0.6133268122311769}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5701435336214211, 0.6131256519495701}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5692090711072468, 0.6129244711771191}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5682745239013356, 0.6127232721712873}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5673399025211391, 0.6125220571964552}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5664052175116421, 0.6123208285228386}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5654704794414531, 0.6121195884257249}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5645356988989314, 0.6119183391847759}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5636008864882907, 0.6117170830828866}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5626660528255413, 0.611515822405879}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5982751909645586, 0.6191821266293123}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5607963642443224, 0.6111132964747055}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5598615305815645, 0.610912035797759}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5589267181709124, 0.6107107796958958}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5579919376283531, 0.6105095304550974}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5570571995581316, 0.6103082903581587}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5561225145486699, 0.6101070616843873}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5551878931684532, 0.6099058467096291}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5542533459625545, 0.6097046477037409}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5533188834483894, 0.6095034669312817}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5523845161121053, 0.6093023066497177}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5514502544047853, 0.6091011691089162}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5505161087385698, 0.6089000565507084}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.549582089483136, 0.6086989712075559}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5486482069620047, 0.6084979153019754}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5477144714489736, 0.6082968910457911}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5467808931645833, 0.608095900639445}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5458474822727439, 0.6078949462710801}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5449142488773383, 0.6076940301159722}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5439812030189148, 0.60749315433583}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5430483546715315, 0.6072923210778458}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5421157137395753, 0.607091532474452}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5411832900547813, 0.606890790642255}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5402510933732323, 0.606690097681654}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5393191333725007, 0.6064894556761782}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5383874196489452, 0.6062888666917718}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5374559617149375, 0.6060883327764365}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5365247689964114, 0.6058878559593983}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.535593850830276, 0.6056874382508904}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5346632164621276, 0.6054870816413069}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.533732875043923, 0.6052867881010252}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5328028356318383, 0.6050865595797612}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5318731071842145, 0.6048863980061758}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5309436985595887, 0.604686305287364}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5300146185148256, 0.6044862833086221}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5290858757033778, 0.6042863339330053}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5281574786736698, 0.6040864590008328}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5272294358675151, 0.6038866603295848}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5263017556186912, 0.6036869397134406}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.525374446151649, 0.6034872989230387}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5244475155802257, 0.6032877397051951}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.523520971906552, 0.6030882637827338}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5225948230200337, 0.6028888728541179}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5216690766963716, 0.6026895685933997}, {0.5879564324978332, 
          0.48950128467490694`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5320175323578064, 0.647759011577033}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.5298225089596778, 0.6485816658653228}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.5355059845719685, 0.7331278342059582}, {
          0.4820268659338814, 0.6664945914093175}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{-0.5057876068371856, 
          0.6404572017026267}, {-0.6329616916112083, 
          0.5622287501694422}, {-0.7821960843307232, 0.5669228418843191}}], 
          0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2695211048129541, -0.19026632109148064`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2697565665359375, -0.19181329280233733`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2699922942831916, -0.19336201227926922`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27022827325192444`, -0.19491238226872293`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27046448809630774`, -0.1964643019493801}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27070092294544856`, -0.19801766705022592`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27093756142504444`, -0.19957236999300357`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27117438668284577`, -0.20112830005912843`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2714113814176937, -0.20268534358100748`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2716485279123193, -0.20424338415707763`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2718858080695598, -0.2058023028897349}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2721232034517993, -0.20736197864485473`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2723606953235344, -0.20892228833111742`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27259826469659765`, -0.21048310719721633`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2728358923776939, -0.2120443091444642}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2730735590181941, -0.21360576705209003`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2698539448148446, -0.19245306321090322`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27354893131075847`, -0.2167289391729255}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27378659795108107`, -0.2182903970805791}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2740242256322399, -0.2198515990278167}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27426179500530584`, -0.22141241789391417`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27449928687702235`, -0.22297272758018108`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27473668225925596`, -0.22453240333529922`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27497396241648925`, -0.22609132206796195`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27521110891112904`, -0.22764936264402952`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27544810364597844`, -0.2292064061659085}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2756849289037686, -0.2307623362320347}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.27592156738337603`, -0.23231703917480873`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2761580022325051, -0.23387040427565678`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2763942170768927, -0.2354223239563135}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2766301960456238, -0.23697269394576842`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2768659237928827, -0.23852141342269972`}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.2771013855158659, -0.2400683851335546}, {-0.19759694549236073`, \
-0.22669168761106917`}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5288722610656917, -0.18747798635879379`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5276380424768387, -0.18461781934090868`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.526402576775665, -0.18175476227618625`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5251659248935586, -0.17888895636647148`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5239281497745363, -0.17602054747767132`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5226893163197889, -0.173149686011208}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5214494913214511, -0.1702765267505849}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5202087433855735, -0.16740122868283913`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5189671428442126, -0.16452395479482704`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5177247616567879, -0.16164487184469897`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5164816733010528, -0.1587641501090965}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5152379526538801, -0.15588196310702862`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5139936758625918, -0.1529984873015555}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5127489202072547, -0.1501139017809429}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5115037639551252, -0.14722838792086482`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5102582862075006, -0.14434212903009958`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5090125667407753, -0.14145530998168498`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5077666858421926, -0.13856811683242387`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5269094087957776, -0.18292929022498333`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5052747624410874, -0.13279335603442766`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.504028881542453, -0.12990616288519002`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5027831620757564, -0.1270193438367634}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5015376843281203, -0.12413308494600264`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.5002925280759752, -0.12124757108593053`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.49904777242067117`, -0.11836298556530434`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.4978034956293475, -0.11547950975984775`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.49655977498217957`, -0.11259732275777601`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.49531668662644757`, -0.10971660102217393`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.49407430543902897`, -0.1068375180720431}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.4928327048976591, -0.10396024418403293`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.4915919569617863, -0.10108494611628502`}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.490352131963452, -0.0982117868556628}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.4891132985087003, -0.095340925389199}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.4878755233896793, -0.09247251650039914}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.4866388715075689, -0.0896067105906855}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.48540340580640107`, -0.08674365352596265}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[
          BezierCurveBox[{{-0.3490255448364592, -0.20364301861396683`}, \
{-0.4841691872175437, -0.08388348650807691}, {-0.6640159034467774, \
-0.06771845425290435}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.633455387132299, 0.5227070941960467}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.633504334368929, 0.5238481805753676}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6335533019619697, 0.5249897415146649}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6336022895363422, 0.5261317682709836}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6336512967118306, 0.5272742519790099}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6337003231028667, 0.528417183652064}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6337493683188875, 0.529560554183108}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6337984319640582, 0.530704354345887}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6338475136376015, 0.5318485747961779}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6338966129336654, 0.5329932060731163}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6339457294414932, 0.5341382386006279}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6339948627454483, 0.5352836626889939}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6340440124250643, 0.536429468536476}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6340931780551808, 0.537575646231068}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6341423592059402, 0.5387221857523574}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6341915554429971, 0.53986907697345}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6342407663274171, 0.5410163096630493}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6342899914159811, 0.5421638734876214}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6343392302611219, 0.5433117580136246}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6343884824111216, 0.5444599527099045}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6344377474101627, 0.5456084469501301}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6344870247983909, 0.5467572300153695}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6345363141122266, 0.5479062910967266}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6345856148842653, 0.5490556192981276}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6346349266434693, 0.5502052036391287}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6346842489153888, 0.551355033057891}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6347335812220828, 0.5525050964141721}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6347829230825125, 0.5536553824924785}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6348322740125236, 0.5548058800052352}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6348816335248892, 0.5559565775960836}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.63493100112976, 0.55710746384324}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6349803763344517, 0.5582585272629259}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6350297586439434, 0.5594097563128698}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6350791475607436, 0.5605611393959123}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6351285425851295, 0.5617126648636017}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6351779432154718, 0.562864321019944}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6352273489481618, 0.5640160961251258}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6352767592779079, 0.5651679783993347}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6353261736978305, 0.5663199560266233}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6353755916997023, 0.5674720171588219}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6354250127742574, 0.5686241499194461}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6354744364107126, 0.569776342407725}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6355238620977179, 0.5709285827025652}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6355732893236887, 0.5720808588665708}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6356227175727314, 0.5732331589502786}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6336500570047886, 0.5272453512094729}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6357215751049027, 0.575537783041089}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6357710033572788, 0.5766900831246549}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6358204305824801, 0.5778423592886937}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6358698562698668, 0.5789945995835153}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6359192799062031, 0.5801467920717993}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6359687009806374, 0.5812989248324284}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6360181189825307, 0.582450985964627}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6360675334025039, 0.5836029635919128}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6361169437322527, 0.5847548458661228}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6361663494648869, 0.5859066209713067}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6362157500952423, 0.5870582771276476}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.636265145119686, 0.5882098025953317}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6363145340364795, 0.5893611856783759}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6363639163459585, 0.5905124147283216}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6364132915506904, 0.5916634781480046}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6364626591555566, 0.5928143643951604}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6365120186679227, 0.593965061986014}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6365613695979003, 0.5951155594987643}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6366107114583492, 0.5962658455770724}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6366600437650641, 0.5974159089333575}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6367093660369381, 0.5985657383521205}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.636758677796186, 0.5997153226931204}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6368079785682007, 0.6008646508945206}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6368572678820347, 0.6020137119758815}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6369065452702698, 0.6031624950411153}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6369558102692979, 0.6043109892813396}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6370050624192672, 0.6054591839776262}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6370543012644235, 0.6066070685036319}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6371035263530112, 0.6077546323281948}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.637152737237428, 0.6089018650178017}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6372019334744797, 0.6100487562388871}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6372511146252537, 0.6111952957601737}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.637300280255348, 0.6123414734547719}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6373494299349817, 0.613487279302254}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6373985632389252, 0.6146327033906189}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6374476797467569, 0.6157777359181312}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6374967790428131, 0.6169223671950668}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.637545860716349, 0.6180665876453586}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6375949243615422, 0.6192103878081368}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6376439695775427, 0.6203537583391827}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6376929959686157, 0.6214966900122366}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6377420031440751, 0.6226391737202662}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6377909907184536, 0.6237812004765795}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6378399583114888, 0.6249227614158784}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7928058789607131, 0.5676451732108818}, {
          0.6378889055481233, 0.6260638477952}, {0.47853841371970907`, 
          0.5811257687803653}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8060103715005142, -0.47507624615554633`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8063276355664444, -0.47526299464558647`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8066450315775366, -0.47544982080144294`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8069625571029191, -0.4756367231921643}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8072802096777515, -0.47582370036693405`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8075979868033258, -0.4760107508550196}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8079158859476164, -0.47619787316593476`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.808233904545377, -0.47638506578967915`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8085520399985587, -0.4765723271971013}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8088702896766423, -0.47675965583981955`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8091886509172255, -0.47694705015055344`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8095071210261364, -0.4771345085435581}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8098256972781659, -0.47732202941468216`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8101443769173269, -0.4775096111418476}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.81046315715771, -0.4776972520849425}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8107820351835965, -0.47788495058669}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8111010081503006, -0.47807270497268906`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8114200731847138, -0.4782605135517291}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8117392273859663, -0.4784483746163151}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8120584678259901, -0.4786362864428585}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.812377791550253, -0.47882424729235534`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8126971955785204, -0.4790122554105013}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.813016676905519, -0.47920030902838273`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8133362325017263, -0.47938840636267666`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8136558593141958, -0.479576545616427}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8139755542672598, -0.47976472497929895`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8142953142636872, -0.4799529426278604}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8146151361849332, -0.4801411967269466}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8149350168928234, -0.48032948542898246`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8152549532297501, -0.4805178068755351}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8155749420200599, -0.48070615919736986`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8158949800709535, -0.4808945405148273}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8162150641730916, -0.48108294893922404`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8165351911021111, -0.4812713825724228}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8168553576193662, -0.4814598395079946}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8171755604728084, -0.4816483178319829}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8174957963985039, -0.4818368156228075}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8178160621210288, -0.4820253309529451}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8181363543553188, -0.48221386188828286`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8184566698070176, -0.48240240648996313`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8187770051740713, -0.4825909628142007}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8190973571475412, -0.4827795289135232}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8194177224131123, -0.48296810283658553`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8197380976513042, -0.4831566826305209}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8200584795399716, -0.48334526633916575`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8072721741987302, -0.4758189705102287}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8206992499702422, -0.4837224376696595}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8210196318592893, -0.48391102137765024`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8213400070976384, -0.4840996011713067}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8216603723631009, -0.4842881750945642}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8219807243365268, -0.48447674119395956`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8223010597035373, -0.48466529751828286`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8226213751553315, -0.48485384211978344`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8229416673895945, -0.4850423730551768}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8232619331121266, -0.4852308883852711}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8235821690378027, -0.4854193861761639}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8239023718912121, -0.4856078645002142}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8242225384084317, -0.48579632143584855`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8245426653374123, -0.48598475506910455`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8248627494396401, -0.4861731634933439}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8251827874904288, -0.48636154481097693`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.825502776280815, -0.4865498971326925}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8258227126177202, -0.48673821857928673`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8261425933256068, -0.4869265072812994}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8264624152469059, -0.4871147613803229}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8267821752432828, -0.487302979028988}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8271018701963858, -0.48749115839178625`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8274214970088358, -0.48767929764554346`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.827741052605063, -0.4878673949798443}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8280605339320342, -0.48805544859771066`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8283799379602956, -0.4882434567158852}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.82869926168456, -0.4884314175654025}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8290185021245696, -0.4886193293919531}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8293376563258138, -0.48880719045650783`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8296567213602445, -0.48899499903557475`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.829975694326933, -0.48918275342159306`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8302945723528451, -0.48937045192330936`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8306133525931961, -0.489558092866434}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8309320322324258, -0.48974567459350793`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8312506084844061, -0.48993319546470376`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8315690785933182, -0.49012065385769116`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8318874398339098, -0.4903080481684199}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8322056895119946, -0.49049537681114824`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8325238249651801, -0.49068263821854896`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8328418435629104, -0.4908698308423571}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8331597427072098, -0.4910569531532509}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8334775198327904, -0.491244003641343}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8337951724076298, -0.4914309808160738}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8341126979330015, -0.4916178832068348}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8344300939440951, -0.4918047093626713}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.8347473580100319, -0.49199145785272613`}, {
          0.846095136401614, -0.4398448834823321}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7132800126278543, -0.523320658460449}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7134809784500992, -0.5227957618310732}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7136820278508995, -0.5222706469053834}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7138831592904139, -0.5217453177051375}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7140843712073186, -0.5212197783083368}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7142856620189793, -0.5206940328488658}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7144870301213984, -0.5201680855159009}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7146884738896703, -0.5196419405534958}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.7148899916781405, -0.5191156022600035}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.715091581820563, -0.5185890749873475}, {
          0.6501004142760554, -0.4718746709915811}}], 0.022180518242995356`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.7946625931089262, -0.5272228205259317}, {
          0.71529324